/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.conversions;

import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.multimatrix.MultiMatrix;

public final class SplitChannels
extends Executor
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_PORT_PREFIX = "output_";
    private boolean requireInput = true;

    public SplitChannels() {
        this.useVisibleResultParameter();
        this.addInputMat(DEFAULT_INPUT_PORT);
    }

    public boolean isRequireInput() {
        return this.requireInput;
    }

    public SplitChannels setRequireInput(boolean requireInput) {
        this.requireInput = requireInput;
        return this;
    }

    @Override
    public void process() {
        MultiMatrix source = this.getInputMat(!this.requireInput).toMultiMatrix();
        if (source == null) {
            return;
        }
        int m = source.numberOfChannels();
        for (int k = 0; k < m; ++k) {
            String portName = this.outputPortName(k);
            if (!this.isOutputNecessary(portName)) continue;
            this.getMat(portName).setTo(MultiMatrix.ofMono(source.channel(k)));
        }
    }

    private String outputPortName(int outputIndex) {
        return OUTPUT_PORT_PREFIX + (outputIndex + 1);
    }
}

