/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.arithmetic;

import java.util.Arrays;
import java.util.List;
import net.algart.arrays.FloatArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesOperation;
import net.algart.executors.modules.core.matrices.arithmetic.MatrixNormalize2DVector;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class MatrixDoubleAngleOf2DVector
extends SeveralMultiMatricesOperation {
    public static final String INPUT_X = "x";
    public static final String INPUT_Y = "y";
    public static final String OUTPUT_X = "x";
    public static final String OUTPUT_Y = "y";
    public static final String OUTPUT_MAGNITUDE = "magnitude";
    public static final String OUTPUT_XY = "xy";
    private MatrixNormalize2DVector.ResultForZeroVector resultForZeroVector = MatrixNormalize2DVector.ResultForZeroVector.X0_Y1;
    private boolean normalizedSource = false;
    private boolean normalizedResult = false;

    public MatrixDoubleAngleOf2DVector() {
        super("x", "y");
        this.addOutputMat("x");
        this.addOutputMat("y");
        this.addOutputMat(OUTPUT_XY);
        this.setDefaultOutputMat(OUTPUT_MAGNITUDE);
    }

    public MatrixNormalize2DVector.ResultForZeroVector getResultForZeroVector() {
        return this.resultForZeroVector;
    }

    public MatrixDoubleAngleOf2DVector setResultForZeroVector(MatrixNormalize2DVector.ResultForZeroVector resultForZeroVector) {
        this.resultForZeroVector = MatrixDoubleAngleOf2DVector.nonNull(resultForZeroVector);
        return this;
    }

    public boolean isNormalizedSource() {
        return this.normalizedSource;
    }

    public MatrixDoubleAngleOf2DVector setNormalizedSource(boolean normalizedSource) {
        this.normalizedSource = normalizedSource;
        return this;
    }

    public boolean isNormalizedResult() {
        return this.normalizedResult;
    }

    public MatrixDoubleAngleOf2DVector setNormalizedResult(boolean normalizedResult) {
        this.normalizedResult = normalizedResult;
        return this;
    }

    @Override
    public MultiMatrix process(List<MultiMatrix> sources) {
        boolean necessaryXY = this.isOutputNecessary(OUTPUT_XY);
        boolean requestX = this.isOutputNecessary("x") || necessaryXY;
        boolean requestY = this.isOutputNecessary("y") || necessaryXY;
        MultiMatrix2D[] result = this.process(MultiMatrix.asMultiMatrices2D(sources), requestX, requestY);
        if (requestX) {
            this.getMat("x").setTo(result[1]);
        }
        if (requestY) {
            this.getMat("y").setTo(result[2]);
        }
        if (necessaryXY) {
            this.getMat(OUTPUT_XY).setTo(MultiMatrix.of2D(Arrays.asList(result[1].channel(0), result[2].channel(0))));
        }
        return result[0];
    }

    public MultiMatrix2D[] process(List<MultiMatrix2D> sources, boolean requestX, boolean requestY) {
        Matrix<? extends PArray> magnitude;
        Matrix<? extends PArray> sin;
        Matrix<? extends PArray> cos;
        Matrix<? extends PArray> x = sources.get(0).intensityChannel();
        Matrix<? extends PArray> y = sources.get(1).intensityChannel();
        if (this.normalizedSource) {
            cos = x;
            sin = y;
            magnitude = Matrices.constantMatrix((double)1.0, FloatArray.class, (long[])x.dimensions());
        } else {
            try (MatrixNormalize2DVector normalize2DVector = new MatrixNormalize2DVector();){
                normalize2DVector.setResultForZeroVector(this.resultForZeroVector);
                magnitude = normalize2DVector.magnitude(x, y);
                cos = normalize2DVector.normalizeX(x, y, magnitude);
                sin = normalize2DVector.normalizeY(x, y, magnitude);
            }
        }
        MultiMatrix2D[] result = new MultiMatrix2D[3];
        result[0] = MultiMatrix.of2DMono(magnitude);
        if (requestX) {
            result[1] = !this.normalizedSource && !this.normalizedResult ? MultiMatrix.of2DMono((Matrix<? extends PArray>)Matrices.asFuncMatrix((Func)new AbstractFunc(this){

                public double get(double ... x) {
                    return this.get(x[0], x[1], x[2]);
                }

                public double get(double cos, double sin, double r) {
                    return (cos * cos - sin * sin) * r;
                }
            }, FloatArray.class, cos, sin, magnitude)).clone() : MultiMatrix.of2DMono((Matrix<? extends PArray>)Matrices.asFuncMatrix((Func)new AbstractFunc(this){

                public double get(double ... x) {
                    return this.get(x[0], x[1]);
                }

                public double get(double cos, double sin) {
                    return cos * cos - sin * sin;
                }
            }, FloatArray.class, cos, sin)).clone();
        }
        if (requestY) {
            result[2] = !this.normalizedSource && !this.normalizedResult ? MultiMatrix.of2DMono((Matrix<? extends PArray>)Matrices.asFuncMatrix((Func)new AbstractFunc(this){

                public double get(double ... x) {
                    return this.get(x[0], x[1], x[2]);
                }

                public double get(double cos, double sin, double r) {
                    return 2.0 * cos * sin * r;
                }
            }, FloatArray.class, cos, sin, magnitude)).clone() : MultiMatrix.of2DMono((Matrix<? extends PArray>)Matrices.asFuncMatrix((Func)new AbstractFunc(this){

                public double get(double ... x) {
                    return this.get(x[0], x[1]);
                }

                public double get(double cos, double sin) {
                    return 2.0 * cos * sin;
                }
            }, FloatArray.class, cos, sin)).clone();
        }
        return result;
    }
}

