/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.arithmetic;

import java.util.List;
import java.util.Objects;
import net.algart.arrays.FloatArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesOperation;
import net.algart.math.functions.Func;
import net.algart.math.functions.Func2;
import net.algart.multimatrix.MultiMatrix;

public final class MatrixArctangent
extends SeveralMultiMatricesOperation {
    public static final String INPUT_X = "x";
    public static final String INPUT_Y = "y";
    private AngleRange angleRange = AngleRange.ZERO_2PI_AS_0_1;
    private double epsilonForLittleSquare = -1.0;
    private double resultForLittleSquare = 0.0;

    public MatrixArctangent() {
        super(INPUT_X, INPUT_Y);
    }

    public AngleRange getAngleRange() {
        return this.angleRange;
    }

    public void setAngleRange(AngleRange angleRange) {
        this.angleRange = MatrixArctangent.nonNull(angleRange);
    }

    public double getEpsilonForLittleSquare() {
        return this.epsilonForLittleSquare;
    }

    public void setEpsilonForLittleSquare(double epsilonForLittleSquare) {
        this.epsilonForLittleSquare = epsilonForLittleSquare;
    }

    public double getResultForLittleSquare() {
        return this.resultForLittleSquare;
    }

    public void setResultForLittleSquare(double resultForLittleSquare) {
        this.resultForLittleSquare = resultForLittleSquare;
    }

    @Override
    public MultiMatrix process(List<MultiMatrix> sources) {
        Objects.requireNonNull(sources, "Null sources");
        return MultiMatrix.of2DMono((Matrix<? extends PArray>)Matrices.asFuncMatrix((Func)((Func2)(x, y) -> x * x + y * y <= this.epsilonForLittleSquare ? this.resultForLittleSquare : this.angleRange.correctAtan2(Math.atan2(y, x))), FloatArray.class, sources.get(0).asMultiMatrix2D().intensityChannel(), sources.get(1).asMultiMatrix2D().intensityChannel())).clone();
    }

    public static enum AngleRange {
        ZERO_2PI_AS_0_1{

            @Override
            double correctAtan2(double atan2) {
                double angle = atan2 * 0.15915494309189535;
                return angle < 0.0 ? angle + 1.0 : angle;
            }
        }
        ,
        MINUS_PI_PLUS_PI_AS_MINUS_HALF_PLUS_HALF{

            @Override
            double correctAtan2(double atan2) {
                return atan2 * 0.15915494309189535;
            }
        }
        ,
        MINUS_PI_PLUS_PI_AS_0_1{

            @Override
            double correctAtan2(double atan2) {
                return atan2 * 0.15915494309189535 + 0.5;
            }
        };

        private static final double MULTIPLIER = 0.15915494309189535;

        abstract double correctAtan2(double var1);
    }
}

