/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.logic.loops;

import net.algart.executors.api.Executor;

public final class IterationCount
extends Executor {
    public static final String OUTPUT_COUNT = "count";
    public static final String OUTPUT_COUNT_1 = "count_1";
    public static final String OUTPUT_IS_FIRST = "is_first";
    public static final String S = "s";
    public static final String X = "x";
    public static final String M = "m";
    private boolean throwExceptionIfOverflow = false;
    private long counter = 0L;

    public IterationCount() {
        this.setDefaultOutputScalar(OUTPUT_COUNT);
        this.addOutputScalar(OUTPUT_COUNT_1);
        this.addOutputScalar(OUTPUT_IS_FIRST);
        this.addInputScalar(S);
        this.addInputNumbers(X);
        this.addInputMat(M);
        this.addOutputScalar(S);
        this.addOutputNumbers(X);
        this.addOutputMat(M);
    }

    public boolean isThrowExceptionIfOverflow() {
        return this.throwExceptionIfOverflow;
    }

    public IterationCount setThrowExceptionIfOverflow(boolean throwExceptionIfOverflow) {
        this.throwExceptionIfOverflow = throwExceptionIfOverflow;
        return this;
    }

    @Override
    public void initialize() {
        this.counter = 0L;
    }

    @Override
    public void process() {
        this.getScalar(S).exchange(this.getInputScalar(S, true));
        this.getNumbers(X).exchange(this.getInputNumbers(X, true));
        this.getMat(M).exchange(this.getInputMat(M, true));
        this.getScalar(OUTPUT_COUNT).setTo(this.counter);
        this.getScalar(OUTPUT_COUNT_1).setTo(this.counter + 1L);
        this.getScalar(OUTPUT_IS_FIRST).setTo(this.counter == 0L);
        if (this.counter + 1L == Long.MAX_VALUE) {
            if (this.throwExceptionIfOverflow) {
                throw new IllegalStateException("Counter overflow: " + this.counter);
            }
            return;
        }
        ++this.counter;
    }
}

