/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.logic.ifelse.matrices;

import net.algart.executors.api.Executor;
import net.algart.executors.api.data.Port;
import net.algart.executors.modules.core.logic.ConditionStyle;

public final class IfScalarThenMatrix
extends Executor {
    public static final String INPUT_CONDITION = "if";
    public static final String INPUT_PORT_FALSE = "false";
    public static final String INPUT_PORT_TRUE = "true";
    public static final String OUTPUT_CONDITION = "if";
    private ConditionStyle conditionStyle = ConditionStyle.JAVA_LIKE;
    private boolean defaultCondition = false;
    private boolean requireInput = true;

    public IfScalarThenMatrix() {
        this.addInputScalar("if");
        this.addInputMat(INPUT_PORT_FALSE);
        this.addInputMat(INPUT_PORT_TRUE);
        this.addOutputScalar("if");
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
    }

    public ConditionStyle getConditionStyle() {
        return this.conditionStyle;
    }

    public IfScalarThenMatrix setConditionStyle(ConditionStyle conditionStyle) {
        this.conditionStyle = IfScalarThenMatrix.nonNull(conditionStyle);
        return this;
    }

    public boolean isDefaultCondition() {
        return this.defaultCondition;
    }

    public IfScalarThenMatrix setDefaultCondition(boolean defaultCondition) {
        this.defaultCondition = defaultCondition;
        return this;
    }

    public boolean isRequireInput() {
        return this.requireInput;
    }

    public IfScalarThenMatrix setRequireInput(boolean requireInput) {
        this.requireInput = requireInput;
        return this;
    }

    @Override
    public void process() {
        boolean condition = this.condition();
        this.getMat().exchange(this.getInputMat(IfScalarThenMatrix.portName(condition), !this.requireInput));
        this.getScalar("if").setTo(condition);
    }

    @Override
    public Boolean checkInputNecessary(Port inputPort) {
        if (inputPort == null) {
            return null;
        }
        String inputPortName = inputPort.getName();
        if ("if".equals(inputPortName)) {
            return null;
        }
        return IfScalarThenMatrix.portName(this.condition()).equals(inputPortName);
    }

    public boolean condition() {
        String conditionString = this.getInputScalar("if", true).getValue();
        return this.conditionStyle.toBoolean(conditionString, this.defaultCondition);
    }

    private static String portName(boolean condition) {
        return condition ? INPUT_PORT_TRUE : INPUT_PORT_FALSE;
    }
}

