/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.logic.control;

import net.algart.executors.api.Executor;
import net.algart.executors.modules.core.logic.ConditionStyle;

public final class CancelOrCopy
extends Executor {
    public static final String INPUT_CONDITION = "if";
    public static final String OUTPUT_CHECKED_CONDITION = "checked_condition";
    public static final String S1 = "s";
    public static final String X1 = "x";
    public static final String M1 = "m";
    public static final String S2 = "s2";
    public static final String X2 = "x2";
    public static final String M2 = "m2";
    public static final String S3 = "s3";
    public static final String X3 = "x3";
    public static final String M3 = "m3";
    public static final String S4 = "s4";
    public static final String X4 = "x4";
    public static final String M4 = "m4";
    public static final String S5 = "s5";
    public static final String X5 = "x5";
    public static final String M5 = "m5";
    private ConditionStyle conditionStyle = ConditionStyle.JAVA_LIKE;
    private boolean invert = false;

    public CancelOrCopy() {
        this.useVisibleResultParameter();
        this.addInputScalar(INPUT_CONDITION);
        this.addInputScalar(S1);
        this.addInputNumbers(X1);
        this.addInputMat(M1);
        this.addInputScalar(S2);
        this.addInputNumbers(X2);
        this.addInputMat(M2);
        this.addInputScalar(S3);
        this.addInputNumbers(X3);
        this.addInputMat(M3);
        this.addInputScalar(S4);
        this.addInputNumbers(X4);
        this.addInputMat(M4);
        this.addInputScalar(S5);
        this.addInputNumbers(X5);
        this.addInputMat(M5);
        this.addOutputScalar(OUTPUT_CHECKED_CONDITION);
        this.addOutputScalar(S1);
        this.addOutputNumbers(X1);
        this.addOutputMat(M1);
        this.addOutputScalar(S2);
        this.addOutputNumbers(X2);
        this.addOutputMat(M2);
        this.addOutputScalar(S3);
        this.addOutputNumbers(X3);
        this.addOutputMat(M3);
        this.addOutputScalar(S4);
        this.addOutputNumbers(X4);
        this.addOutputMat(M4);
        this.addOutputScalar(S5);
        this.addOutputNumbers(X5);
        this.addOutputMat(M5);
    }

    public ConditionStyle getConditionStyle() {
        return this.conditionStyle;
    }

    public CancelOrCopy setConditionStyle(ConditionStyle conditionStyle) {
        this.conditionStyle = CancelOrCopy.nonNull(conditionStyle);
        return this;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public CancelOrCopy setInvert(boolean invert) {
        this.invert = invert;
        return this;
    }

    @Override
    public void process() {
        boolean condition = this.condition();
        if (condition) {
            this.requestCancellingFurtherExecution();
        } else {
            this.getScalar(S1).exchange(this.getInputScalar(S1, true));
            this.getScalar(S2).exchange(this.getInputScalar(S2, true));
            this.getScalar(S3).exchange(this.getInputScalar(S3, true));
            this.getScalar(S4).exchange(this.getInputScalar(S4, true));
            this.getScalar(S5).exchange(this.getInputScalar(S5, true));
            this.getNumbers(X1).exchange(this.getInputNumbers(X1, true));
            this.getNumbers(X2).exchange(this.getInputNumbers(X2, true));
            this.getNumbers(X3).exchange(this.getInputNumbers(X3, true));
            this.getNumbers(X4).exchange(this.getInputNumbers(X4, true));
            this.getNumbers(X5).exchange(this.getInputNumbers(X5, true));
            this.getMat(M1).exchange(this.getInputMat(M1, true));
            this.getMat(M2).exchange(this.getInputMat(M2, true));
            this.getMat(M3).exchange(this.getInputMat(M3, true));
            this.getMat(M4).exchange(this.getInputMat(M4, true));
            this.getMat(M5).exchange(this.getInputMat(M5, true));
        }
        this.getScalar(OUTPUT_CHECKED_CONDITION).setTo(condition);
    }

    public boolean condition() {
        String conditionString = this.getInputScalar(INPUT_CONDITION, true).getValue();
        return this.conditionStyle.toBoolean(conditionString, false) != this.invert;
    }
}

