/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common.numbers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.PArray;
import net.algart.arrays.PNumberArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.SeveralNumbersOperation;

public abstract class SeveralNumberArraysOperation
extends SeveralNumbersOperation {
    protected SeveralNumberArraysOperation(String ... predefinedInputPortNames) {
        super(predefinedInputPortNames);
    }

    @Override
    protected SNumbers processNumbers(List<SNumbers> sources) {
        Objects.requireNonNull(sources, "Null sources list");
        ArrayList<PNumberArray> sourceList = new ArrayList<PNumberArray>();
        int[] blockLengthsArray = new int[sources.size()];
        int firstBlockLength = -1;
        int k = 0;
        for (SNumbers source : sources) {
            if (source == null) {
                sourceList.add(null);
                blockLengthsArray[k] = 0;
            } else {
                if (firstBlockLength == -1) {
                    firstBlockLength = source.getBlockLength();
                }
                sourceList.add((PNumberArray)SimpleMemoryModel.asUpdatableArray((Object)source.getArray()));
                blockLengthsArray[k] = source.getBlockLength();
            }
            ++k;
        }
        if (firstBlockLength == -1) {
            throw new IllegalArgumentException("No initialized input arrays");
        }
        PArray array = this.process(sourceList, blockLengthsArray);
        Integer resultBlockLength = this.resultBlockLength();
        return SNumbers.ofArray(array.toJavaArray(), resultBlockLength == null ? firstBlockLength : resultBlockLength);
    }

    protected abstract PArray process(List<PNumberArray> var1, int ... var2);

    protected Integer resultBlockLength() {
        return null;
    }
}

