/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common.numbers;

import java.lang.reflect.Array;
import net.algart.arrays.PArray;
import net.algart.arrays.PNumberArray;
import net.algart.arrays.UpdatablePNumberArray;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;

public abstract class NumberArrayFilter
extends NumbersFilter {
    protected NumberArrayFilter() {
    }

    @Override
    protected SNumbers processNumbers(SNumbers source) {
        int blockLength = source.getBlockLength();
        Object result = this.processJavaArray(source.getArray(), blockLength, source.n());
        if (result == null) {
            return null;
        }
        Integer resultBlockLength = this.resultBlockLength();
        return SNumbers.ofArray(result, resultBlockLength == null ? blockLength : resultBlockLength);
    }

    public final Object processUnstructuredJavaArray(Object javaArray) {
        return this.processJavaArray(javaArray, 1, Array.getLength(javaArray));
    }

    public final Object processJavaArray(Object javaArray, int blockLength, int numberOfBlocks) {
        UpdatablePNumberArray array = javaArray == null ? null : PNumberArray.as((Object)javaArray);
        PArray result = this.process(array, blockLength, numberOfBlocks);
        return result == null ? null : result.ja();
    }

    public abstract PArray process(UpdatablePNumberArray var1, int var2, int var3);

    protected Integer resultBlockLength() {
        return null;
    }
}

