/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common.matrices;

import java.util.ArrayList;
import java.util.List;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesProcessing;
import net.algart.math.functions.Func;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

abstract class BitMultiMatrixProcessing
extends SeveralMultiMatricesProcessing {
    BitMultiMatrixProcessing(String ... predefinedInputPortNames) {
        super(predefinedInputPortNames);
        if (predefinedInputPortNames.length == 0) {
            throw new IllegalArgumentException("Empty predefinedInputPortNames");
        }
    }

    public Matrix<? extends PArray> extend(Matrix<? extends PArray> matrix) {
        int d = this.zeroExtendingValue();
        return d == 0 ? matrix : matrix.subMatrix((long)(-d), (long)(-d), matrix.dimX() + (long)d, matrix.dimY() + (long)d, Matrix.ContinuationMode.ZERO_CONSTANT);
    }

    public Matrix<? extends PArray> reduce(Matrix<? extends PArray> matrix) {
        int d = this.zeroExtendingValue();
        return d == 0 ? matrix : matrix.subMatrix((long)d, (long)d, matrix.dimX() - (long)d, matrix.dimY() - (long)d).clone();
    }

    public void clearBorderInExtended(Matrix<? extends UpdatablePArray> matrix) {
        int d = this.zeroExtendingValue();
        if (d <= 0) {
            return;
        }
        long dimY = matrix.dimY();
        long dimX = matrix.dimX();
        if (dimX < 2L * (long)d || dimY < 2L * (long)d) {
            throw new IllegalArgumentException("The matrix was not extended by " + d + " pixels - " + String.valueOf(matrix));
        }
        Arrays.zeroFill((UpdatableArray)((UpdatableArray)matrix.subMatrix(0L, 0L, dimX, (long)d).array()));
        Arrays.zeroFill((UpdatableArray)((UpdatableArray)matrix.subMatrix(0L, dimY - (long)d, dimX, dimY).array()));
        Arrays.zeroFill((UpdatableArray)((UpdatableArray)matrix.subMatrix(0L, (long)d, (long)d, dimY - (long)d).array()));
        Arrays.zeroFill((UpdatableArray)((UpdatableArray)matrix.subMatrix(dimX - (long)d, (long)d, dimX, dimY - (long)d).array()));
    }

    protected boolean bitInput(int inputIndex) {
        return true;
    }

    protected boolean convertToBit(int inputIndex) {
        return true;
    }

    protected boolean zeroExtending() {
        return false;
    }

    protected int zeroExtendingValue() {
        return this.zeroExtending() ? 1 : 0;
    }

    @Override
    Object process(List<MultiMatrix> sources, boolean resultRequired) {
        ArrayList<Matrix<? extends UpdatablePArray>> bitMatrices = new ArrayList<Matrix<? extends UpdatablePArray>>();
        List<MultiMatrix2D> sources2D = MultiMatrix.asMultiMatrices2D(sources);
        int n = sources2D.size();
        for (int i = 0; i < n; ++i) {
            MultiMatrix2D source2D = sources2D.get(i);
            if (source2D == null) {
                bitMatrices.add(null);
                continue;
            }
            Matrix<? extends PArray> intensity = this.extend(source2D.intensityChannel());
            bitMatrices.add(!this.bitInput(i) ? null : (this.convertToBit(i) ? BitMultiMatrixProcessing.toBit(intensity) : Matrices.clone(intensity)));
        }
        return this.process(bitMatrices, sources2D, resultRequired);
    }

    abstract Object process(List<Matrix<? extends UpdatablePArray>> var1, List<MultiMatrix2D> var2, boolean var3);

    public static Matrix<UpdatableBitArray> toBit(Matrix<? extends PArray> intensity) {
        if (intensity == null) {
            return null;
        }
        Matrix result = Arrays.SMM.newBitMatrix(intensity.dimensions());
        Matrices.applyFunc(null, (Func)Func.IDENTITY, (Matrix)result, intensity);
        return result;
    }

    public static Matrix<UpdatableBitArray> asBit(Matrix<? extends PArray> intensity) {
        if (intensity == null) {
            return null;
        }
        return intensity.cast(UpdatableBitArray.class);
    }

    public static Matrix<UpdatableBitArray> cloneBit(Matrix<? extends BitArray> matrix) {
        if (matrix == null) {
            return null;
        }
        Matrix clone = Arrays.SMM.newBitMatrix(matrix.dimensions());
        Matrices.copy(null, (Matrix)clone, matrix);
        return clone;
    }
}

