/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common.awt;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import net.algart.executors.modules.core.common.awt.AWTFilter;

public abstract class AWTDrawer
extends AWTFilter {
    private Color color = Color.WHITE;
    private boolean antialiasing = true;
    private boolean clearSource = false;

    protected AWTDrawer() {
    }

    public Color getColor() {
        return this.color;
    }

    public AWTDrawer setColor(Color color) {
        this.color = AWTDrawer.nonNull(color);
        return this;
    }

    public boolean isClearSource() {
        return this.clearSource;
    }

    public AWTDrawer setClearSource(boolean clearSource) {
        this.clearSource = clearSource;
        return this;
    }

    public boolean isAntialiasing() {
        return this.antialiasing;
    }

    public AWTDrawer setAntialiasing(boolean antialiasing) {
        this.antialiasing = antialiasing;
        return this;
    }

    @Override
    public AWTDrawer setConvertMonoToColor(boolean convertMonoToColor) {
        super.setConvertMonoToColor(convertMonoToColor);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage process(BufferedImage source) {
        Graphics2D g = source.createGraphics();
        try {
            if (this.antialiasing) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            int dimX = source.getWidth();
            int dimY = source.getHeight();
            if (this.clearSource) {
                g.setColor(Color.BLACK);
                g.fillRect(0, 0, dimX, dimY);
            }
            g.setColor(this.color);
            this.process(g, dimX, dimY);
        }
        finally {
            g.dispose();
        }
        return source;
    }

    public abstract void process(Graphics2D var1, int var2, int var3);

    public static float truncateColor01(float v) {
        return v < 0.0f ? 0.0f : Math.min(v, 1.0f);
    }
}

