/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.build;

import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.Executor;
import net.algart.executors.api.SystemEnvironment;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.mappings.MappingSpecification;
import net.algart.executors.api.multichains.MultiChainSpecification;
import net.algart.executors.api.settings.SettingsSpecification;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.json.Jsons;

public final class ExecutorSpecificationVerifier {
    private static final List<String> POSSIBLE_BLOCK_KINDS = List.of("function", "input", "output", "data");
    private final Set<String> ids = new HashSet<String>();
    private final Set<String> instantiationNames = new HashSet<String>();
    private boolean checkClasses = false;
    private boolean thoroughWarnings = false;

    static JsonObject readExecutorSpecification(Path f, boolean ignoreOtherApps) throws IOException {
        JsonObject json;
        if (f.getFileName().toString().startsWith(".")) {
            return null;
        }
        try {
            json = Jsons.readJson(f);
        }
        catch (Exception e) {
            throw new IOException("Exception while parsing " + String.valueOf(f), e);
        }
        String app = json.getString("app", null);
        if (app == null) {
            return null;
        }
        if (!app.equals("executor")) {
            if (ignoreOtherApps) {
                return null;
            }
            if (app.equals("settings") || app.equals("main-settings") || app.equals("executors-extension") || ChainSpecification.isChainSpecificationContainer(json) || MultiChainSpecification.isMultiChainSpecification(json)) {
                return null;
            }
            throw new JsonException("Invalid app " + app + " in " + String.valueOf(f));
        }
        return json;
    }

    void verify(Path f) throws IOException {
        JsonArray controls;
        ExecutionBlock executionBlock;
        String instantiationName;
        boolean checkClasses;
        JsonObject json = ExecutorSpecificationVerifier.readExecutorSpecification(f, false);
        if (json == null) {
            return;
        }
        String id = json.getString("id", null);
        if (id == null) {
            id = json.getString("uuid", null);
        }
        if (id == null) {
            throw new JsonException("ID is not specified in " + String.valueOf(f));
        }
        if (!id.equals(id.toLowerCase())) {
            throw new JsonException("ID " + id + " is not in lower case in " + String.valueOf(f));
        }
        if (!this.ids.add(id)) {
            throw new JsonException("Duplicate of ID \"" + id + "\" in " + String.valueOf(f));
        }
        String kind = json.getString("kind", POSSIBLE_BLOCK_KINDS.get(0));
        if (!POSSIBLE_BLOCK_KINDS.contains(kind)) {
            throw new JsonException("Unsupported execution block kind \"" + kind + "\" in " + String.valueOf(f));
        }
        boolean javaExecutor = json.getString("language", "").equals("java");
        boolean bl = checkClasses = this.checkClasses && javaExecutor;
        if (checkClasses) {
            Class<?> clazz;
            JsonObject javaSection = json.getJsonObject("java");
            String className = javaSection.getString("class");
            String newInstanceMethodName = javaSection.getString("new_instance_method", null);
            instantiationName = newInstanceMethodName != null ? className + "." + newInstanceMethodName + "()" : className;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JsonException("Java execution block class " + className + " not found in " + String.valueOf(f), (Throwable)e);
            }
            if (newInstanceMethodName != null) {
                Method newInstanceMethod;
                try {
                    newInstanceMethod = clazz.getMethod(newInstanceMethodName, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new JsonException("Instantiation method " + newInstanceMethodName + " not found in class " + String.valueOf(clazz) + " in ", (Throwable)e);
                }
                try {
                    executionBlock = (ExecutionBlock)newInstanceMethod.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    throw new JsonException("Executor " + clazz.getName() + " cannot be created by " + newInstanceMethodName + " in " + String.valueOf(f), (Throwable)e);
                }
            }
            try {
                executionBlock = (ExecutionBlock)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new JsonException("Executor " + clazz.getName() + " cannot be created in " + String.valueOf(f), (Throwable)e);
            }
        }
        executionBlock = null;
        instantiationName = null;
        if (instantiationName != null && !this.instantiationNames.add(instantiationName) && this.thoroughWarnings) {
            System.out.printf("Duplicate Java class / instantiation method %s in %s%n", instantiationName, f);
        }
        LinkedHashMap<String, DataType> inputPorts = new LinkedHashMap<String, DataType>();
        LinkedHashMap<String, DataType> outputPorts = new LinkedHashMap<String, DataType>();
        try {
            ExecutorSpecificationVerifier.readPorts(inputPorts, json, "in_ports", f);
            if (json.containsKey((Object)"in_ports_hidden")) {
                ExecutorSpecificationVerifier.readPorts(inputPorts, json, "in_ports_hidden", f);
            }
            ExecutorSpecificationVerifier.readPorts(outputPorts, json, "out_ports", f);
            if (json.containsKey((Object)"out_ports_hidden")) {
                ExecutorSpecificationVerifier.readPorts(outputPorts, json, "out_ports_hidden", f);
            }
        }
        catch (RuntimeException e) {
            throw new JsonException("Error in ports specification in " + String.valueOf(f), (Throwable)e);
        }
        if (checkClasses) {
            Object dataType;
            assert (executionBlock != null);
            for (Port port : executionBlock.inputPorts()) {
                dataType = (DataType)((Object)inputPorts.get(port.getName()));
                if (dataType == null) {
                    throw new JsonException("Built-in input " + String.valueOf(port) + " is not specified in " + String.valueOf(f));
                }
                if (dataType == port.getDataType()) continue;
                throw new JsonException("Type of built-in input " + String.valueOf(port) + " is incorrectly specified in " + String.valueOf(f) + " (" + String.valueOf(dataType) + ")");
            }
            for (Port port : executionBlock.outputPorts()) {
                dataType = (DataType)((Object)outputPorts.get(port.getName()));
                if (dataType == null) {
                    throw new JsonException("Built-in output " + String.valueOf(port) + " is not specified in " + String.valueOf(f));
                }
                if (dataType == port.getDataType()) continue;
                throw new JsonException("Type of built-in output " + String.valueOf(port) + " is incorrectly specified in " + String.valueOf(f) + " (" + String.valueOf(dataType) + ")");
            }
        }
        if ((controls = json.getJsonArray("controls")) == null) {
            throw new JsonException("No controls in " + String.valueOf(f));
        }
        HashSet<String> controlNames = new HashSet<String>();
        for (JsonValue jsonValue : controls) {
            Object value3;
            if (!(jsonValue instanceof JsonObject)) {
                throw new JsonException("One of controls is not Json object in " + String.valueOf(f) + " (" + String.valueOf(jsonValue) + ")");
            }
            JsonObject control = (JsonObject)jsonValue;
            String name = control.getString("name", null);
            if (name == null) {
                throw new JsonException("One of controls has no \"name\" or has non-string  \"name\" in " + String.valueOf(f) + " (" + String.valueOf(control) + ")");
            }
            if (!controlNames.add(name)) {
                throw new JsonException("Duplicate control with name \"" + name + "\" in " + String.valueOf(f));
            }
            String valueType = control.getString("value_type", null);
            if (valueType == null) {
                throw new JsonException("One of controls has no \"value_type\" or has non-string  \"value_type\" in " + String.valueOf(f) + " (" + String.valueOf(control) + ")");
            }
            String editionType = control.getString("edition_type", null);
            if (editionType == null) {
                throw new JsonException("One of controls has no \"edition_type\" or has non-string  \"edition_type\" in " + String.valueOf(f) + " (" + String.valueOf(control) + ")");
            }
            if (!editionType.equals("enum")) continue;
            JsonArray items = control.getJsonArray("items");
            if (items == null) {
                if (control.containsKey((Object)"items_file")) continue;
                throw new JsonException("Enum control has no \"items\" in " + String.valueOf(f) + " (" + String.valueOf(control) + ")");
            }
            for (JsonValue value2 : items) {
                if (value2 instanceof JsonObject) continue;
                throw new JsonException("One of items is not Json object in " + String.valueOf(f) + " (" + String.valueOf(value2) + ")");
            }
            boolean suppressNoSetter = "visibleResult".equals(name);
            JsonArray suppressWarnings = control.getJsonArray("suppress_warnings");
            if (suppressWarnings != null) {
                for (Object value3 : suppressWarnings) {
                    if (!(value3 instanceof JsonString)) {
                        throw new JsonException("One of suppress_warnings is not string in " + String.valueOf(f) + " (" + String.valueOf(value3) + ")");
                    }
                    JsonString jsonString = (JsonString)value3;
                    if (!"no_setter".equals(jsonString.getString())) continue;
                    suppressNoSetter = true;
                }
            }
            if (!valueType.equals("String")) continue;
            HashSet<String> values = new HashSet<String>();
            value3 = items.iterator();
            while (value3.hasNext()) {
                JsonValue item = (JsonValue)value3.next();
                String value4 = ((JsonObject)item).getString("value", null);
                if (value4 == null) {
                    throw new JsonException("One of items has no \"value\" or has non-string \"value\" in " + String.valueOf(f) + " (" + String.valueOf(item) + ")");
                }
                if (values.add(value4)) continue;
                throw new JsonException("Several items have identical \"value\":\"" + value4 + "\" in " + String.valueOf(f));
            }
            String defaultValue = control.getString("default", null);
            if (defaultValue == null) {
                throw new JsonException("Enum string control has no \"default\" or has non-string  \"default\" in " + String.valueOf(f) + " (" + String.valueOf(control) + ")");
            }
            if (!values.contains(defaultValue)) {
                throw new JsonException("Enum string control has unknown \"default\":\"" + defaultValue + "\" (not listed among items) " + String.valueOf(f) + " (" + String.valueOf(control) + ")");
            }
            if (!checkClasses || !(executionBlock instanceof Executor)) continue;
            Class<?> type = ((Executor)executionBlock).parameterJavaType(name);
            if (type == null) {
                if (suppressNoSetter) continue;
                System.out.printf("There is no automatic property setter for enum string control \"%s\" in %s%n", name, f);
                continue;
            }
            if (!type.isEnum()) continue;
            assert (Enum.class.isAssignableFrom(type));
            HashSet<String> enumNames = new HashSet<String>();
            for (Enum e : type.asSubclass(Enum.class).getEnumConstants()) {
                if (this.thoroughWarnings && !values.contains(e.name())) {
                    System.out.println("Enum string control has no item with value \"" + e.name() + "\" (one of possible values of " + type.getSimpleName() + ") in " + String.valueOf(f));
                }
                enumNames.add(e.name());
            }
            for (String value5 : values) {
                if (enumNames.contains(value5)) continue;
                throw new JsonException("Enum string control has item with unknown value \"" + value5 + "\" (not one of possible values of " + String.valueOf(type) + ") in " + String.valueOf(f) + " (" + String.valueOf(control) + ")");
            }
        }
        try {
            ExecutorSpecification.of(json);
        }
        catch (Exception e) {
            throw new JsonException("Some problem detected while parsing " + String.valueOf(f), (Throwable)e);
        }
        if (checkClasses) {
            executionBlock.close();
        }
    }

    private void verifyAll(Path folder) throws IOException {
        try (DirectoryStream<Path> files = Files.newDirectoryStream(folder);){
            for (Path file : files) {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    this.verifyAll(file);
                    continue;
                }
                if (!this.needToCheck(file)) continue;
                this.verify(file);
            }
        }
    }

    private boolean needToCheck(Path path) {
        return ExecutorSpecification.isExecutorSpecificationFile(path) || ChainSpecification.isChainSpecificationFile(path) || SettingsSpecification.isSettingsSpecificationFile(path) || MappingSpecification.isMappingSpecificationFile(path);
    }

    private static void readPorts(Map<String, DataType> result, JsonObject conf, String portArrayName, Path f) {
        JsonArray ports = conf.getJsonArray(portArrayName);
        if (ports == null) {
            throw new JsonException("No \"" + portArrayName + "\" section in " + String.valueOf(f));
        }
        for (JsonValue value : ports) {
            DataType dataType;
            if (!(value instanceof JsonObject)) {
                throw new JsonException("One of ports is not Json object: " + String.valueOf(value));
            }
            JsonObject port = (JsonObject)value;
            String name = Jsons.reqString(port, "name", f);
            if (result.put(name, dataType = DataType.ofTypeName(Jsons.reqString(port, "value_type", f))) == null) continue;
            throw new JsonException("Duplicate port with name \"" + name + "\" in " + String.valueOf(f));
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        ExecutorSpecificationVerifier verifier = new ExecutorSpecificationVerifier();
        int startArgIndex = 0;
        if (args.length > startArgIndex && args[startArgIndex].equals("-check_classes")) {
            verifier.checkClasses = true;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equals("-thorough")) {
            verifier.thoroughWarnings = true;
            ++startArgIndex;
        }
        if (args.length == startArgIndex) {
            System.out.printf("Usage: %s [-check_classes] [-thorough] folder1_with_json_files folder2_with_json_files...s%n", ExecutorSpecificationVerifier.class.getName());
            return;
        }
        if (!verifier.checkClasses) {
            System.out.printf("Java classes of executors will NOT be checked%n", new Object[0]);
        }
        try {
            for (int k = startArgIndex; k < args.length; ++k) {
                String path = SystemEnvironment.replaceHomeEnvironmentVariable(args[k]);
                Path folder = Paths.get(path, new String[0]);
                System.out.printf("Verifying folder %s...%n", folder);
                verifier.verifyAll(folder);
            }
        }
        catch (IOException | RuntimeException e) {
            System.out.println();
            Thread.sleep(300L);
            throw e;
        }
        System.out.printf("O'k%n", new Object[0]);
    }
}

