/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.build;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import net.algart.executors.api.Executor;
import net.algart.executors.api.system.ExecutorSpecification;

public class ExecutorSpecificationBuilder {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.printf("Usage: %s ExecutorClassName result_executor_specification.json%n", ExecutorSpecificationBuilder.class.getName());
            return;
        }
        String className = args[0];
        Path resultFile = Paths.get(args[1], new String[0]);
        Executor executor = (Executor)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        ExecutorSpecification executorSpecification = ExecutorSpecification.of(executor, UUID.randomUUID().toString());
        executorSpecification.write(resultFile, StandardOpenOption.CREATE_NEW);
        System.out.printf("JSON specification for %s successfully stored in %s%n", executor.getClass(), resultFile);
        executor.close();
    }
}

