/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.system;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.system.ExecutorLoader;
import net.algart.executors.api.system.ExecutorSpecification;

public class DefaultExecutorLoader<W>
extends ExecutorLoader {
    private final Map<String, Map<String, W>> idToWorkerMap = new LinkedHashMap<String, Map<String, W>>();
    private final Object lock = new Object();

    public DefaultExecutorLoader(String name) {
        super(name);
    }

    @Override
    protected ExecutionBlock loadExecutor(String sessionId, ExecutorSpecification specification) throws ClassNotFoundException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerWorker(String sessionId, ExecutorSpecification specification, W worker) {
        Objects.requireNonNull(sessionId, "Null sessionId");
        Objects.requireNonNull(specification, "Null specification");
        Objects.requireNonNull(worker, "Null worker");
        Object object = this.lock;
        synchronized (object) {
            this.setSpecification(sessionId, specification);
            W previosWorker = this.setWorker(sessionId, specification.getId(), worker);
            try {
                if (previosWorker instanceof AutoCloseable) {
                    ((AutoCloseable)previosWorker).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return previosWorker != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public W registeredWorker(String sessionId, String executorId) {
        Objects.requireNonNull(sessionId, "Null sessionId");
        Objects.requireNonNull(executorId, "Null executorId");
        Object object = this.lock;
        synchronized (object) {
            W result = this.getWorker("$~~GLOBAL-SESSION~~_699d349b-3312-4d5d-8fc4-0444dd2b387f", executorId);
            if (result != null) {
                return result;
            }
            result = this.getWorker(sessionId, executorId);
            if (result == null) {
                throw new IllegalStateException("Cannot find registered worker with id \"" + executorId + "\" for session \"" + sessionId + "\"");
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSession(String sessionId) {
        super.clearSession(sessionId);
        Object object = this.lock;
        synchronized (object) {
            this.idToWorkerMap.remove(sessionId);
        }
    }

    private W getWorker(String sessionId, String executorId) {
        return (W)this.idToWorkerMap.computeIfAbsent(sessionId, k -> new LinkedHashMap()).get(executorId);
    }

    private W setWorker(String sessionId, String executorId, W worker) {
        return this.idToWorkerMap.computeIfAbsent(sessionId, k -> new LinkedHashMap()).put(executorId, worker);
    }
}

