/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.settings.core;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.List;
import java.util.stream.Collectors;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.parameters.ParameterValueType;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.api.settings.core.SettingsExecutor;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.json.Jsons;
import net.algart.json.PropertyChecker;

public class GetNamesOfSettings
extends SettingsExecutor
implements ReadOnlyExecutionInput {
    private ResultType resultType = ResultType.RAW_LINES;
    private String resultJsonKey = "names";
    private boolean extractIntType = true;
    private boolean extractLongType = true;
    private boolean extractFloatType = true;
    private boolean extractDoubleType = true;
    private boolean extractBooleanType = true;
    private boolean extractStringType = true;
    private boolean extractEnumType = true;
    private boolean extractSettingsType = true;

    public GetNamesOfSettings() {
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public GetNamesOfSettings setResultType(ResultType resultType) {
        this.resultType = GetNamesOfSettings.nonNull(resultType);
        return this;
    }

    public String getResultJsonKey() {
        return this.resultJsonKey;
    }

    public GetNamesOfSettings setResultJsonKey(String resultJsonKey) {
        this.resultJsonKey = GetNamesOfSettings.nonNull(resultJsonKey);
        return this;
    }

    public boolean isExtractIntType() {
        return this.extractIntType;
    }

    public GetNamesOfSettings setExtractIntType(boolean extractIntType) {
        this.extractIntType = extractIntType;
        return this;
    }

    public boolean isExtractLongType() {
        return this.extractLongType;
    }

    public GetNamesOfSettings setExtractLongType(boolean extractLongType) {
        this.extractLongType = extractLongType;
        return this;
    }

    public boolean isExtractFloatType() {
        return this.extractFloatType;
    }

    public GetNamesOfSettings setExtractFloatType(boolean extractFloatType) {
        this.extractFloatType = extractFloatType;
        return this;
    }

    public boolean isExtractDoubleType() {
        return this.extractDoubleType;
    }

    public GetNamesOfSettings setExtractDoubleType(boolean extractDoubleType) {
        this.extractDoubleType = extractDoubleType;
        return this;
    }

    public boolean isExtractBooleanType() {
        return this.extractBooleanType;
    }

    public GetNamesOfSettings setExtractBooleanType(boolean extractBooleanType) {
        this.extractBooleanType = extractBooleanType;
        return this;
    }

    public boolean isExtractStringType() {
        return this.extractStringType;
    }

    public GetNamesOfSettings setExtractStringType(boolean extractStringType) {
        this.extractStringType = extractStringType;
        return this;
    }

    public boolean isExtractEnumType() {
        return this.extractEnumType;
    }

    public GetNamesOfSettings setExtractEnumType(boolean extractEnumType) {
        this.extractEnumType = extractEnumType;
        return this;
    }

    public boolean isExtractSettingsType() {
        return this.extractSettingsType;
    }

    public GetNamesOfSettings setExtractSettingsType(boolean extractSettingsType) {
        this.extractSettingsType = extractSettingsType;
        return this;
    }

    @Override
    public void process() {
        this.setSystemOutputs();
        SettingsBuilder combiner = this.settingsBuilder();
        List<String> names = combiner.specification().getControls().values().stream().filter(this::isMatched).map(ControlSpecification::getName).collect(Collectors.toList());
        this.getScalar().setTo(this.resultType.result(names, this.resultJsonKey));
    }

    @Override
    public String toString() {
        return "Get names of " + String.valueOf(this.settingsBuilder != null ? this.settingsBuilder : "some non-initialized settings");
    }

    private boolean isMatched(ControlSpecification controlSpecification) {
        return switch (controlSpecification.getValueType()) {
            case ParameterValueType.INT -> this.extractIntType;
            case ParameterValueType.LONG -> this.extractLongType;
            case ParameterValueType.FLOAT -> this.extractFloatType;
            case ParameterValueType.DOUBLE -> this.extractDoubleType;
            case ParameterValueType.BOOLEAN -> this.extractBooleanType;
            case ParameterValueType.STRING -> this.extractStringType;
            case ParameterValueType.ENUM_STRING -> this.extractEnumType;
            case ParameterValueType.SETTINGS -> this.extractSettingsType;
            default -> false;
        };
    }

    public static enum ResultType {
        RAW_LINES{

            @Override
            String result(List<String> names, String jsonKey) {
                return String.join((CharSequence)"\n", names);
            }
        }
        ,
        JSON{

            @Override
            String result(List<String> names, String jsonKey) {
                PropertyChecker.nonEmpty(jsonKey, "Empty result json key");
                JsonObjectBuilder builder = Json.createObjectBuilder();
                JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                for (String name : names) {
                    arrayBuilder.add(name);
                }
                builder.add(jsonKey, (JsonValue)arrayBuilder.build());
                return Jsons.toPrettyString(builder.build());
            }
        };


        abstract String result(List<String> var1, String var2);
    }
}

