/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.settings;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.io.MatrixIO;
import net.algart.json.AbstractConvertibleToJson;
import net.algart.json.Jsons;

public final class SettingsSpecification
extends AbstractConvertibleToJson {
    public static final String SETTINGS_FILE_PATTERN = ".*\\.(json|ss|mss)$";
    public static final String APP_NAME = "settings";
    public static final String APP_NAME_FOR_MAIN = "main-settings";
    public static final String CURRENT_VERSION = "1.0";
    public static final String SUBSETTINGS_PREFIX = "@";
    public static final String SYSTEM_PREFIX = "$";
    public static final String CLASS_KEY = "$class";
    public static final String SETTINGS = "settings";
    public static final String DEFAULT_SETTINGS_CATEGORY = "settings";
    public static final String DEFAULT_SETTINGS_CATEGORY_PREFIX = "settings.";
    public static final String DEFAULT_SETTINGS_COMBINE_PREFIX = "Combine ";
    public static final String DEFAULT_SETTINGS_SPLIT_PREFIX = "Split ";
    public static final String DEFAULT_SETTINGS_GET_NAMES_PREFIX = "Get names of ";
    private static final Pattern COMPILED_SETTINGS_FILE_PATTERN = Pattern.compile(".*\\.(json|ss|mss)$");
    private static final String APP_NAME_ALIAS = "settings-combiner";
    private static final String APP_NAME_FOR_MAIN_ALIAS = "main-settings-combiner";
    private static final int CODE_FOR_MAIN = 2;
    private static final int CODE_FOR_ORDINARY = 1;
    private static final int CODE_FOR_INVALID = 0;
    private Path specificationFile = null;
    private boolean main = false;
    private String version = "1.0";
    private boolean autogeneratedCategory = false;
    private String category;
    private boolean autogeneratedName = false;
    private String name;
    private String combineName = null;
    private String splitName = null;
    private String getNamesName = null;
    private String className = null;
    private String description = null;
    private String combineDescription = null;
    private String splitDescription = null;
    private String getNamesDescription = null;
    private String id;
    private String splitId = null;
    private String getNamesId = null;
    private Map<String, ControlSpecification> controls = new LinkedHashMap<String, ControlSpecification>();
    private Set<String> tags = new LinkedHashSet<String>();
    private String platformId = null;
    private String platformCategory = null;

    public SettingsSpecification() {
    }

    private SettingsSpecification(JsonObject json, boolean strictMode, Path file) {
        int settingsType = SettingsSpecification.settingsType(json);
        if (settingsType == 0 && strictMode) {
            throw new JsonException("JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + " is not a settings specification: no \"app\":\"settings\" or \"app\":\"main-settings\" element");
        }
        this.specificationFile = file;
        this.main = settingsType == 2;
        this.version = json.getString("version", CURRENT_VERSION);
        this.category = json.getString("category", null);
        if (this.category == null) {
            this.category = "settings";
            this.autogeneratedCategory = true;
        }
        Path fileName = file == null ? null : file.getFileName();
        this.name = json.getString("name", null);
        if (this.name == null) {
            this.name = fileName == null ? "settings" : MatrixIO.removeExtension((String)fileName.toString());
            this.autogeneratedName = true;
        }
        SettingsSpecification.checkSettingsName(this.name, file);
        this.combineName = json.getString("combine_name", null);
        this.splitName = json.getString("split_name", null);
        this.getNamesName = json.getString("get_names_name", null);
        this.className = json.getString("class_name", null);
        this.description = json.getString("description", null);
        this.combineDescription = json.getString("combine_description", this.description);
        this.splitDescription = json.getString("split_description", this.description);
        this.getNamesDescription = json.getString("get_names_description", this.description);
        this.id = Jsons.reqString(json, "id", file);
        this.splitId = json.getString("split_id", null);
        this.getNamesId = json.getString("get_names_id", null);
        for (JsonObject jsonObject : Jsons.reqJsonObjects(json, "controls", file)) {
            ControlSpecification control = new ControlSpecification(jsonObject, file);
            String name = control.getName();
            SettingsSpecification.checkParameterName(name, file);
            this.controls.put(name, control);
        }
    }

    public static SettingsSpecification read(Path specificationFile) throws IOException {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        JsonObject json = Jsons.readJson(specificationFile);
        return new SettingsSpecification(json, true, specificationFile);
    }

    public static SettingsSpecification readIfValid(Path specificationFile) {
        return SettingsSpecification.readIfValid(specificationFile, false);
    }

    public static SettingsSpecification readIfValid(Path specificationFile, boolean onlyMainSettings) {
        JsonObject json;
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        try {
            json = Jsons.readJson(specificationFile);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        int settingsType = SettingsSpecification.settingsType(json);
        if (settingsType == 0 || onlyMainSettings && settingsType != 2) {
            return null;
        }
        return new SettingsSpecification(json, true, specificationFile);
    }

    public static List<SettingsSpecification> readAllIfValid(Path containingJsonPath, boolean recursive, boolean onlyMainSettings) throws IOException {
        return ExecutorSpecification.readAllIfValid(null, containingJsonPath, recursive, path -> SettingsSpecification.readIfValid(path, onlyMainSettings), SettingsSpecification::isSettingsSpecificationFile);
    }

    public void write(Path specificationFile, OpenOption ... options) throws IOException {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        Files.writeString(specificationFile, (CharSequence)Jsons.toPrettyString(this.toJson()), options);
    }

    public static SettingsSpecification of(String specificationString) {
        return SettingsSpecification.of(Jsons.toJson(specificationString));
    }

    public static SettingsSpecification of(JsonObject specificationJson) {
        return SettingsSpecification.of(specificationJson, true);
    }

    public static SettingsSpecification of(JsonObject specificationJson, boolean strictMode) {
        return new SettingsSpecification(specificationJson, strictMode, null);
    }

    public static boolean isSettingsSpecificationFile(Path specificationFile) {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        return COMPILED_SETTINGS_FILE_PATTERN.matcher(specificationFile.getFileName().toString().toLowerCase()).matches();
    }

    public static boolean isSettingsSpecification(JsonObject specificationJson) {
        return SettingsSpecification.settingsType(specificationJson) != 0;
    }

    public static boolean isSettingsKey(String key) {
        Objects.requireNonNull(key, "Null key");
        return key.startsWith(SUBSETTINGS_PREFIX);
    }

    public static void checkIdDifference(Collection<SettingsSpecification> settingsSpecifications) {
        Objects.requireNonNull(settingsSpecifications, "Null settings specifications collection");
        HashSet<String> ids = new HashSet<String>();
        for (SettingsSpecification settingsSpecification : settingsSpecifications) {
            String id = settingsSpecification.getId();
            assert (id != null);
            String splitId = settingsSpecification.getSplitId();
            String getNamesId = settingsSpecification.getGetNamesId();
            if (id.equals(splitId)) {
                throw new IllegalArgumentException("Identical id and split_id for settings \"" + settingsSpecification.getName() + "\": " + id);
            }
            if (id.equals(getNamesId)) {
                throw new IllegalArgumentException("Identical id and get_names_id for settings \"" + settingsSpecification.getName() + "\": " + id);
            }
            if (splitId != null && splitId.equals(getNamesId)) {
                throw new IllegalArgumentException("Identical split_id and get_names_id for settings \"" + settingsSpecification.getName() + "\": " + splitId);
            }
            if (!ids.add(id)) {
                throw new IllegalArgumentException("Two settings JSONs have identical IDs " + id + ", one of them is \"" + settingsSpecification.getName() + "\"");
            }
            if (splitId != null && !ids.add(splitId)) {
                throw new IllegalArgumentException("Two settings JSONs have identical IDs " + splitId + ", one of them is \"" + settingsSpecification.getName() + "\"");
            }
            if (getNamesId == null || ids.add(getNamesId)) continue;
            throw new IllegalArgumentException("Two settings JSONs have identical IDs " + getNamesId + ", one of them is \"" + settingsSpecification.getName() + "\"");
        }
    }

    public static void checkParameterName(String name, Path file) throws JsonException {
        Objects.requireNonNull(name, "Null parameter name");
        if (name.equals("settings")) {
            throw new JsonException("Non-allowed parameter name \"" + name + "\"" + (String)(file == null ? "" : " in JSON " + String.valueOf(file)));
        }
        if (!SourceVersion.isIdentifier(name)) {
            throw new JsonException("Parameter name \"" + name + "\" is not a valid Java identifier; such named are not allowed" + (String)(file == null ? "" : " in JSON " + String.valueOf(file)));
        }
    }

    public Path getSpecificationFile() {
        return this.specificationFile;
    }

    public boolean isMain() {
        return this.main;
    }

    public SettingsSpecification setMain(boolean main) {
        this.main = main;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public SettingsSpecification setVersion(String version) {
        this.version = Objects.requireNonNull(version, "Null version");
        return this;
    }

    public boolean isAutogeneratedCategory() {
        return this.autogeneratedCategory;
    }

    public String getCategory() {
        return this.category;
    }

    public SettingsSpecification setCategory(String category, boolean autogeneratedCategory) {
        this.category = Objects.requireNonNull(category, "Null category");
        this.autogeneratedCategory = autogeneratedCategory;
        return this;
    }

    public boolean isAutogeneratedName() {
        return this.autogeneratedName;
    }

    public String getName() {
        return this.name;
    }

    public SettingsSpecification setName(String name, boolean autogeneratedName) {
        Objects.requireNonNull(name, "Null name");
        SettingsSpecification.checkSettingsName(name, null);
        this.name = name;
        this.autogeneratedName = autogeneratedName;
        return this;
    }

    public String combineName() {
        return this.combineName == null ? DEFAULT_SETTINGS_COMBINE_PREFIX + this.name : this.combineName;
    }

    public String getCombineName() {
        return this.combineName;
    }

    public SettingsSpecification setCombineName(String combineName) {
        this.combineName = combineName;
        return this;
    }

    public String splitName() {
        return this.splitName == null ? DEFAULT_SETTINGS_SPLIT_PREFIX + this.name : this.splitName;
    }

    public String getSplitName() {
        return this.splitName;
    }

    public SettingsSpecification setSplitName(String splitName) {
        this.splitName = splitName;
        return this;
    }

    public String getNamesName() {
        return this.getNamesName == null ? DEFAULT_SETTINGS_GET_NAMES_PREFIX + this.name : this.getNamesName;
    }

    public String getGetNamesName() {
        return this.getNamesName;
    }

    public SettingsSpecification setGetNamesName(String getNamesName) {
        this.getNamesName = getNamesName;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public String className() {
        return this.className == null ? ExecutorSpecification.className(this.category, this.name) : this.className;
    }

    public SettingsSpecification setClassName(String className) {
        this.className = className;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public SettingsSpecification setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getCombineDescription() {
        return this.combineDescription;
    }

    public SettingsSpecification setCombineDescription(String combineDescription) {
        this.combineDescription = combineDescription;
        return this;
    }

    public String getSplitDescription() {
        return this.splitDescription;
    }

    public SettingsSpecification setSplitDescription(String splitDescription) {
        this.splitDescription = splitDescription;
        return this;
    }

    public String getGetNamesDescription() {
        return this.getNamesDescription;
    }

    public SettingsSpecification setGetNamesDescription(String getNamesDescription) {
        this.getNamesDescription = getNamesDescription;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public SettingsSpecification setId(String id) {
        this.id = Objects.requireNonNull(id, "Null id");
        return this;
    }

    public String getSplitId() {
        return this.splitId;
    }

    public SettingsSpecification setSplitId(String splitId) {
        this.splitId = splitId;
        return this;
    }

    public String getGetNamesId() {
        return this.getNamesId;
    }

    public SettingsSpecification setGetNamesId(String getNamesId) {
        this.getNamesId = getNamesId;
        return this;
    }

    public Map<String, ControlSpecification> getControls() {
        return Collections.unmodifiableMap(this.controls);
    }

    public SettingsSpecification setControls(Map<String, ControlSpecification> controls) {
        controls = ExecutorSpecification.checkControls(controls);
        for (ControlSpecification controlSpecification : controls.values()) {
            SettingsSpecification.checkParameterName(controlSpecification.getName(), null);
        }
        this.controls = controls;
        return this;
    }

    public ControlSpecification getControl(String name) {
        return this.controls.get(name);
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public SettingsSpecification setTags(Set<String> tags) {
        Objects.requireNonNull(tags, "Null tags");
        this.tags = new LinkedHashSet<String>(tags);
        return this;
    }

    public void addTags(Collection<String> tags) {
        Objects.requireNonNull(tags, "Null tags");
        this.tags.addAll(tags);
    }

    public boolean hasPlatformId() {
        return this.platformId != null;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public SettingsSpecification setPlatformId(String platformId) {
        this.platformId = platformId;
        return this;
    }

    public String getPlatformCategory() {
        return this.platformCategory;
    }

    public SettingsSpecification setPlatformCategory(String platformCategory) {
        this.platformCategory = platformCategory;
        return this;
    }

    public Set<String> controlKeySet() {
        return this.controls.values().stream().map(ControlSpecification::key).collect(Collectors.toSet());
    }

    public String parentFolderName() {
        if (this.specificationFile == null) {
            return null;
        }
        Path parent = this.specificationFile.getParent();
        if (parent == null) {
            return null;
        }
        if ((parent = parent.getFileName()) == null) {
            return null;
        }
        return parent.toString();
    }

    public void updateAutogeneratedCategory(boolean removeLastElementInClassName) {
        String parent = this.parentFolderName();
        if (parent != null && this.autogeneratedCategory) {
            String recommendedCategory;
            String string = recommendedCategory = !removeLastElementInClassName ? parent : ExecutionBlock.recommendedCategory(parent);
            if (recommendedCategory != null) {
                this.setCategory(DEFAULT_SETTINGS_CATEGORY_PREFIX + recommendedCategory, true);
            }
        }
    }

    public void updateAutogeneratedName(String className) {
        if (className != null && this.autogeneratedName) {
            this.setName(ExecutionBlock.recommendedName(className), true);
        }
    }

    public boolean hasPathControl() {
        return this.controls.values().stream().anyMatch(controlSpecification -> controlSpecification.getEditionType().isPath());
    }

    public void setTo(ExecutorSpecification specification) {
        Objects.requireNonNull(specification, "Null executor specification");
        this.setCategory(specification.getCategory(), false);
        this.setName(specification.getName(), false);
        this.setDescription(specification.getDescription());
        this.setId(specification.getId());
        LinkedHashMap<String, ControlSpecification> controls = new LinkedHashMap<String, ControlSpecification>(specification.getControls());
        controls.remove("settings");
        this.setControls(controls);
    }

    @Override
    public void checkCompleteness() {
        this.checkNull(this.category, "category");
        this.checkNull(this.name, "name");
        this.checkNull(this.id, "id");
    }

    public JsonObject toJson(boolean includeAutogenerated) {
        this.checkCompleteness();
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.buildJson(builder, includeAutogenerated);
        return builder.build();
    }

    public String toString() {
        return "SettingsSpecification{specificationFile=" + String.valueOf(this.specificationFile) + ", main=" + this.main + ", version='" + this.version + "', tags='" + String.valueOf(this.tags) + "', platformId='" + this.platformId + "', platformCategory='" + this.platformCategory + "', autogeneratedCategory=" + this.autogeneratedCategory + ", category='" + this.category + "', autogeneratedName=" + this.autogeneratedName + ", name='" + this.name + "', combineName='" + this.combineName + "', splitName='" + this.splitName + "', getNamesName='" + this.getNamesName + "', className='" + this.className + "', description='" + this.description + "', combineDescription='" + this.combineDescription + "', splitDescription='" + this.splitDescription + "', getNamesDescription='" + this.getNamesDescription + "', id='" + this.id + "', splitId='" + this.splitId + "', getNamesId='" + this.getNamesId + "', controls=" + String.valueOf(this.controls) + "}";
    }

    @Override
    public void buildJson(JsonObjectBuilder builder) {
        this.buildJson(builder, false);
    }

    public void buildJson(JsonObjectBuilder builder, boolean includeAutogenerated) {
        builder.add("app", this.main ? APP_NAME_FOR_MAIN : "settings");
        if (!this.version.equals(CURRENT_VERSION)) {
            builder.add("version", this.version);
        }
        if (includeAutogenerated || !this.autogeneratedCategory) {
            builder.add("category", this.category);
        }
        if (includeAutogenerated || !this.autogeneratedName) {
            builder.add("name", this.name);
        }
        if (this.combineName != null) {
            builder.add("combine_name", this.combineName);
        }
        if (this.splitName != null) {
            builder.add("split_name", this.splitName);
        }
        if (this.getNamesName != null) {
            builder.add("get_names_name", this.getNamesName);
        }
        if (this.className != null) {
            builder.add("class_name", this.className);
        }
        if (this.description != null) {
            builder.add("description", this.description);
        }
        if (this.combineDescription != null && !this.combineDescription.equals(this.description)) {
            builder.add("combine_description", this.combineDescription);
        }
        if (this.splitDescription != null && !this.splitDescription.equals(this.description)) {
            builder.add("split_description", this.splitDescription);
        }
        if (this.getNamesDescription != null && !this.getNamesDescription.equals(this.description)) {
            builder.add("get_names_description", this.getNamesDescription);
        }
        builder.add("id", this.id);
        if (this.splitId != null) {
            builder.add("split_id", this.splitId);
        }
        if (this.getNamesId != null) {
            builder.add("get_names_id", this.getNamesId);
        }
        JsonArrayBuilder controlsBuilder = Json.createArrayBuilder();
        for (Map.Entry<String, ControlSpecification> entry : this.controls.entrySet()) {
            ControlSpecification control = entry.getValue();
            control.checkCompleteness();
            JsonObjectBuilder controlBuilder = Json.createObjectBuilder();
            control.buildJson(controlBuilder);
            controlsBuilder.add((JsonValue)controlBuilder.build());
        }
        builder.add("controls", (JsonValue)controlsBuilder.build());
    }

    private static int settingsType(JsonObject settingsSpecification) {
        Objects.requireNonNull(settingsSpecification, "Null settings specification");
        String app = settingsSpecification.getString("app", null);
        return "settings".equals(app) || APP_NAME_ALIAS.equals(app) ? 1 : (APP_NAME_FOR_MAIN.equals(app) || APP_NAME_FOR_MAIN_ALIAS.equals(app) ? 2 : 0);
    }

    private static void checkSettingsName(String name, Path file) throws JsonException {
        if (name.contains(String.valueOf('.'))) {
            throw new JsonException("Non-allowed settings name \"" + name + "\"" + (String)(file == null ? "" : " in JSON " + String.valueOf(file)) + ": it contains \".\" character");
        }
    }

    private Path resolve(Path path, String whatFile) {
        if (path.isAbsolute()) {
            return path;
        }
        if (this.specificationFile == null) {
            throw new IllegalStateException("Name of " + whatFile + " file is relative and cannot be resolved, because settings specification was not loaded from file; you must use absolute paths in this case");
        }
        return this.specificationFile.getParent().resolve(path);
    }

    public static void main(String[] args) throws IOException {
        SettingsSpecification settingsSpecification = SettingsSpecification.read(Paths.get(args[0], new String[0]));
        System.out.println(settingsSpecification);
        System.out.println(Jsons.toPrettyString(settingsSpecification.toJson()));
    }
}

