/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.settings;

import jakarta.json.JsonObject;
import net.algart.json.Jsons;

public enum ReplaceExistingSettingsMode {
    SIMPLE{

        @Override
        public JsonObject replace(JsonObject existingSubSettings, JsonObject newSubSettings) {
            return newSubSettings;
        }
    }
    ,
    ADD_NEW{

        @Override
        public JsonObject replace(JsonObject existingSubSettings, JsonObject newSubSettings) {
            return existingSubSettings == null ? newSubSettings : Jsons.addNonExistingEntries(existingSubSettings, newSubSettings);
        }
    }
    ,
    OVERRIDE{

        @Override
        public JsonObject replace(JsonObject existingSubSettings, JsonObject newSubSettings) {
            return existingSubSettings == null ? newSubSettings : Jsons.overrideEntries(existingSubSettings, newSubSettings);
        }
    }
    ,
    OVERRIDE_ONLY_EXISTING_IN_BOTH{

        @Override
        public JsonObject replace(JsonObject existingSubSettings, JsonObject newSubSettings) {
            return existingSubSettings == null ? newSubSettings : Jsons.overrideOnlyExistingInBoth(existingSubSettings, newSubSettings);
        }
    };


    public abstract JsonObject replace(JsonObject var1, JsonObject var2);
}

