/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.multichains;

import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import net.algart.executors.api.chains.Chain;
import net.algart.executors.api.chains.ChainLoadingException;
import net.algart.executors.api.chains.ChainRunningException;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.chains.core.InterpretChain;
import net.algart.executors.api.chains.core.UseChain;
import net.algart.executors.api.multichains.MultiChainSettingsBuilder;
import net.algart.executors.api.multichains.MultiChainSpecification;
import net.algart.executors.api.multichains.core.CombineMultiChainSettings;
import net.algart.executors.api.multichains.core.MultiChainExecutor;
import net.algart.executors.api.multichains.core.UseMultiChainSettings;
import net.algart.executors.api.parameters.ParameterValueType;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.api.settings.SettingsSpecification;
import net.algart.executors.api.system.ControlEditionType;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.executors.api.system.CreateMode;
import net.algart.executors.api.system.ExecutorFactory;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.json.Jsons;

public final class MultiChain
implements Cloneable,
AutoCloseable {
    public static final String SELECTED_CHAIN_ID = "___selectedChainId";
    public static final String SELECTED_CHAIN_NAME = "___selectedChainName";
    public static final String SELECTED_CHAIN_ID_PARAMETER_CAPTION = "Selected chain";
    private static final boolean DEBUG_ALWAYS_SELECTION_BY_ID = false;
    private static final AtomicLong CURRENT_CONTEXT_ID = new AtomicLong(109099000000000L);
    private volatile long contextId;
    private final MultiChainSpecification specification;
    private final UseChain chainFactory;
    private final List<ChainSpecification> chainSpecifications;
    private final List<ChainSpecification> blockedChainSpecifications;
    private final Set<String> blockedChainSpecificationNames;
    private final List<ExecutorSpecification> loadedChainExecutorSpecifications;
    private final boolean selectionById;
    private final String firstChainId;
    private final String firstChainName;
    private String defaultChainIdOrName;
    private final SettingsBuilder multiChainOnlyCommonSettingsBuilder;
    private final MultiChainSettingsBuilder multiChainSettingsBuilder;
    private volatile Map<String, Chain> chainMap = null;
    private boolean extractSubSettings = false;

    private MultiChain(MultiChainSpecification specification, UseChain chainFactory, UseMultiChainSettings settingsFactory) throws IOException {
        this.renewContextId();
        this.specification = Objects.requireNonNull(specification, "Null specification");
        this.chainFactory = Objects.requireNonNull(chainFactory, "Null chainFactory");
        Objects.requireNonNull(settingsFactory, "Null settingsFactory");
        this.specification.checkCompleteness();
        this.chainSpecifications = specification.readChainVariants();
        this.blockedChainSpecifications = new ArrayList<ChainSpecification>();
        this.blockedChainSpecificationNames = new LinkedHashSet<String>();
        this.loadedChainExecutorSpecifications = new ArrayList<ExecutorSpecification>();
        assert (!this.chainSpecifications.isEmpty());
        HashMap<String, Chain> nonRecursiveChainMap = new HashMap<String, Chain>();
        String firstChainId = null;
        String firstChainName = null;
        for (ChainSpecification chainSpecification : this.chainSpecifications) {
            Optional<Chain> optionalChain;
            if (firstChainId == null) {
                firstChainId = chainSpecification.chainId();
                firstChainName = chainSpecification.chainName();
            }
            try {
                optionalChain = chainFactory.useIfNonRecursive(chainSpecification);
            }
            catch (ChainLoadingException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ChainRunningException("Cannot initialize the chain " + String.valueOf(chainSpecification.getSpecificationFile()) + ", variant of multi-chain " + String.valueOf(specification.getSpecificationFile()), e);
            }
            if (optionalChain.isPresent()) {
                ExecutorSpecification implementationSpecification = chainFactory.chainExecutorSpecification();
                assert (implementationSpecification != null) : "chainExecutorSpecification cannot be null if use() returns some result";
                this.loadedChainExecutorSpecifications.add(implementationSpecification);
                nonRecursiveChainMap.put(optionalChain.get().id(), optionalChain.get());
                continue;
            }
            this.blockedChainSpecifications.add(chainSpecification);
            this.blockedChainSpecificationNames.add(chainSpecification.chainName());
        }
        if (firstChainId == null) {
            throw new AssertionError((Object)"Cannot find the first chain in non-empty collection");
        }
        this.selectionById = specification.isBehaviourPreferSelectionById() || MultiChain.detectNecessityOfSelectionById(nonRecursiveChainMap.values());
        this.firstChainId = firstChainId;
        this.firstChainName = firstChainName;
        settingsFactory.setOwnerId(specification.getId());
        settingsFactory.setContextId(this.contextId);
        settingsFactory.setContextName(specification.getName());
        this.multiChainOnlyCommonSettingsBuilder = SettingsBuilder.of(this.buildMultiChainSettingsSpecification(false, nonRecursiveChainMap));
        assert (this.defaultChainIdOrName != null) : "defaultChainIdOrName must be filled in createSelectedChainIdControl()";
        settingsFactory.setMultiChain(this);
        SettingsBuilder multiChainSettingsBuilder = settingsFactory.use(this.buildMultiChainSettingsSpecification(true, nonRecursiveChainMap));
        if (!(multiChainSettingsBuilder instanceof MultiChainSettingsBuilder)) {
            throw new AssertionError((Object)"UseMultiChainSettings.use() must create MultiChainSettingsBuilder");
        }
        this.multiChainSettingsBuilder = (MultiChainSettingsBuilder)multiChainSettingsBuilder;
    }

    public static MultiChain of(MultiChainSpecification specification, UseChain chainFactory, UseMultiChainSettings settingsFactory) throws IOException {
        return new MultiChain(specification, chainFactory, settingsFactory);
    }

    public boolean isExtractSubSettings() {
        return this.extractSubSettings;
    }

    public MultiChain setExtractSubSettings(boolean extractSubSettings) {
        this.extractSubSettings = extractSubSettings;
        return this;
    }

    public MultiChainSpecification specification() {
        return this.specification;
    }

    public List<ChainSpecification> chainSpecifications() {
        return Collections.unmodifiableList(this.chainSpecifications);
    }

    public List<ChainSpecification> blockedChainSpecifications() {
        return Collections.unmodifiableList(this.blockedChainSpecifications);
    }

    public Set<String> blockedChainSpecificationNames() {
        return Collections.unmodifiableSet(this.blockedChainSpecificationNames);
    }

    public String defaultChainVariant() {
        return this.defaultChainIdOrName;
    }

    public SettingsBuilder multiChainOnlyCommonSettingsBuilder() {
        return this.multiChainOnlyCommonSettingsBuilder;
    }

    public SettingsBuilder settingsBuilder() {
        return this.multiChainSettingsBuilder;
    }

    public long contextId() {
        return this.contextId;
    }

    public Path multiChainSpecificationFile() {
        return this.specification.getSpecificationFile();
    }

    public String id() {
        return this.specification.getId();
    }

    public String category() {
        return this.specification.getCategory();
    }

    public String name() {
        return this.specification.getName();
    }

    public String description() {
        return this.specification.getDescription();
    }

    public String settingsId() {
        return this.specification.getSettingsId();
    }

    public void checkImplementationCompatibility(boolean enforceAllChecks) {
        for (ExecutorSpecification implementationSpecification : this.loadedChainExecutorSpecifications) {
            this.specification.checkImplementationCompatibility(implementationSpecification, enforceAllChecks);
        }
    }

    public UseChain \u0441hainFactory() {
        assert (this.chainFactory != null);
        return this.chainFactory;
    }

    public ExecutorFactory executorFactory() {
        assert (this.chainFactory != null);
        return this.chainFactory.executorFactory();
    }

    public Map<String, Chain> chainMap() {
        Map<String, Chain> chainMap = this.chainMap;
        if (chainMap == null) {
            this.chainMap = chainMap = this.createChainMap();
        }
        return Collections.unmodifiableMap(chainMap);
    }

    public JsonObject multiChainSettings(JsonObject parentSettings) {
        JsonObject multiChainSubSettings;
        Objects.requireNonNull(parentSettings, "Null parentSettings");
        if (parentSettings.isEmpty()) {
            return parentSettings;
        }
        if (this.extractSubSettings && (multiChainSubSettings = SettingsBuilder.getSubSettingsByName(parentSettings, this.name())) != null) {
            return multiChainSubSettings;
        }
        return parentSettings;
    }

    public String getSelectedChainVariant(JsonObject parentSettings, String defaultChainVariant) {
        JsonObject multiChainSubSettings;
        Objects.requireNonNull(parentSettings, "Null parentSettings");
        Objects.requireNonNull(defaultChainVariant, "Null defaultChainVariant");
        String result = defaultChainVariant;
        if (parentSettings.isEmpty()) {
            return result;
        }
        if (this.extractSubSettings && (multiChainSubSettings = SettingsBuilder.getSubSettingsByName(parentSettings, this.name())) != null) {
            result = multiChainSubSettings.getString(this.selectedChainParameter(), result);
        }
        return parentSettings.getString(this.selectedChainParameter(), result);
    }

    public Chain findSelectedChain(String selectedChainVariant) {
        Objects.requireNonNull(selectedChainVariant, "Null selectedChainVariant");
        Map<String, Chain> chains = this.chainMap();
        Chain selectedChain = chains.get(selectedChainVariant);
        if (selectedChain == null) {
            for (ChainSpecification specification : this.chainSpecifications) {
                if (!specification.chainName().equals(selectedChainVariant)) continue;
                selectedChain = chains.get(specification.chainId());
            }
        }
        if (selectedChain == null) {
            throw new IllegalArgumentException("Cannot find the selected chain by its ID or name: \"" + selectedChainVariant + "\"; there is no chain variant with this ID/name among all elements of this multi-chain " + String.valueOf(this));
        }
        return selectedChain;
    }

    public JsonObject selectedChainSettings(JsonObject executorSettings, JsonObject parentSettings, Chain selectedChain) {
        JsonObject onlyActual;
        JsonObject selectedSubSettings;
        Objects.requireNonNull(executorSettings, "Null executorSettings");
        Objects.requireNonNull(parentSettings, "Null parentSettings");
        Objects.requireNonNull(selectedChain, "Null selectedChain");
        SettingsBuilder mainSettingsBuilder = selectedChain.getSettingsBuilder();
        if (mainSettingsBuilder == null) {
            return null;
        }
        JsonObject result = executorSettings;
        if (parentSettings.isEmpty()) {
            return result;
        }
        if (!this.extractSubSettings) {
            return Jsons.overrideEntries(result, parentSettings);
        }
        String multiChainName = this.name();
        String selectedChainName = selectedChain.name();
        Set<String> selectedChainActualKeys = mainSettingsBuilder.settingsKeySet();
        JsonObject multiSettings = SettingsBuilder.getSubSettingsByName(parentSettings, multiChainName);
        JsonObject parentSubSettings = SettingsBuilder.getSubSettingsByName(parentSettings, selectedChainName);
        JsonObject jsonObject = selectedSubSettings = multiSettings != null && (parentSubSettings == null || !multiSettings.isEmpty()) ? SettingsBuilder.getSubSettingsByName(multiSettings, selectedChainName) : parentSubSettings;
        if (selectedSubSettings != null) {
            onlyActual = Jsons.filterJson(selectedSubSettings, selectedChainActualKeys);
            result = Jsons.overrideEntries(result, onlyActual);
        }
        if (multiSettings != null) {
            onlyActual = Jsons.filterJson(multiSettings, selectedChainActualKeys);
            result = Jsons.overrideEntries(result, onlyActual);
        }
        return SettingsBuilder.overrideEntriesExceptingGivenSettings(result, parentSettings, multiChainName, selectedChainName);
    }

    public void freeResources() {
        Map<String, Chain> chainMap = this.chainMap;
        if (chainMap != null) {
            this.chainMap = null;
            for (Chain chain : chainMap.values()) {
                chain.freeResources();
            }
        }
    }

    public CombineMultiChainSettings newCombine() {
        return this.executorFactory().newExecutor(CombineMultiChainSettings.class, this.settingsBuilder().id());
    }

    public MultiChainExecutor newExecutor(CreateMode createMode) {
        return this.executorFactory().newExecutor(MultiChainExecutor.class, this.id(), createMode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("multi-chain \"" + ExecutorSpecification.className(this.category(), this.name()) + "\", containing " + this.chainSpecifications.size() + " chains:\n");
        int n = this.chainSpecifications.size();
        for (int i = 0; i < n; ++i) {
            ChainSpecification chainchainSpecification = this.chainSpecifications.get(i);
            if (i > 0) {
                sb.append("\n");
            }
            sb.append("   \"").append(chainchainSpecification.canonicalName()).append("\", ID '").append(chainchainSpecification.chainId()).append("'");
        }
        return sb.toString();
    }

    public MultiChain clone() {
        MultiChain clone;
        try {
            clone = (MultiChain)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        clone.renewContextId();
        clone.chainMap = null;
        return clone;
    }

    @Override
    public void close() {
        this.freeResources();
    }

    public String selectedChainParameter() {
        return this.specification.isBehaviourPreferSelectionById() ? SELECTED_CHAIN_ID : SELECTED_CHAIN_NAME;
    }

    private SettingsSpecification buildMultiChainSettingsSpecification(boolean addSubSettingsForSelectedChainVariants, Map<String, Chain> helpingChainMap) {
        SettingsSpecification result = new SettingsSpecification();
        result.setId(this.specification.getSettingsId());
        result.setName(this.specification.getName(), this.specification.isAutogeneratedName());
        result.setCombineName(this.specification.getSettingsName());
        result.setCategory(this.specification.getSettingsCategory(), this.specification.isAutogeneratedSettingsCategory());
        LinkedHashMap<String, ControlSpecification> controls = new LinkedHashMap<String, ControlSpecification>();
        ControlSpecification currentChainIdControl = this.createSelectedChainIdControl();
        controls.put(currentChainIdControl.getName(), currentChainIdControl);
        controls.putAll(this.specification.getControls());
        if (addSubSettingsForSelectedChainVariants) {
            String specificationFileMessage = this.specification.getSpecificationFile() == null ? "" : " (problem occurred in multi-chain, loaded from the file " + String.valueOf(this.specification.getSpecificationFile()) + ")";
            for (ChainSpecification chainSpecification : this.chainSpecifications) {
                SettingsBuilder mainSettingsBuilder;
                ChainSpecification.Executor executor = chainSpecification.getExecutor();
                String name = executor.getName();
                try {
                    SettingsSpecification.checkParameterName(name, null);
                }
                catch (JsonException e) {
                    throw new IllegalArgumentException("Chain variant name \"" + name + "\" is invalid name, not allowed as a parameter name in the settings" + specificationFileMessage, e);
                }
                ControlSpecification settingsControlSpecification = new ControlSpecification().setValueType(ParameterValueType.SETTINGS).setName(name).setDescription(executor.getDescription()).setEditionType(ControlEditionType.VALUE).setAdvanced(true).setMultiline(true);
                Chain chain = helpingChainMap.get(chainSpecification.chainId());
                if (chain != null && (mainSettingsBuilder = chain.getSettingsBuilder()) != null) {
                    SettingsSpecification specification = mainSettingsBuilder.specification();
                    settingsControlSpecification.setSettingsId(specification.getId());
                    settingsControlSpecification.setValueClassName(specification.className());
                }
                if (controls.put(name, settingsControlSpecification) == null) continue;
                throw new IllegalArgumentException("Chain variant name \"" + name + "\" has a name, identical to one of multi-chain parameters; this is not allowed" + specificationFileMessage);
            }
        }
        result.setControls(controls);
        result.checkCompleteness();
        return result;
    }

    private ControlSpecification createSelectedChainIdControl() {
        ArrayList<ControlSpecification.EnumItem> items = new ArrayList<ControlSpecification.EnumItem>();
        String defaultChainVariantId = this.specification.getDefaultChainVariantId();
        String defaultChainVariantName = this.specification.getDefaultChainVariantName();
        String defaultValue = this.selectionById ? defaultChainVariantId : defaultChainVariantName;
        for (ChainSpecification sp : this.chainSpecifications) {
            boolean probablyDefault;
            Object itemCaption;
            String itemValue;
            if (this.selectionById) {
                itemValue = sp.chainId();
                itemCaption = sp.chainName() + " [" + sp.chainId() + "]";
                probablyDefault = sp.chainName().equals(defaultChainVariantName);
            } else {
                itemValue = sp.chainName();
                itemCaption = sp.chainName();
                probablyDefault = sp.chainId().equals(defaultChainVariantId);
            }
            if (defaultValue == null && probablyDefault) {
                defaultValue = itemValue;
            }
            items.add(new ControlSpecification.EnumItem(itemValue).setCaption((String)itemCaption));
        }
        if (defaultValue == null) {
            defaultValue = this.selectionById ? this.firstChainId : this.firstChainName;
        }
        this.defaultChainIdOrName = defaultValue;
        ControlSpecification result = new ControlSpecification();
        result.setName(this.selectedChainParameter());
        result.setCaption(SELECTED_CHAIN_ID_PARAMETER_CAPTION);
        result.setValueType(ParameterValueType.ENUM_STRING);
        result.setEditionType(ControlEditionType.ENUM);
        result.setItems(items);
        result.setDefaultStringValue(defaultValue);
        return result;
    }

    private Map<String, Chain> createChainMap() {
        LinkedHashMap<String, Chain> result = new LinkedHashMap<String, Chain>();
        for (ChainSpecification chainSpecification : this.chainSpecifications) {
            String executorId = chainSpecification.chainId();
            Chain chain = InterpretChain.registeredChain(this.chainFactory.getSessionId(), executorId);
            if (this.specification.isBehaviourSettingsRequired() && !chain.hasSettings()) {
                throw new IllegalStateException("Chain \"" + chain.name() + " \" (ID \"" + chain.id() + "\") of multi-chain \"" + this.name() + "\" (ID \"" + this.id() + "\") has no built-in main settings; this is not allowed in this multi-chains (settings are required)");
            }
            result.put(executorId, chain);
        }
        return result;
    }

    private void renewContextId() {
        this.contextId = CURRENT_CONTEXT_ID.getAndIncrement();
    }

    private static boolean detectNecessityOfSelectionById(Collection<Chain> chainVariants) {
        HashSet<String> uniqueNames = new HashSet<String>();
        for (Chain chain : chainVariants) {
            if (uniqueNames.add(chain.id()) && uniqueNames.add(chain.name())) continue;
            return true;
        }
        return false;
    }
}

