/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.mappings;

import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.parameters.ParameterValueType;
import net.algart.executors.api.system.ControlEditionType;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.io.MatrixIO;
import net.algart.json.AbstractConvertibleToJson;
import net.algart.json.Jsons;

public final class MappingSpecification
extends AbstractConvertibleToJson {
    public static final String MAPPING_FILE_PATTERN = ".*\\.(json|map|mapping)$";
    public static final String APP_NAME = "mapping";
    public static final String CURRENT_VERSION = "1.0";
    public static final String MAPPING = "mapping";
    public static final String DEFAULT_MAPPING_CATEGORY = "mappings";
    public static final String DEFAULT_MAPPING_CATEGORY_PREFIX = "mappings.";
    private static final Pattern COMPILED_MAPPING_FILE_PATTERN = Pattern.compile(".*\\.(json|map|mapping)$");
    private Path specificationFile = null;
    private String version = "1.0";
    private boolean autogeneratedCategory = false;
    private String category;
    private boolean autogeneratedName = false;
    private String name;
    private String className = null;
    private String description = null;
    private String id;
    private ControlTemplate controlTemplate;
    private String keysFile = null;
    private String enumItemsFile = null;
    private List<String> keys = null;
    private List<String> enumItems = null;
    private Set<String> importantKeys = null;
    private Set<String> ignoredKeys = null;

    public MappingSpecification() {
    }

    private MappingSpecification(JsonObject json, boolean strictMode, Path file) {
        if (!MappingSpecification.isMappingSpecification(json) && strictMode) {
            throw new JsonException("JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + " is not a mapping configuration: no \"app\":\"mapping\" element");
        }
        this.specificationFile = file;
        this.version = json.getString("version", CURRENT_VERSION);
        this.category = json.getString("category", null);
        if (this.category == null) {
            this.category = DEFAULT_MAPPING_CATEGORY;
            this.autogeneratedCategory = true;
        }
        String fileName = file == null ? null : file.getFileName().toString();
        this.name = json.getString("name", null);
        if (this.name == null) {
            this.name = fileName == null ? "mapping" : MatrixIO.removeExtension((String)fileName);
            this.autogeneratedName = true;
        }
        MappingSpecification.checkMappingName(this.name, file);
        this.className = json.getString("class_name", null);
        this.description = json.getString("description", null);
        this.id = Jsons.reqString(json, "id", file);
        JsonObject controlTemplateJson = json.getJsonObject("control_template");
        this.controlTemplate = controlTemplateJson == null ? new ControlTemplate() : new ControlTemplate(Jsons.reqJsonObject(json, "control_template"), file);
        this.keysFile = json.getString("keys_file", null);
        this.enumItemsFile = json.getString("enum_items_file", null);
        this.keys = MappingSpecification.toNames(new ArrayList(), Jsons.getJsonArray(json, "keys", file), "keys");
        this.enumItems = MappingSpecification.toNames(new ArrayList(), Jsons.getJsonArray(json, "enum_items", file), "enum_items");
        this.importantKeys = MappingSpecification.toNames(new LinkedHashSet(), Jsons.getJsonArray(json, "important_keys", file), "important_keys");
        this.ignoredKeys = MappingSpecification.toNames(new LinkedHashSet(), Jsons.getJsonArray(json, "ignored_keys", file), "ignored_keys");
    }

    public static MappingSpecification read(Path specificationFile) throws IOException {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        JsonObject json = Jsons.readJson(specificationFile);
        return new MappingSpecification(json, true, specificationFile);
    }

    public static MappingSpecification readIfValid(Path specificationFile) {
        JsonObject json;
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        try {
            json = Jsons.readJson(specificationFile);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        if (!MappingSpecification.isMappingSpecification(json)) {
            return null;
        }
        return new MappingSpecification(json, true, specificationFile);
    }

    public static List<MappingSpecification> readAllIfValid(Path containingJsonPath) throws IOException {
        return ExecutorSpecification.readAllIfValid(null, containingJsonPath, true, MappingSpecification::readIfValid, MappingSpecification::isMappingSpecificationFile);
    }

    public void write(Path specificationFile, OpenOption ... options) throws IOException {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        Files.writeString(specificationFile, (CharSequence)Jsons.toPrettyString(this.toJson()), options);
    }

    public static MappingSpecification of(JsonObject specificationJson, boolean strictMode) {
        return new MappingSpecification(specificationJson, strictMode, null);
    }

    public static boolean isMappingSpecificationFile(Path specificationFile) {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        return COMPILED_MAPPING_FILE_PATTERN.matcher(specificationFile.getFileName().toString().toLowerCase()).matches();
    }

    public static boolean isMappingSpecification(JsonObject mappingSpecification) {
        Objects.requireNonNull(mappingSpecification, "Null mappingSpecification");
        return "mapping".equals(mappingSpecification.getString("app", null));
    }

    public static void checkIdDifference(Collection<MappingSpecification> mappingSpecifications) {
        Objects.requireNonNull(mappingSpecifications, "Null mapping JSONs collection");
        HashSet<String> ids = new HashSet<String>();
        for (MappingSpecification mappingSpecification : mappingSpecifications) {
            String id = mappingSpecification.getId();
            assert (id != null);
            if (ids.add(id)) continue;
            throw new IllegalArgumentException("Two mapping JSONs have identical IDs " + id + ", one of them is \"" + mappingSpecification.getName() + "\"");
        }
    }

    public Path getSpecificationFile() {
        return this.specificationFile;
    }

    public String getVersion() {
        return this.version;
    }

    public MappingSpecification setVersion(String version) {
        this.version = Objects.requireNonNull(version, "Null version");
        return this;
    }

    public boolean isAutogeneratedCategory() {
        return this.autogeneratedCategory;
    }

    public String getCategory() {
        return this.category;
    }

    public MappingSpecification setCategory(String category, boolean autogeneratedCategory) {
        this.category = Objects.requireNonNull(category, "Null category");
        this.autogeneratedCategory = autogeneratedCategory;
        return this;
    }

    public boolean isAutogeneratedName() {
        return this.autogeneratedName;
    }

    public String getName() {
        return this.name;
    }

    public MappingSpecification setName(String name, boolean autogeneratedName) {
        Objects.requireNonNull(name, "Null name");
        MappingSpecification.checkMappingName(name, null);
        this.name = name;
        this.autogeneratedName = autogeneratedName;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public String className() {
        return this.className == null ? ExecutorSpecification.className(this.category, this.name) : this.className;
    }

    public MappingSpecification setClassName(String className) {
        this.className = className;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public MappingSpecification setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public MappingSpecification setId(String id) {
        this.id = Objects.requireNonNull(id, "Null id");
        return this;
    }

    public ControlTemplate getControlTemplate() {
        return this.controlTemplate;
    }

    public MappingSpecification setControlTemplate(ControlTemplate controlTemplate) {
        this.controlTemplate = Objects.requireNonNull(controlTemplate, "Null controlTemplate");
        return this;
    }

    public String getKeysFile() {
        return this.keysFile;
    }

    public MappingSpecification setKeysFile(String keysFile) {
        this.keysFile = keysFile;
        return this;
    }

    public String getEnumItemsFile() {
        return this.enumItemsFile;
    }

    public MappingSpecification setEnumItemsFile(String enumItemsFile) {
        this.enumItemsFile = enumItemsFile;
        return this;
    }

    public boolean hasKeys() {
        return this.keys != null;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public MappingSpecification setKeys(List<String> keys) {
        this.keys = keys;
        return this;
    }

    public boolean hasEnumItems() {
        return this.enumItems != null;
    }

    public List<String> getEnumItems() {
        return this.enumItems;
    }

    public MappingSpecification setEnumItems(List<String> enumItems) {
        this.enumItems = enumItems;
        return this;
    }

    public Set<String> getImportantKeys() {
        return this.importantKeys;
    }

    public MappingSpecification setImportantKeys(Set<String> importantKeys) {
        this.importantKeys = importantKeys;
        return this;
    }

    public Set<String> getIgnoredKeys() {
        return this.ignoredKeys;
    }

    public MappingSpecification setIgnoredKeys(Set<String> ignoredKeys) {
        this.ignoredKeys = ignoredKeys;
        return this;
    }

    public ControlEditionType editionTypeOrDefault() {
        if (this.controlTemplate.editionType != null) {
            return this.controlTemplate.editionType;
        }
        return this.hasEnumItems() || this.enumItemsFile != null ? ControlEditionType.ENUM : ControlEditionType.VALUE;
    }

    public String parentFolderName() {
        if (this.specificationFile == null) {
            return null;
        }
        Path parent = this.specificationFile.getParent();
        if (parent == null) {
            return null;
        }
        if ((parent = parent.getFileName()) == null) {
            return null;
        }
        return parent.toString();
    }

    public void updateAutogeneratedCategory(boolean removeLastElementInClassName) {
        String parent = this.parentFolderName();
        if (parent != null && this.autogeneratedCategory) {
            String recommendedCategory;
            String string = recommendedCategory = !removeLastElementInClassName ? parent : ExecutionBlock.recommendedCategory(parent);
            if (recommendedCategory != null) {
                this.setCategory(DEFAULT_MAPPING_CATEGORY_PREFIX + recommendedCategory, true);
            }
        }
    }

    public boolean isEnum() {
        return this.editionTypeOrDefault().isEnum();
    }

    public Path keysFile() {
        return this.keysFile == null ? null : this.resolve(Paths.get(this.keysFile, new String[0]), "keys");
    }

    public Path enumItemsFile() {
        return this.enumItemsFile == null ? null : this.resolve(Paths.get(this.enumItemsFile, new String[0]), "enum items");
    }

    public ControlSpecification buildControlSpecification(String name, List<String> enumItemValues, List<String> enumItemCaptions, boolean advancedParameters) {
        ControlSpecification result = new ControlSpecification().setName(name).setValueType(this.controlTemplate.valueType).setEditionType(this.editionTypeOrDefault()).setDefaultJsonValue(this.controlTemplate.defaultJsonValue);
        if (advancedParameters && this.importantKeys != null && !this.importantKeys.contains(name)) {
            result.setAdvanced(true);
        }
        if (enumItemValues != null) {
            result.setItemsFromLists(enumItemValues, enumItemCaptions);
        }
        return result;
    }

    @Override
    public void checkCompleteness() {
        this.checkNull(this.category, "category");
        this.checkNull(this.name, "name");
        this.checkNull(this.id, "id");
        this.checkNull(this.controlTemplate, "controlTemplate");
    }

    public String toString() {
        return "MappingSpecification{specificationFile=" + String.valueOf(this.specificationFile) + ", version='" + this.version + "', category='" + this.category + "', name='" + this.name + "', className='" + this.className + "', description='" + this.description + "', id='" + this.id + "', controlTemplate=" + String.valueOf(this.controlTemplate) + ", keysFile='" + this.keysFile + "', enumItemsFile='" + this.enumItemsFile + "', keys=" + String.valueOf(this.keys) + ", enumItems=" + String.valueOf(this.enumItems) + ", importantKeys=" + String.valueOf(this.importantKeys) + ", ignoredKeys=" + String.valueOf(this.ignoredKeys) + "}";
    }

    @Override
    public void buildJson(JsonObjectBuilder builder) {
        builder.add("app", "mapping");
        if (!this.version.equals(CURRENT_VERSION)) {
            builder.add("version", this.version);
        }
        if (!this.autogeneratedCategory) {
            builder.add("category", this.category);
        }
        if (!this.autogeneratedName) {
            builder.add("name", this.name);
        }
        if (this.className != null) {
            builder.add("class_name", this.className);
        }
        if (this.description != null) {
            builder.add("description", this.description);
        }
        builder.add("id", this.id);
        builder.add("control_template", (JsonValue)this.controlTemplate.toJson());
        if (this.keysFile != null) {
            builder.add("keys_file", this.keysFile);
        }
        if (this.enumItemsFile != null) {
            builder.add("enum_items_file", this.enumItemsFile);
        }
        if (this.keys != null) {
            builder.add("keys", (JsonValue)Jsons.toJsonArray(this.keys));
        }
        if (this.enumItems != null) {
            builder.add("enum_items", (JsonValue)Jsons.toJsonArray(this.enumItems));
        }
        if (this.importantKeys != null) {
            builder.add("important_keys", (JsonValue)Jsons.toJsonArray(this.importantKeys));
        }
        if (this.ignoredKeys != null) {
            builder.add("ignored_keys", (JsonValue)Jsons.toJsonArray(this.ignoredKeys));
        }
    }

    private Path resolve(Path path, String whatFile) {
        if (path.isAbsolute()) {
            return path;
        }
        if (this.specificationFile == null) {
            throw new IllegalStateException("Name of " + whatFile + " file is relative and cannot be resolved, because mapping JSON was not loaded from file; you must use absolute paths for such mapping JSONs");
        }
        return this.specificationFile.getParent().resolve(path);
    }

    private static <C extends Collection<String>> C toNames(C result, JsonArray names, String whatList) {
        if (names == null) {
            return null;
        }
        for (JsonValue value : names) {
            if (!(value instanceof JsonString)) {
                throw new JsonException("Illegal value \"" + String.valueOf(value) + "\" in the list \"" + whatList + "\": it is not JSON string");
            }
            JsonString jsonString = (JsonString)value;
            result.add((String)jsonString.getString());
        }
        return result;
    }

    private static void checkMappingName(String name, Path file) throws JsonException {
        if (name.contains(String.valueOf('.'))) {
            throw new JsonException("Non-allowed mapping name \"" + name + "\"" + (String)(file == null ? "" : " in JSON " + String.valueOf(file)) + ": it contains \".\" character");
        }
    }

    public static void main(String[] args) throws IOException {
        MappingSpecification mappingSpecification = MappingSpecification.read(Paths.get(args[0], new String[0]));
        System.out.println(mappingSpecification);
        System.out.println(Jsons.toPrettyString(mappingSpecification.toJson()));
    }

    public static final class ControlTemplate
    extends AbstractConvertibleToJson {
        private ParameterValueType valueType = ParameterValueType.STRING;
        private ControlEditionType editionType = null;
        private JsonValue defaultJsonValue = null;

        public ControlTemplate() {
        }

        public ControlTemplate(JsonObject json, Path file) {
            String valueType = json.getString("value_type", ParameterValueType.STRING.typeName());
            this.valueType = ParameterValueType.ofOrNull(valueType);
            Jsons.requireNonNull(this.valueType, json, "value_type", "unknown (\"" + valueType + "\")", file);
            String editionType = json.getString("edition_type", null);
            if (editionType != null) {
                this.editionType = ControlEditionType.ofOrNull(editionType);
                Jsons.requireNonNull(this.editionType, json, "edition_type", "unknown (\"" + editionType + "\")", file);
            }
            try {
                this.setDefaultJsonValue((JsonValue)json.get((Object)"default"));
            }
            catch (IllegalArgumentException e) {
                throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": invalid control template", (Throwable)e);
            }
        }

        public ParameterValueType getValueType() {
            return this.valueType;
        }

        public ControlTemplate setValueType(ParameterValueType valueType) {
            this.valueType = Objects.requireNonNull(valueType, "Null valueType");
            return this;
        }

        public JsonValue getDefaultJsonValue() {
            return this.defaultJsonValue;
        }

        public ControlTemplate setDefaultJsonValue(JsonValue defaultJsonValue) {
            assert (this.valueType != null);
            if (defaultJsonValue != null && this.valueType.toParameter(defaultJsonValue) == null) {
                throw new IllegalArgumentException("Incorrect default JSON value \"" + String.valueOf(defaultJsonValue) + "\": it is not " + String.valueOf((Object)this.valueType));
            }
            this.defaultJsonValue = defaultJsonValue;
            return this;
        }

        public ControlEditionType getEditionType() {
            return this.editionType;
        }

        public ControlTemplate setEditionType(ControlEditionType editionType) {
            this.editionType = editionType;
            return this;
        }

        @Override
        public void checkCompleteness() {
        }

        public String toString() {
            return "ControlTemplate{valueType=" + String.valueOf((Object)this.valueType) + ", editionType=" + String.valueOf((Object)this.editionType) + ", defaultJsonValue=" + String.valueOf(this.defaultJsonValue) + "}";
        }

        @Override
        public void buildJson(JsonObjectBuilder builder) {
            if (this.valueType != ParameterValueType.STRING) {
                builder.add("value_type", this.valueType.typeName());
            }
            if (this.editionType != null) {
                builder.add("edition_type", this.editionType.editionTypeName());
            }
            if (this.defaultJsonValue != null) {
                builder.add("default", this.defaultJsonValue);
            }
        }
    }
}

