/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.graalvm.js.scriptengine;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import net.algart.executors.api.graalvm.js.scriptengine.JavaScriptPerformer;

class ScriptEngineTools {
    private static final String DEFAULT_ENGINE_NAME = ScriptEngineTools.getStringProperty("net.algart.bridges.standard", "javascript");
    private static final Set<String> SAFE_CLASSES = new HashSet<String>(Arrays.asList(String.class.getCanonicalName(), Locale.class.getCanonicalName(), Float.class.getCanonicalName(), Double.class.getCanonicalName(), Math.class.getCanonicalName(), StrictMath.class.getCanonicalName(), Arrays.class.getCanonicalName(), Character.TYPE.getCanonicalName(), Boolean.TYPE.getCanonicalName(), Byte.TYPE.getCanonicalName(), Short.TYPE.getCanonicalName(), Integer.TYPE.getCanonicalName(), Long.TYPE.getCanonicalName(), Float.TYPE.getCanonicalName(), Double.TYPE.getCanonicalName(), char[].class.getCanonicalName(), boolean[].class.getCanonicalName(), byte[].class.getCanonicalName(), short[].class.getCanonicalName(), int[].class.getCanonicalName(), long[].class.getCanonicalName(), float[].class.getCanonicalName(), double[].class.getCanonicalName()));

    ScriptEngineTools() {
    }

    static ScriptEngine newEngine() {
        ScriptEngine engine = ScriptEngineTools.doNewEngine();
        JavaScriptPerformer.LOG.log(System.Logger.Level.DEBUG, "Creating new local JavaScript engine: " + String.valueOf(engine.getClass()));
        return engine;
    }

    static ScriptEngine doNewEngine() {
        ScriptEngine engine = new ScriptEngineManager(JavaScriptPerformer.class.getClassLoader()).getEngineByName(DEFAULT_ENGINE_NAME);
        if (engine == null) {
            throw new UnsupportedOperationException("Default script engine \"" + DEFAULT_ENGINE_NAME + "\" is not supported");
        }
        Bindings bindings = engine.getBindings(100);
        bindings.put("polyglot.js.allowHostAccess", (Object)true);
        bindings.put("polyglot.js.allowHostClassLookup", SAFE_CLASSES::contains);
        engine.put("LOGGER", JavaScriptPerformer.LOG);
        return engine;
    }

    private static String getStringProperty(String propertyName) {
        try {
            return System.getProperty(propertyName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getStringProperty(String propertyName, String defaultValue) {
        String result = ScriptEngineTools.getStringProperty(propertyName);
        return result != null ? result : defaultValue;
    }
}

