/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.graalvm.js.scriptengine;

import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.script.ScriptEngine;
import net.algart.executors.api.graalvm.js.scriptengine.JavaScriptPerformer;
import net.algart.executors.api.graalvm.js.scriptengine.ScriptEngineTools;

public final class JavaScriptContextContainer {
    private volatile ContextKey contextKey = null;
    private volatile ScriptEngine context = null;

    private JavaScriptContextContainer() {
    }

    public static JavaScriptContextContainer getInstance() {
        return new JavaScriptContextContainer();
    }

    public ScriptEngine getContext(boolean shareNamespace, Object contextId) {
        if (shareNamespace) {
            if (this.contextKey == null) {
                this.contextKey = new ContextKey(contextId);
            }
            return this.contextKey.getContext();
        }
        return this.getLocalContext();
    }

    public ScriptEngine getLocalContext() {
        if (this.context == null) {
            this.context = ScriptEngineTools.newEngine();
        }
        this.contextKey = null;
        return this.context;
    }

    public static int numberOfStoredScriptEngines() {
        return ContextKey.numberOfStoredContexts();
    }

    private static final class ContextKey {
        private static final Map<ContextKey, ScriptEngine> contexts = new WeakHashMap<ContextKey, ScriptEngine>();
        private final Object contextId;

        ContextKey(Object contextId) {
            this.contextId = Objects.requireNonNull(contextId, "Null JavaScript context ID");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ScriptEngine getContext() {
            Map<ContextKey, ScriptEngine> map = contexts;
            synchronized (map) {
                return contexts.computeIfAbsent(this, k -> {
                    ScriptEngine context = ScriptEngineTools.doNewEngine();
                    JavaScriptPerformer.LOG.log(System.Logger.Level.INFO, "Creating new shared JavaScript engine for context #" + String.valueOf(this.contextId) + ": " + String.valueOf(context.getClass()));
                    return context;
                });
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContextKey that = (ContextKey)o;
            return Objects.equals(this.contextId, that.contextId);
        }

        public int hashCode() {
            return Objects.hash(this.contextId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static int numberOfStoredContexts() {
            Map<ContextKey, ScriptEngine> map = contexts;
            synchronized (map) {
                return contexts.size();
            }
        }
    }
}

