/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.data;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.Objects;
import java.util.UUID;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.DataType;
import net.algart.external.UsedForExternalCommunication;

public final class Port {
    @UsedForExternalCommunication
    private String name;
    @UsedForExternalCommunication
    private Data data;
    @UsedForExternalCommunication
    private Type portType;
    @UsedForExternalCommunication
    private DataType dataType;
    private UUID uuid;
    @UsedForExternalCommunication
    private boolean connected = false;

    @UsedForExternalCommunication
    private Port() {
    }

    public String getName() {
        return this.name;
    }

    @UsedForExternalCommunication
    public Port setName(String name) {
        this.name = Objects.requireNonNull(name, "Null port name");
        return this;
    }

    public Data getData() {
        return this.data;
    }

    @UsedForExternalCommunication
    public Port setData(Data portData) {
        this.data = Objects.requireNonNull(portData, "Null port data");
        return this;
    }

    public Type getPortType() {
        return this.portType;
    }

    public Port setPortType(Type portType) {
        this.portType = Objects.requireNonNull(portType, "Null type");
        return this;
    }

    @UsedForExternalCommunication
    public Port setPortTypeCode(int code) {
        this.portType = Type.of(code);
        return this;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Port setDataType(DataType dataType) {
        this.dataType = Objects.requireNonNull(dataType, "Null data type");
        return this;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @UsedForExternalCommunication
    public Port setUuid(UUID uuid) {
        this.uuid = Objects.requireNonNull(uuid, "Null uuid");
        return this;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isInput() {
        return this.portType == Type.INPUT;
    }

    public boolean isOutput() {
        return this.portType == Type.OUTPUT;
    }

    @UsedForExternalCommunication
    public Port setConnected(boolean connected) {
        this.connected = connected;
        return this;
    }

    public <T extends Data> T getData(Class<? extends T> dataClass) {
        return this.getData(dataClass, false);
    }

    public <T extends Data> T getData(Class<? extends T> dataClass, boolean allowUninitializedData) {
        Objects.requireNonNull(dataClass, "Null requested data class");
        Data result = this.getData();
        if (result == null) {
            throw new IllegalArgumentException("The " + this.portType.typeName + " port \"" + this.name + "\" has no data container");
        }
        if (!allowUninitializedData && !result.isInitialized()) {
            throw new IllegalArgumentException("The " + this.portType.typeName + " port \"" + this.name + "\" has no initialized data");
        }
        if (!dataClass.isInstance(result)) {
            throw new IllegalArgumentException("Data in the " + this.portType.typeName + " port \"" + this.name + "\" is not an instance of " + dataClass.getSimpleName() + " (it is " + result.getClass().getSimpleName() + ")");
        }
        return (T)((Data)dataClass.cast(result));
    }

    public boolean hasData() {
        Data data = this.data;
        return data != null && data.isInitialized();
    }

    public void removeData() {
        Data data = this.data;
        if (data != null) {
            data.remove();
        }
    }

    public boolean isCancellingExecutionRequested() {
        Data data = this.data;
        return data != null && data.isFlagCancelExecution();
    }

    public void requestCancellingExecution() {
        Data data = this.data;
        if (data != null) {
            data.setFlagCancelExecution(true);
        }
    }

    public void requestContinuingExecution() {
        Data data = this.data;
        if (data != null) {
            data.setFlagCancelExecution(false);
        }
    }

    public JsonObject toJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        if (this.name != null) {
            builder.add("name", this.name);
        }
        if (this.portType != null) {
            builder.add("type", this.portType.typeName());
        }
        if (this.data != null) {
            builder.add("data", (JsonValue)this.data.toJson());
        }
        if (this.uuid != null) {
            builder.add("id", this.uuid.toString());
        }
        return builder.build();
    }

    public String toString() {
        return "Port \"" + this.name + "\" [" + String.valueOf((Object)this.portType) + " for " + String.valueOf((Object)this.dataType) + "], " + (String)(this.connected ? "connected" + (this.isOutput() ? " (requested)" : "") : "unconnected") + ": " + String.valueOf(this.data) + (String)(this.uuid == null ? "" : " [uuid " + String.valueOf(this.uuid) + "]");
    }

    public static Port newInput(String name, Data data) {
        Objects.requireNonNull(name, "Null port name");
        Objects.requireNonNull(name, "Null port data");
        return new Port().setPortType(Type.INPUT).setName(name).setDataType(data.type()).setData(data);
    }

    public static Port newInput(String name, DataType dataType) {
        Objects.requireNonNull(name, "Null port name");
        Objects.requireNonNull(dataType, "Null data type");
        return new Port().setPortType(Type.INPUT).setName(name).setDataType(dataType).setData(dataType.createEmpty());
    }

    public static Port newOutput(String name, DataType dataType) {
        Objects.requireNonNull(name, "Null port name");
        Objects.requireNonNull(dataType, "Null data type");
        return new Port().setPortType(Type.OUTPUT).setName(name).setDataType(dataType).setData(dataType.createEmpty());
    }

    public static enum Type {
        INPUT(1, "input"){

            @Override
            public Port getPort(ExecutionBlock executionBlock, String name) {
                return executionBlock.getInputPort(name);
            }
        }
        ,
        OUTPUT(2, "output"){

            @Override
            public Port getPort(ExecutionBlock executionBlock, String name) {
                return executionBlock.getOutputPort(name);
            }
        };

        private final int code;
        private final String typeName;

        private Type(int code, String typeName) {
            this.code = code;
            this.typeName = typeName;
        }

        public final int code() {
            return this.code;
        }

        public final String typeName() {
            return this.typeName;
        }

        public static Type of(int code) {
            return switch (code) {
                case 1 -> INPUT;
                case 2 -> OUTPUT;
                default -> throw new IllegalArgumentException("Unsupported type code: " + code);
            };
        }

        public abstract Port getPort(ExecutionBlock var1, String var2);
    }
}

