/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.data;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import net.algart.executors.api.data.DataType;
import net.algart.external.UsedForExternalCommunication;

public abstract class Data
implements Cloneable {
    public static final long FLAG_INITIALIZED = 1L;
    public static final long FLAG_CANCEL_EXECUTION = 16L;
    long flags = 0L;

    @UsedForExternalCommunication
    public long getFlags() {
        return this.flags;
    }

    @UsedForExternalCommunication
    public void setFlags(long flags) {
        this.flags = flags;
    }

    @UsedForExternalCommunication
    public final boolean isInitialized() {
        return (this.flags & 1L) != 0L;
    }

    @UsedForExternalCommunication
    public final void setInitialized(boolean initialized) {
        if (initialized) {
            this.flags |= 1L;
        } else {
            this.flags &= 0xFFFFFFFFFFFFFFFEL;
            this.freeResources();
        }
    }

    public void setInitializedAndResetFlags(boolean initialized) {
        this.flags = 0L;
        this.setInitialized(initialized);
    }

    public void remove() {
        this.setInitializedAndResetFlags(false);
    }

    public boolean isFlagCancelExecution() {
        return (this.flags & 0x10L) != 0L;
    }

    public void setFlagCancelExecution(boolean flagCancelExecution) {
        this.flags = flagCancelExecution ? (this.flags |= 0x10L) : (this.flags &= 0xFFFFFFFFFFFFFFEFL);
    }

    @UsedForExternalCommunication
    public abstract DataType type();

    public final void setTo(Data other) {
        this.setTo(other, true);
    }

    public abstract void setTo(Data var1, boolean var2);

    public abstract Data exchange(Data var1);

    public void serializeMemory() {
    }

    public JsonObject toJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("type", this.type().typeName());
        builder.add("initialized", this.isInitialized());
        return builder.build();
    }

    public Data clone() {
        Data result = this.type().createEmpty();
        result.setTo(this, true);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + (this.isInitialized() ? "" : " [NOT INITIALIZED]") + (this.isFlagCancelExecution() ? " [CANCELLING REQUESTED]" : "");
    }

    protected abstract void freeResources();
}

