/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.chains;

import jakarta.json.JsonValue;
import java.util.Objects;
import net.algart.executors.api.chains.ChainBlock;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.parameters.ParameterValueType;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.executors.api.system.ExecutorSpecification;

public final class ChainParameter {
    private final String name;
    private Object value = null;

    private ChainParameter(String name) {
        this.name = Objects.requireNonNull(name, "Null name");
    }

    public static ChainParameter newInstance(String name) {
        return new ChainParameter(name);
    }

    public static ChainParameter of(ChainBlock block, ChainSpecification.Block.Parameter parameter) {
        ChainParameter result = ChainParameter.newInstance(parameter.getName());
        assert (result.value == null) : "newInstance must set null value";
        result.loadValue(block, parameter.getValue());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public ParameterValueType probableType(ChainBlock block, ParameterValueType defaultType) {
        Objects.requireNonNull(block, "Null block");
        ControlSpecification control = this.controlSpecification(block);
        return control != null ? control.getValueType() : defaultType;
    }

    public String toScalar() {
        return this.value == null ? null : this.value.toString();
    }

    public String toString() {
        return "ChainParameter}{name='" + this.name + "', value=" + String.valueOf(this.value) + "}";
    }

    private void loadValue(ChainBlock block, JsonValue parameterJsonValue) {
        Object stringValue;
        ControlSpecification control = this.controlSpecification(block);
        if (control != null) {
            Object parameterValue;
            JsonValue defaultJsonValue;
            ParameterValueType valueType = control.getValueType();
            Object defaultValue = valueType.toParameter(defaultJsonValue = control.getDefaultJsonValue());
            if (defaultValue != null) {
                this.value = defaultValue;
            }
            if ((parameterValue = valueType.toParameter(parameterJsonValue)) != null) {
                this.value = parameterValue;
                return;
            }
        }
        if ((stringValue = ParameterValueType.STRING.toParameter(parameterJsonValue)) != null) {
            this.value = stringValue;
        }
    }

    private ControlSpecification controlSpecification(ChainBlock block) {
        ExecutorSpecification specification = block.getExecutorSpecification();
        return specification != null ? specification.getControl(this.name) : null;
    }
}

