/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.chains;

import jakarta.json.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.Executor;
import net.algart.executors.api.chains.ChainBlock;
import net.algart.executors.api.chains.ChainInputPort;
import net.algart.executors.api.chains.ChainLink;
import net.algart.executors.api.chains.ChainOutputPort;
import net.algart.executors.api.chains.ChainPort;
import net.algart.executors.api.chains.ChainPortKey;
import net.algart.executors.api.chains.ChainPortType;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.chains.core.ChainExecutor;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.api.parameters.Parameters;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.api.settings.core.CombineChainSettings;
import net.algart.executors.api.system.CreateMode;
import net.algart.executors.api.system.ExecutorFactory;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.modules.core.common.TimingStatistics;
import net.algart.json.Jsons;

public final class Chain
implements AutoCloseable {
    private static final AtomicLong CURRENT_CONTEXT_ID = new AtomicLong(99000000000L);
    private volatile long contextId;
    private final Executor executionContext;
    private final String id;
    private final ExecutorFactory executorFactory;
    private final Map<String, ChainBlock> allBlocks = new LinkedHashMap<String, ChainBlock>();
    private final Map<String, ChainPort<?>> allPorts = new LinkedHashMap();
    private final Set<ChainLink> allLinks = new LinkedHashSet<ChainLink>();
    private boolean autogeneratedCategory = false;
    private String category = null;
    private boolean autogeneratedName = false;
    private String name = null;
    private String description = null;
    private Set<String> tags = new LinkedHashSet<String>();
    private String platformId = null;
    private String platformCategory = null;
    private Path chainSpecificationPath = null;
    private volatile Path currentDirectory = null;
    private volatile boolean multithreading = false;
    private volatile boolean executeAll = false;
    private volatile boolean ignoreExceptions = false;
    private volatile boolean timingByExecutorsEnabled = false;
    private volatile String mainSettingsBlockId = null;
    private volatile SettingsBuilder mainSettingsBuilder = null;
    private volatile Object customChainInformation = null;
    private volatile List<ChainBlock> allInputs = null;
    private volatile List<ChainBlock> allOutputs = null;
    private volatile List<ChainBlock> allData = null;
    private final Object chainLock = new Object();
    final Object blocksInteractionLock = new Object();
    final AtomicInteger executionIndex = new AtomicInteger(0);
    volatile boolean needToRepeat = false;
    private volatile Executor caller = null;

    public Chain(Executor executionContext, String id, ExecutorFactory executorFactory) {
        this.contextId = CURRENT_CONTEXT_ID.getAndIncrement();
        this.executionContext = executionContext;
        this.id = Objects.requireNonNull(id, "Null chain ID");
        this.executorFactory = Objects.requireNonNull(executorFactory, "Null executor factory");
    }

    private Chain(Chain chain) {
        this.contextId = CURRENT_CONTEXT_ID.getAndIncrement();
        this.executionContext = chain.executionContext;
        this.id = chain.id;
        this.executorFactory = chain.executorFactory;
        assert (this.executorFactory != null) : "null executorFactory in " + String.valueOf(chain);
        this.autogeneratedCategory = chain.autogeneratedCategory;
        this.category = chain.category;
        this.autogeneratedName = chain.autogeneratedName;
        this.name = chain.name;
        this.description = chain.description;
        this.tags = new LinkedHashSet<String>(chain.tags);
        this.platformId = chain.platformId;
        this.platformCategory = chain.platformCategory;
        this.chainSpecificationPath = chain.chainSpecificationPath;
        this.currentDirectory = chain.currentDirectory;
        this.multithreading = chain.multithreading;
        this.executeAll = chain.executeAll;
        this.ignoreExceptions = chain.ignoreExceptions;
        this.timingByExecutorsEnabled = chain.timingByExecutorsEnabled;
        this.mainSettingsBuilder = chain.mainSettingsBuilder;
        this.mainSettingsBlockId = chain.mainSettingsBlockId;
        this.customChainInformation = chain.customChainInformation;
        this.allInputs = null;
        this.allOutputs = null;
        this.allData = null;
        this.needToRepeat = false;
        this.caller = null;
        chain.allBlocks.values().forEach(chainBlock -> this.addBlock(chainBlock.cleanCopy(this)));
        chain.allLinks.forEach(this::addLink);
    }

    public Chain cleanCopy() {
        return new Chain(this);
    }

    public static Chain of(Executor executionContext, ExecutorFactory executorFactory, ChainSpecification chainSpecification) {
        Objects.requireNonNull(chainSpecification, "Null chain specification");
        Chain result = new Chain(executionContext, chainSpecification.chainId(), executorFactory);
        ChainSpecification.Executor executor = chainSpecification.getExecutor();
        result.autogeneratedCategory = executor.isAutogeneratedCategory();
        result.category = executor.getCategory();
        result.autogeneratedName = executor.isAutogeneratedName();
        result.name = executor.getName();
        result.description = executor.getDescription();
        result.tags = new LinkedHashSet<String>(chainSpecification.getTags());
        result.platformId = chainSpecification.getPlatformId();
        result.platformCategory = chainSpecification.getPlatformCategory();
        result.chainSpecificationPath = chainSpecification.getSpecificationFile();
        ChainSpecification.Executor.Options.Execution execution = executor.getOptions().getExecution();
        result.setExecuteAll(execution.isAll());
        result.setMultithreading(execution.isMultithreading());
        result.setIgnoreExceptions(execution.isIgnoreExceptions());
        for (ChainSpecification.Block block : chainSpecification.getBlocks()) {
            result.addBlock(ChainBlock.of(result, block));
        }
        for (ChainSpecification.Link link : chainSpecification.getLinks()) {
            result.addLink(ChainLink.of(link));
        }
        if (chainSpecification.hasSpecificationFile()) {
            result.setCurrentDirectory(chainSpecification.getSpecificationFile().getParent());
        }
        result.setAllDefaultInputNames();
        result.setAllDefaultOutputNames();
        return result;
    }

    public Executor executionContext() {
        return this.executionContext;
    }

    public long contextId() {
        return this.contextId;
    }

    public String id() {
        return this.id;
    }

    public ExecutorFactory executorFactory() {
        assert (this.executorFactory != null);
        return this.executorFactory;
    }

    public boolean isAutogeneratedCategory() {
        return this.autogeneratedCategory;
    }

    public String category() {
        return this.category;
    }

    public boolean isAutogeneratedName() {
        return this.autogeneratedName;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String canonicalName() {
        return ExecutorSpecification.className(this.category(), this.name());
    }

    public Set<String> tags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public boolean hasPlatformId() {
        return this.platformId != null;
    }

    public String platformId() {
        return this.platformId;
    }

    public String platformCategory() {
        return this.platformCategory;
    }

    public Path chainSpecificationPath() {
        return this.chainSpecificationPath;
    }

    public Path getCurrentDirectory() {
        return this.currentDirectory;
    }

    public Chain setCurrentDirectory(Path currentDirectory) {
        this.currentDirectory = currentDirectory;
        return this;
    }

    public boolean isMultithreading() {
        return this.multithreading;
    }

    public Chain setMultithreading(boolean multithreading) {
        this.multithreading = multithreading;
        return this;
    }

    public boolean isExecuteAll() {
        return this.executeAll;
    }

    public Chain setExecuteAll(boolean executeAll) {
        this.executeAll = executeAll;
        return this;
    }

    public boolean isIgnoreExceptions() {
        return this.ignoreExceptions;
    }

    public Chain setIgnoreExceptions(boolean ignoreExceptions) {
        this.ignoreExceptions = ignoreExceptions;
        return this;
    }

    public boolean isTimingByExecutorsEnabled() {
        return this.timingByExecutorsEnabled;
    }

    public Chain setTimingByExecutorsEnabled(boolean timingByExecutorsEnabled) {
        this.timingByExecutorsEnabled = timingByExecutorsEnabled;
        return this;
    }

    public Object getCustomChainInformation() {
        return this.customChainInformation;
    }

    public Chain setCustomChainInformation(Object customChainInformation) {
        this.customChainInformation = customChainInformation;
        return this;
    }

    public Map<String, ChainBlock> getAllBlocks() {
        return Collections.unmodifiableMap(this.allBlocks);
    }

    public Map<String, ChainPort<?>> getAllPorts() {
        return Collections.unmodifiableMap(this.allPorts);
    }

    public ChainBlock getBlock(String blockId) {
        return this.allBlocks.get(blockId);
    }

    public void addBlock(ChainBlock block) {
        Objects.requireNonNull(block, "Null block");
        this.clearCache();
        if (this.allBlocks.putIfAbsent(block.id, block) != null) {
            throw new IllegalArgumentException("Duplicate block id: " + block.id);
        }
        for (ChainInputPort chainInputPort : block.inputPorts.values()) {
            if (chainInputPort.id == null || this.allPorts.putIfAbsent(chainInputPort.id, chainInputPort) == null) continue;
            throw new IllegalArgumentException("Duplicate input port id: " + chainInputPort.id);
        }
        for (ChainOutputPort chainOutputPort : block.outputPorts.values()) {
            if (chainOutputPort.id == null || this.allPorts.putIfAbsent(chainOutputPort.id, chainOutputPort) == null) continue;
            throw new IllegalArgumentException("Duplicate output port id: " + chainOutputPort.id);
        }
    }

    public void addLink(ChainLink link) {
        Objects.requireNonNull(link, "Null link");
        ChainPort<?> srcPort = this.allPorts.get(link.srcPortId);
        if (srcPort == null) {
            throw new IllegalArgumentException("Non-existing source port " + link.srcPortId);
        }
        if (!(srcPort instanceof ChainOutputPort)) {
            throw new IllegalArgumentException("Source port " + link.srcPortId + " is not an output port");
        }
        ChainPort<?> destPort = this.allPorts.get(link.destPortId);
        if (destPort == null) {
            throw new IllegalArgumentException("Non-existing destination port " + link.destPortId);
        }
        if (!(destPort instanceof ChainInputPort)) {
            throw new IllegalArgumentException("Destination port " + link.destPortId + " is not an input port");
        }
        if (!this.allLinks.add(link)) {
            throw new IllegalArgumentException("Duplicate link: " + String.valueOf(link));
        }
        if (srcPort.block.isExecutedAtRunTime() && destPort.block.isExecutedAtRunTime()) {
            ((ChainOutputPort)srcPort).addConnection((ChainInputPort)destPort);
            ((ChainInputPort)destPort).addConnection((ChainOutputPort)srcPort);
        }
    }

    public void setAllDefaultInputNames() {
        int count = 0;
        for (ChainBlock block : this.getAllInputs()) {
            String systemName = block.getSystemName();
            if (systemName != null) {
                block.setStandardInputOutputPortName(systemName);
                continue;
            }
            block.setStandardInputOutputPortName(Executor.DEFAULT_INPUT_PORT + (String)(++count == 1 ? "" : "_" + count));
        }
    }

    public void setAllDefaultOutputNames() {
        int count = 0;
        for (ChainBlock block : this.getAllOutputs()) {
            String systemName = block.getSystemName();
            if (systemName != null) {
                block.setStandardInputOutputPortName(systemName);
                continue;
            }
            block.setStandardInputOutputPortName(Executor.DEFAULT_OUTPUT_PORT + (String)(++count == 1 ? "" : "_" + count));
        }
    }

    public Collection<ChainBlock> getAllInputs() {
        List<ChainBlock> allInputs = this.allInputs;
        if (allInputs == null) {
            this.allInputs = allInputs = this.allBlocks.values().stream().filter(ChainBlock::isStandardInput).toList();
        }
        return Collections.unmodifiableList(allInputs);
    }

    public Collection<ChainBlock> getAllOutputs() {
        List<ChainBlock> allOutputs = this.allOutputs;
        if (allOutputs == null) {
            this.allOutputs = allOutputs = this.allBlocks.values().stream().filter(ChainBlock::isStandardOutput).toList();
        }
        return Collections.unmodifiableList(allOutputs);
    }

    public Collection<ChainBlock> getAllData() {
        List<ChainBlock> allData = this.allData;
        if (allData == null) {
            this.allData = allData = this.allBlocks.values().stream().filter(ChainBlock::isStandardData).toList();
        }
        return Collections.unmodifiableList(allData);
    }

    public Collection<ChainBlock> getAllNecessaryOutputs(ExecutionBlock executor) {
        Objects.requireNonNull(executor, "Null executor");
        ArrayList<ChainBlock> result = new ArrayList<ChainBlock>();
        for (ChainBlock block : this.getAllOutputs()) {
            String executorPortName = block.getStandardInputOutputName();
            if (!executor.isOutputNecessary(executorPortName)) continue;
            result.add(block);
        }
        return result;
    }

    public int numberOfBlocks() {
        return this.allBlocks.size();
    }

    public int numberOfReadyBlocks() {
        return (int)this.allBlocks.values().stream().filter(ChainBlock::isReady).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitializeAll() throws IllegalStateException {
        Object object = this.chainLock;
        synchronized (object) {
            this.contextId = CURRENT_CONTEXT_ID.getAndIncrement();
            this.checkRecursiveDependencies();
            this.allBlocks.values().forEach(block -> block.reinitialize(false));
        }
    }

    public Executor getCaller() {
        return this.caller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chain setCaller(Executor caller) {
        Object object = this.chainLock;
        synchronized (object) {
            this.caller = caller;
            this.allBlocks.values().forEach(block -> block.setCaller(caller));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chain setTimingSettings(int numberOfAnalysedCalls, TimingStatistics.Settings settings) {
        Object object = this.chainLock;
        synchronized (object) {
            this.allBlocks.values().forEach(block -> block.setTimingSettings(numberOfAnalysedCalls, settings));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chain setParameters(Parameters parameters) {
        Objects.requireNonNull(parameters, "Null parameters map");
        Object object = this.chainLock;
        synchronized (object) {
            for (ChainBlock block : this.getAllData()) {
                ChainInputPort inputPort;
                Data data;
                String chainParameterName = block.getStandardParameterName();
                if (chainParameterName == null || !((data = (inputPort = block.reqStandardDataPort()).getData()) instanceof SScalar)) continue;
                SScalar scalarData = (SScalar)data;
                String value = parameters.getString(chainParameterName, null);
                if (value == null) continue;
                scalarData.setTo(value);
            }
        }
        return this;
    }

    public Chain setInputData(Map<String, Data> inputs) {
        this.setAllInputData(inputs, false);
        return this;
    }

    public Chain setAllInputData(Map<String, Data> inputs) {
        this.setAllInputData(inputs, true);
        return this;
    }

    public Map<String, Data> getOutputDataClone() {
        LinkedHashMap<String, Data> result = new LinkedHashMap<String, Data>();
        for (ChainBlock block : this.getAllOutputs()) {
            ChainOutputPort outputPort = block.reqStandardOutputPort();
            String executorPortName = block.getStandardInputOutputName();
            result.put(executorPortName, outputPort.getData().clone());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readInputPortsFromExecutor(ExecutionBlock executor) {
        Objects.requireNonNull(executor, "Null executor");
        Object object = this.chainLock;
        synchronized (object) {
            for (ChainBlock block : this.getAllInputs()) {
                ChainInputPort chainInputPort = block.reqStandardInputPort();
                String executorPortName = block.getStandardInputOutputName();
                if (!executor.hasInputPort(executorPortName)) continue;
                Data data = executor.getInputData(executorPortName, true);
                chainInputPort.getData().setTo(data, true);
            }
        }
    }

    public void writeOutputPortsToExecutor(ExecutionBlock executor) {
        Objects.requireNonNull(executor, "Null executor");
        for (ChainBlock block : this.getAllOutputs()) {
            ChainOutputPort chainOutputPort = block.reqStandardOutputPort();
            String executorPortName = block.getStandardInputOutputName();
            Data data = chainOutputPort.getData();
            executor.addOutputData(executorPortName, data.type());
            executor.getData(executorPortName).setTo(data, true);
        }
    }

    public static void exchangeOutputDataWithExecutor(Map<String, Data> outputs, ExecutionBlock executor) {
        Objects.requireNonNull(outputs, "Null outputs");
        Objects.requireNonNull(executor, "Null executor");
        for (Map.Entry<String, Data> entry : outputs.entrySet()) {
            executor.getData(entry.getKey()).exchange(entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRecursiveDependencies() {
        Object object = this.chainLock;
        synchronized (object) {
            this.prepareExecution(true);
            this.allBlocks.values().forEach(ChainBlock::checkRecursiveDependencies);
        }
    }

    public void execute() {
        this.executeNecessary(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeNecessary(ExecutionBlock executor) {
        Object object = this.chainLock;
        synchronized (object) {
            this.prepareExecution(true);
            Collection<ChainBlock> all = this.allBlocks.values();
            all.forEach(ChainBlock::reset);
            while (true) {
                this.needToRepeat = false;
                Collection<ChainBlock> blocksToExecute = this.executeAll ? all : (executor == null || executor.isAllOutputsNecessary() ? this.getAllOutputs() : this.getAllNecessaryOutputs(executor));
                ChainBlock.executeWithAllDependentInputs(blocksToExecute, this.multithreading);
                if (!this.needToRepeat) break;
                this.prepareExecution(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeData() {
        Object object = this.chainLock;
        synchronized (object) {
            this.allBlocks.values().forEach(ChainBlock::freeData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeResources() {
        Object object = this.chainLock;
        synchronized (object) {
            this.allBlocks.values().forEach(ChainBlock::freeResources);
        }
    }

    public String getMainSettingsBlockId() {
        return this.mainSettingsBlockId;
    }

    public boolean hasSettings() {
        return this.mainSettingsBuilder != null;
    }

    public SettingsBuilder getSettingsBuilder() {
        return this.mainSettingsBuilder;
    }

    public SettingsBuilder settingsBuilder() {
        if (this.mainSettingsBuilder == null) {
            throw new IllegalStateException("The chain has no main settings: " + String.valueOf(this));
        }
        return this.mainSettingsBuilder;
    }

    public String setSettings(JsonObject selectedChainSettings) {
        if (selectedChainSettings == null) {
            return null;
        }
        if (this.mainSettingsBlockId == null) {
            throw new IllegalStateException("The chain has no built-in settings: " + String.valueOf(this));
        }
        ChainBlock settingsBlock = this.getBlock(this.mainSettingsBlockId);
        if (settingsBlock == null) {
            throw new AssertionError((Object)("Main settings block  '" + this.mainSettingsBlockId + "' is not found in the chain " + String.valueOf(this)));
        }
        ExecutorSpecification settingsSpecification = settingsBlock.getExecutorSpecification();
        if (settingsSpecification != null && !settingsSpecification.isRoleSettings()) {
            throw new IllegalArgumentException("Incorrect main chain settings block: it doesn't have a correct role \"settings\" (its options are " + String.valueOf(settingsSpecification.getOptions()) + ")");
        }
        String prettyString = Jsons.toPrettyString(selectedChainSettings);
        settingsBlock.setActualInputData("settings", SScalar.of(prettyString));
        return prettyString;
    }

    public void assignSettings(SettingsBuilder mainSettingsBuilder) {
        Objects.requireNonNull(mainSettingsBuilder, "Null mainSettings");
        String id = mainSettingsBuilder.id();
        assert (id != null);
        ChainBlock mainSettingsBlock = null;
        for (ChainBlock block : this.allBlocks.values()) {
            ChainSpecification.Block blockJson = block.getBlock();
            if (blockJson == null) continue;
            String blockExecutorId = blockJson.getExecutorId();
            assert (blockExecutorId != null);
            if (!id.equals(blockExecutorId)) continue;
            mainSettingsBlock = block;
            break;
        }
        if (mainSettingsBlock == null) {
            throw new IllegalStateException("Chain \"" + this.canonicalName() + "\" does not contain the settings combiner \"" + mainSettingsBuilder.className() + "\" ('" + id + "'), created by its UseChainSettings function");
        }
        this.mainSettingsBlockId = mainSettingsBlock.getId();
        this.mainSettingsBuilder = mainSettingsBuilder;
    }

    public CombineChainSettings newCombine() {
        SettingsBuilder settingsBuilder = this.settingsBuilder();
        return this.executorFactory.newExecutor(CombineChainSettings.class, settingsBuilder.id());
    }

    public ChainExecutor newExecutor(CreateMode createMode) {
        return this.executorFactory.newExecutor(ChainExecutor.class, this.id(), createMode);
    }

    public String timingInfo() {
        StringBuilder sb = new StringBuilder(String.format("  Detailed timing of chain%s (id=%s, %d blocks)%n  Sorted by time (only summary time for each block):%n", this.name == null ? "" : " " + this.name, this.id, this.numberOfBlocks()));
        ArrayList<ChainBlock> all = new ArrayList<ChainBlock>(this.allBlocks.values());
        all.forEach(ChainBlock::analyseTiming);
        List withTiming = all.stream().filter(ChainBlock::hasTiming).collect(Collectors.toList());
        all.sort(Comparator.comparingInt(ChainBlock::executionOrder));
        withTiming.sort(Comparator.comparingDouble(Chain::averageTime).reversed());
        double sum = withTiming.stream().mapToDouble(block -> block.timing().summaryTimeOfLastAnalysedCalls()).sum();
        for (ChainBlock block2 : withTiming) {
            sb.append(String.format("    %s%n", block2.simpleTimingInfo(sum)));
        }
        sb.append(String.format("  Detailed, sorted by execution order:%n", new Object[0]));
        for (ChainBlock block2 : all) {
            sb.append(String.format("    %s%n", block2.timingInfo()));
        }
        return sb.toString();
    }

    public String toString(boolean detailed) {
        StringBuilder sb = new StringBuilder("chain" + (String)(this.name == null ? "" : " \"" + this.name + "\"") + (String)(this.category == null ? "" : ", category \"" + this.category + "\""));
        if (detailed) {
            sb.append(" {\n  id=").append(this.id).append("\n  blocks=[\n");
            for (ChainBlock block : this.allBlocks.values()) {
                sb.append("    ").append(block).append('\n');
            }
            sb.append("  ]\n}\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public void close() {
        this.freeResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAllInputData(Map<String, Data> inputs, boolean requireToSetAllInputs) {
        Objects.requireNonNull(inputs, "Null inputs");
        Object object = this.chainLock;
        synchronized (object) {
            for (ChainBlock block : this.getAllInputs()) {
                ChainInputPort inputPort = block.reqStandardInputPort();
                String executorPortName = block.getStandardInputOutputName();
                Data input = inputs.get(executorPortName);
                if (input != null) {
                    if (input.type() != inputPort.getDataType()) {
                        throw new IllegalArgumentException("Cannot assign " + input.getClass().getSimpleName() + " to input port \"" + executorPortName + "\" of the block with ID \"" + block.getId() + "\": type mismatch (" + String.valueOf((Object)input.type()) + " instead of expected " + String.valueOf((Object)inputPort.getDataType()));
                    }
                    inputPort.getData().setTo(input, true);
                    continue;
                }
                if (!requireToSetAllInputs) continue;
                throw new IllegalArgumentException("No data for input block '" + executorPortName + "': " + String.valueOf(block));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareExecution(boolean firstIteration) {
        Object object = this.chainLock;
        synchronized (object) {
            this.executionIndex.set(0);
            ChainBlock.prepareExecution(this.allBlocks.values());
        }
    }

    private void clearCache() {
        this.allData = null;
        this.allInputs = null;
        this.allOutputs = null;
    }

    private static double averageTime(ChainBlock chainBlock) {
        return chainBlock.timing().summary().averageTimeOfLastAnalysedCalls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void debugCheck(String where) {
        Object object = this.blocksInteractionLock;
        synchronized (object) {
            ChainBlock block = this.getBlock("14fca6f5-4240-4b31-b27e-bb7e08029dda");
            if (block != null) {
                ChainOutputPort output = block.outputPorts.get(new ChainPortKey(ChainPortType.OUTPUT_PORT, "output"));
                if (block.isReady() && output.getCountOfConnectedInputs() > 0 && !output.data.isInitialized()) {
                    System.out.println(where + " !!!!!!!!!! PROBLEM! " + this.contextId);
                }
            }
        }
    }
}

