/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import net.algart.executors.api.data.Port;
import net.algart.external.UsedForExternalCommunication;
import net.algart.json.Jsons;

public class ExecutionVisibleResultsInformation {
    public static final String DEFAULT_MODEL = "default";
    public static final String CURRENT_VERSION = "1.0";
    private String model = "default";
    private Port[] ports = new Port[0];

    public final int numberOfPorts() {
        return this.ports.length;
    }

    @UsedForExternalCommunication
    public final String getModel() {
        return this.model;
    }

    public final ExecutionVisibleResultsInformation setModel(String model) {
        this.model = model;
        return this;
    }

    @UsedForExternalCommunication
    public final Port[] getPorts() {
        return (Port[])this.ports.clone();
    }

    public final ExecutionVisibleResultsInformation setPorts(Port ... ports) {
        Objects.requireNonNull(ports, "Null ports");
        this.ports = (Port[])Stream.of(ports).filter(Objects::nonNull).toArray(Port[]::new);
        return this;
    }

    public final ExecutionVisibleResultsInformation addPorts(Port ... ports) {
        Objects.requireNonNull(ports, "Null ports");
        ports = (Port[])Stream.of(ports).filter(Objects::nonNull).toArray(Port[]::new);
        int currentLength = this.ports.length;
        this.ports = Arrays.copyOf(this.ports, currentLength + ports.length);
        System.arraycopy(ports, 0, this.ports, currentLength, ports.length);
        return this;
    }

    @UsedForExternalCommunication
    public String jsonString() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("model", this.model);
        builder.add("version", CURRENT_VERSION);
        JsonArrayBuilder portsBuilder = Json.createArrayBuilder();
        for (Port port : this.ports) {
            portsBuilder.add((JsonValue)port.toJson());
        }
        builder.add("ports", (JsonValue)portsBuilder.build());
        return Jsons.toPrettyString(builder.build());
    }
}

