/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.dashboard;

import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.cv.monitor.viewers.ui.content.VisibleResultMetaData;
import com.siams.stare.api.Any;
import com.siams.stare.api.Command;
import com.siams.stare.api.CommandStatus;
import com.siams.stare.api.StareApi;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.SScalar;
import org.apache.log4j.Logger;

public class RpcApi {
    private final Logger logger = Logger.getLogger(RpcApi.class);
    private final StareApi stareApi;
    static RpcApi instance = null;

    RpcApi(StareApi stareApi) {
        this.stareApi = stareApi;
    }

    public static RpcApi getInstance() {
        assert (instance != null);
        return instance;
    }

    public CompletableFuture<CommandStatus> rqEvaluateProject() {
        return this.stareApi.executeCommand("P", Command.EVALUATE).exceptionally(t -> {
            this.logger.error((Object)String.format("Failed evaluate project: %s", t.getMessage()), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<Void> rqSetData(String url, Object data) {
        return this.stareApi.setData(url, data).exceptionally(t -> {
            this.logger.error((Object)String.format("Failed set data url=%s", url));
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<ViewerData> rqViewerData(UUID blockId) {
        return ((CompletableFuture)this.rqGetVisibleResultMetaInformation(blockId).thenCompose(this::rqViewerData)).exceptionally(t -> {
            this.logger.error((Object)String.format("Failed get viewer data of block: %s", blockId), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<ViewerData> rqViewerData(UIBlockModel uiBlockModel) {
        Objects.requireNonNull(uiBlockModel, "Block model required");
        return ((CompletableFuture)this.rqGetVisibleResultMetaInformation(uiBlockModel).thenCompose(this::rqViewerData)).exceptionally(t -> {
            this.logger.error((Object)String.format("Failed get viewer data of block: %s", uiBlockModel), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<Optional<String>> rqFirstError() {
        return this.stareApi.getList("P/error").thenCompose(errors -> errors.isEmpty() ? CompletableFuture.completedFuture(Optional.empty()) : this.stareApi.getData((String)errors.get(0)).thenApply(any -> any.getData(String.class)));
    }

    private CompletableFuture<ViewerData> rqViewerData(VisibleResultMetaData visibleResultMetaData) {
        this.logger.debug((Object)"preparing required data map");
        Map requiredData = Collections.synchronizedMap(new HashMap());
        CompletableFuture[] result = (CompletableFuture[])visibleResultMetaData.getPorts().stream().map(port -> {
            String name = port.getName();
            UUID uid = port.getUuid();
            return this.rqGetAnyIfExist(String.format("P/cache:%s", uid)).thenAccept(any -> any.getData().ifPresent(value -> {
                Data data = null;
                if (Data.class.isAssignableFrom(value.getClass())) {
                    data = (Data)value;
                } else if (value instanceof String) {
                    data = SScalar.of((Object)value);
                }
                requiredData.put(name, data);
            }));
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(result).thenApply(v -> new ViewerData(requiredData, visibleResultMetaData));
    }

    private CompletableFuture<VisibleResultMetaData> rqGetVisibleResultMetaInformation(UUID blockId) {
        String url = String.format("P/worker:%s/property:%s", blockId.toString(), "__tmp.visible_result_meta_information");
        return this.rqGetVisibleResultMetaInformation(url);
    }

    private CompletableFuture<VisibleResultMetaData> rqGetVisibleResultMetaInformation(UIBlockModel uiBlockModel) {
        Objects.requireNonNull(uiBlockModel, "Block model required");
        String url = String.format("P%s/property:%s", uiBlockModel.getRelUrl(), "__tmp.visible_result_meta_information");
        return this.rqGetVisibleResultMetaInformation(url);
    }

    private CompletableFuture<VisibleResultMetaData> rqGetVisibleResultMetaInformation(String url) {
        return ((CompletableFuture)this.rqGetDataIfExist(url, "{}").thenApply(json -> {
            try {
                VisibleResultMetaData metaData = VisibleResultMetaData.valueOf((String)json);
                return metaData;
            }
            catch (Throwable t) {
                throw new CompletionException("Failed parse visible result meta data", t);
            }
        })).exceptionally(t -> {
            this.logger.error((Object)String.format("Failed get visible result meta information: %s", url), t);
            throw new CompletionException((Throwable)t);
        });
    }

    public CompletableFuture<Any> rqGetAnyIfExist(String url) {
        return this.rqExist(url).thenCompose(exist -> exist != false ? this.stareApi.getData(url) : CompletableFuture.completedFuture(new Any(this.extractUrlId(url), null)));
    }

    public <T> CompletableFuture<T> rqGetDataIfExist(String url, T def) {
        return ((CompletableFuture)this.rqExist(url).thenCompose(exists -> (exists != false ? this.stareApi.getData(url) : CompletableFuture.completedFuture(new Any(this.extractUrlId(url), def))).thenCompose(any -> CompletableFuture.completedFuture(any.getData(def.getClass()).map(value -> value).orElseThrow(() -> new CompletionException(new RuntimeException("Failed extract typed data"))))))).exceptionally(t -> {
            this.logger.error((Object)String.format("Failed get data url=%s", url));
            throw new CompletionException((Throwable)t);
        });
    }

    private CompletableFuture<Boolean> rqExist(String url) {
        return url.isEmpty() ? CompletableFuture.completedFuture(false) : this.stareApi.exists(url);
    }

    private String extractUrlId(String url) {
        int index = url.lastIndexOf(":");
        int end = url.lastIndexOf("/");
        if (end != -1 && end > index) {
            return url.substring(index != -1 ? index + 1 : 0, end);
        }
        return url.substring(index != -1 ? index + 1 : 0);
    }
}

