/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.features.detection;

import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.opencv.common.MatToNumbers;
import net.algart.executors.modules.opencv.util.OTools;
import net.algart.executors.modules.opencv.util.enums.OHoughMode;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_imgproc.Vec4fVector;

public final class HoughCircles
extends MatToNumbers {
    public static final String OUTPUT_CIRCLES = "circles";
    public static final String OUTPUT_VOTES = "votes";
    private OHoughMode method = OHoughMode.HOUGH_GRADIENT;
    private double dp = 1.0;
    private double minDist = 10.0;
    private double param1 = 100.0;
    private double param2 = 20.0;
    private int minRadius = 0;
    private int maxRadius = 0;

    public HoughCircles() {
        this.setDefaultOutputNumbers(OUTPUT_CIRCLES);
        this.addOutputNumbers(OUTPUT_VOTES);
    }

    public OHoughMode getMethod() {
        return this.method;
    }

    public double getDp() {
        return this.dp;
    }

    public HoughCircles setDp(double dp) {
        this.dp = dp;
        return this;
    }

    public HoughCircles setMethod(OHoughMode method) {
        this.method = (OHoughMode)((Object)HoughCircles.nonNull((Object)((Object)method)));
        return this;
    }

    public double getMinDist() {
        return this.minDist;
    }

    public HoughCircles setMinDist(double minDist) {
        this.minDist = minDist;
        return this;
    }

    public double getParam1() {
        return this.param1;
    }

    public HoughCircles setParam1(double param1) {
        this.param1 = param1;
        return this;
    }

    public double getParam2() {
        return this.param2;
    }

    public HoughCircles setParam2(double param2) {
        this.param2 = param2;
        return this;
    }

    public int getMinRadius() {
        return this.minRadius;
    }

    public HoughCircles setMinRadius(int minRadius) {
        this.minRadius = HoughCircles.nonNegative((int)minRadius);
        return this;
    }

    public int getMaxRadius() {
        return this.maxRadius;
    }

    public HoughCircles setMaxRadius(int maxRadius) {
        this.maxRadius = maxRadius;
        return this;
    }

    @Override
    public SNumbers analyse(Mat source) {
        Mat mat = source;
        try {
            SNumbers sNumbers;
            mat = OTools.toMono8UIfNot(mat);
            try (Vec4fVector circlesVector = new Vec4fVector();){
                opencv_imgproc.HoughCircles((Mat)mat, (Vec4fVector)circlesVector, (int)this.method.code(), (double)this.dp, (double)this.minDist, (double)this.param1, (double)this.param2, (int)this.minRadius, (int)this.maxRadius);
                float[] circlesAndVotes = OTools.toFloatArray(circlesVector);
                for (int disp = 0; disp < circlesAndVotes.length; disp += 4) {
                    int n = disp + 2;
                    circlesAndVotes[n] = (float)((double)circlesAndVotes[n] * 2.0);
                }
                SNumbers result = SNumbers.ofArray((Object)circlesAndVotes, (int)4);
                this.getNumbers(OUTPUT_VOTES).exchange(result.columnRange(3, 1));
                sNumbers = result.columnRange(0, 3);
            }
            return sNumbers;
        }
        finally {
            if (mat != source) {
                mat.close();
            }
        }
    }

    @Override
    protected boolean allowInputPackedBits() {
        return true;
    }
}

