/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.features;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.opencv.common.VoidResultUMatFilter;
import net.algart.executors.modules.opencv.util.O2SMat;
import net.algart.executors.modules.opencv.util.OTools;
import net.algart.executors.modules.opencv.util.enums.OBorderType;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class CornerEigenValsAndVecs
extends VoidResultUMatFilter
implements ReadOnlyExecutionInput {
    private int blockSize = 15;
    private int kernelSizeSobel = 5;
    private OBorderType borderType = OBorderType.BORDER_DEFAULT;

    public CornerEigenValsAndVecs() {
        this.useVisibleResultParameter();
        for (ResultValue resultValue : ResultValue.values()) {
            String portName = resultValue.valueName;
            if (portName == null) continue;
            this.addOutputMat(portName);
        }
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = CornerEigenValsAndVecs.positive((int)blockSize);
    }

    public int getKernelSizeSobel() {
        return this.kernelSizeSobel;
    }

    public void setKernelSizeSobel(int kernelSizeSobel) {
        this.kernelSizeSobel = CornerEigenValsAndVecs.positive((int)kernelSizeSobel);
    }

    public OBorderType getBorderType() {
        return this.borderType;
    }

    public void setBorderType(OBorderType borderType) {
        this.borderType = (OBorderType)((Object)CornerEigenValsAndVecs.nonNull((Object)((Object)borderType)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Mat result, Mat source) {
        Mat mat = source;
        try {
            if (source.channels() > 1) {
                mat = new Mat();
                opencv_imgproc.cvtColor((Mat)source, (Mat)mat, (int)6);
            }
            CornerEigenValsAndVecs.logDebug(() -> "Eigenvalues and eigenvectors: block size " + this.blockSize + ", kernel size for Sobel " + this.kernelSizeSobel + " (source: " + String.valueOf(source) + ")");
            opencv_imgproc.cornerEigenValsAndVecs((Mat)mat, (Mat)result, (int)this.blockSize, (int)this.kernelSizeSobel, (int)this.borderType.code());
            this.setEndProcessingTimeStamp();
            for (ResultValue resultValue : ResultValue.values()) {
                if (!this.hasOutputPort(resultValue.valueName)) continue;
                CornerEigenValsAndVecs.logDebug(() -> "Eigenvalues and eigenvectors: returning " + resultValue.valueName);
                Mat resultChannel = new Mat();
                opencv_core.extractChannel((Mat)result, (Mat)resultChannel, (int)resultValue.valueIndex);
                O2SMat.setTo(this.getMat(resultValue.valueName), resultChannel);
            }
        }
        finally {
            if (mat != source) {
                mat.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(UMat result, UMat source) {
        UMat mat = source;
        try {
            mat = OTools.toMonoIfNot(mat);
            CornerEigenValsAndVecs.logDebug(() -> "Eigenvalues and eigenvectors (GPU): block size " + this.blockSize + ", kernel size for Sobel " + this.kernelSizeSobel + " (source: " + String.valueOf(source) + ")");
            opencv_imgproc.cornerEigenValsAndVecs((UMat)mat, (UMat)result, (int)this.blockSize, (int)this.kernelSizeSobel, (int)this.borderType.code());
            this.setEndProcessingTimeStamp();
            for (ResultValue resultValue : ResultValue.values()) {
                if (!this.hasOutputPort(resultValue.valueName)) continue;
                CornerEigenValsAndVecs.logDebug(() -> "Eigenvalues and eigenvectors: returning " + resultValue.valueName);
                UMat resultChannel = new UMat();
                opencv_core.extractChannel((UMat)result, (UMat)resultChannel, (int)resultValue.valueIndex);
                O2SMat.setTo(this.getMat(resultValue.valueName), resultChannel);
            }
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mat, source);
        }
    }

    public static enum ResultValue {
        NONE(-1, null),
        LAMBDA_1(0, "lambda1"),
        LAMBDA_2(1, "lambda2"),
        X_1(2, "x1"),
        Y_1(3, "y1"),
        X_2(4, "x2"),
        Y_2(5, "y2");

        private final int valueIndex;
        private final String valueName;

        private ResultValue(int valueIndex, String valueName) {
            this.valueIndex = valueIndex;
            this.valueName = valueName;
        }

        public String valueName() {
            return this.valueName;
        }
    }
}

