/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.copying;

import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.opencv.util.ConvertibleUMat;
import net.algart.executors.modules.opencv.util.O2SMat;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class CopyMat
extends Executor
implements ReadOnlyExecutionInput {
    private ResultType resultType = ResultType.UMAT_FOR_UMAT_INPUT;
    private boolean cloneData = false;

    public ResultType getResultType() {
        return this.resultType;
    }

    public CopyMat setResultType(ResultType resultType) {
        this.resultType = (ResultType)((Object)CopyMat.nonNull((Object)((Object)resultType)));
        return this;
    }

    public boolean isCloneData() {
        return this.cloneData;
    }

    public CopyMat setCloneData(boolean cloneData) {
        this.cloneData = cloneData;
        return this;
    }

    public CopyMat() {
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
    }

    public void process() {
        boolean copyToUMat;
        SMat input = this.getInputMat();
        boolean bl = copyToUMat = this.resultType == ResultType.UMAT || this.resultType == ResultType.UMAT_FOR_UMAT_INPUT && input.getPointer() instanceof ConvertibleUMat;
        if (copyToUMat) {
            CopyMat.logDebug(() -> (this.cloneData ? "Cloning" : "Copying") + " to OpenCV UMat (GPU): " + String.valueOf(input));
            UMat uMat = O2SMat.toUMat(input, true);
            assert (uMat != null) : "input must be initialized!";
            O2SMat.setTo(this.getMat(), this.cloneData ? uMat.clone() : uMat);
        } else {
            CopyMat.logDebug(() -> (this.cloneData ? "Cloning" : "Copying") + " to to OpenCV Mat: " + String.valueOf(input));
            Mat mat = O2SMat.toMat(input, true);
            assert (mat != null) : "input must be initialized!";
            O2SMat.setTo(this.getMat(), this.cloneData ? mat.clone() : mat);
        }
    }

    public boolean isReadOnly() {
        return this.cloneData;
    }

    public static enum ResultType {
        MAT,
        UMAT,
        UMAT_FOR_UMAT_INPUT;

    }
}

