/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import java.util.Arrays;
import java.util.Objects;
import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesCalculator;
import net.algart.executors.modules.cv.matrices.objects.labels.FirstNonZeroCalculator1Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.FirstNonZeroCalculator2Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.FirstNonZeroCalculator3Channels;

abstract class FirstNonZeroCalculator
extends CardinalitiesCalculator {
    final int numberOfChannels;
    final int[][] threadFirstNonZeroIndexesIncreased;
    private final int[][] requestedFirstNonZeroIndexes;
    int[] firstNonZeroIndexes;
    int[] firstNonZeroIntValues;
    float[] firstNonZeroFloatValues;

    FirstNonZeroCalculator(int[] labels, int numberOfChannels) {
        super(labels);
        this.numberOfChannels = numberOfChannels;
        this.requestedFirstNonZeroIndexes = FirstNonZeroCalculator.requestClearedIntArrays(this.numberOfTasks());
        this.threadFirstNonZeroIndexesIncreased = (int[][])this.requestedFirstNonZeroIndexes.clone();
    }

    static FirstNonZeroCalculator getInstance(int[] labels, Object[] channels) {
        Objects.requireNonNull(labels, "Null labels");
        Objects.requireNonNull(channels, "Null channels");
        if (channels.length == 0) {
            throw new IllegalArgumentException("Empty channels array");
        }
        Object channel0 = channels[0];
        if (!FirstNonZeroCalculator.isArraySupported(channel0)) {
            throw new IllegalArgumentException("Illegal array type: " + String.valueOf(channel0));
        }
        for (int k = 1; k < channels.length; ++k) {
            if (channels[k].getClass() == channel0.getClass()) continue;
            throw new IllegalArgumentException("Different type of channels: " + String.valueOf(channels[k].getClass()) + " != " + String.valueOf(channel0.getClass()));
        }
        switch (channels.length) {
            case 1: {
                if (channel0 instanceof byte[]) {
                    return new FirstNonZeroCalculator1Channels.ForBytes(labels, FirstNonZeroCalculator.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new FirstNonZeroCalculator1Channels.ForShorts(labels, FirstNonZeroCalculator.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new FirstNonZeroCalculator1Channels.ForInts(labels, FirstNonZeroCalculator.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new FirstNonZeroCalculator1Channels.ForFloats(labels, FirstNonZeroCalculator.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new FirstNonZeroCalculator1Channels.ForDoubles(labels, FirstNonZeroCalculator.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 2: {
                if (channel0 instanceof byte[]) {
                    return new FirstNonZeroCalculator2Channels.ForBytes(labels, FirstNonZeroCalculator.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new FirstNonZeroCalculator2Channels.ForShorts(labels, FirstNonZeroCalculator.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new FirstNonZeroCalculator2Channels.ForInts(labels, FirstNonZeroCalculator.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new FirstNonZeroCalculator2Channels.ForFloats(labels, FirstNonZeroCalculator.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new FirstNonZeroCalculator2Channels.ForDoubles(labels, FirstNonZeroCalculator.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 3: {
                if (channel0 instanceof byte[]) {
                    return new FirstNonZeroCalculator3Channels.ForBytes(labels, FirstNonZeroCalculator.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new FirstNonZeroCalculator3Channels.ForShorts(labels, FirstNonZeroCalculator.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new FirstNonZeroCalculator3Channels.ForInts(labels, FirstNonZeroCalculator.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new FirstNonZeroCalculator3Channels.ForFloats(labels, FirstNonZeroCalculator.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new FirstNonZeroCalculator3Channels.ForDoubles(labels, FirstNonZeroCalculator.castToDouble(channels));
                }
                throw new AssertionError();
            }
        }
        if (channel0 instanceof byte[]) {
            return new ForBytes(labels, FirstNonZeroCalculator.castToByte(channels));
        }
        if (channel0 instanceof short[]) {
            return new ForShorts(labels, FirstNonZeroCalculator.castToShort(channels));
        }
        if (channel0 instanceof int[]) {
            return new ForInts(labels, FirstNonZeroCalculator.castToInt(channels));
        }
        if (channel0 instanceof float[]) {
            return new ForFloats(labels, FirstNonZeroCalculator.castToFloat(channels));
        }
        if (channel0 instanceof double[]) {
            return new ForDoubles(labels, FirstNonZeroCalculator.castToDouble(channels));
        }
        throw new AssertionError();
    }

    @Override
    public void close() {
        super.close();
        FirstNonZeroCalculator.releaseAndClearIntArrays(this.requestedFirstNonZeroIndexes, this.maxLabel + 1);
    }

    @Override
    protected void finish() {
        super.finish();
        if ((long)this.maxLabel * (long)this.numberOfChannels > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large required array for " + this.numberOfChannels + " channels: more that 2^31-1 elements");
        }
        this.firstNonZeroIndexes = new int[this.maxLabel];
        Arrays.fill(this.firstNonZeroIndexes, -1);
        for (int[] increasedIndexes : this.threadFirstNonZeroIndexesIncreased) {
            int length = Math.min(this.firstNonZeroIndexes.length, increasedIndexes.length - 1);
            for (int label = 0; label < length; ++label) {
                int increasedIndex = increasedIndexes[label + 1];
                int index = increasedIndex - 1;
                int previous = this.firstNonZeroIndexes[label];
                if (index < 0 || previous != -1 && index >= previous) continue;
                this.firstNonZeroIndexes[label] = index;
            }
        }
    }

    private static class ForBytes
    extends FirstNonZeroCalculator {
        private final byte[][] data;

        public ForBytes(int[] labels, byte[][] data) {
            super(labels, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            int[] firstNonZeroIndexesIncreased = this.threadFirstNonZeroIndexesIncreased[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForBytes.ensureCapacityForLabel(cardinalities, label);
                    firstNonZeroIndexesIncreased = ForBytes.ensureCapacityForLabel(firstNonZeroIndexesIncreased, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                if (firstNonZeroIndexesIncreased[label] != 0) continue;
                boolean nonZero = false;
                for (int c = 0; c < this.numberOfChannels; ++c) {
                    if (this.data[c][k] == 0) continue;
                    nonZero = true;
                    break;
                }
                if (!nonZero) continue;
                firstNonZeroIndexesIncreased[label] = k + 1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
            this.threadFirstNonZeroIndexesIncreased[threadIndex] = firstNonZeroIndexesIncreased;
        }

        @Override
        protected void finish() {
            super.finish();
            this.firstNonZeroIntValues = new int[this.firstNonZeroIndexes.length * this.numberOfChannels];
            int label = 0;
            int disp = 0;
            while (label < this.firstNonZeroIndexes.length) {
                int index = this.firstNonZeroIndexes[label];
                if (index >= 0) {
                    for (int c = 0; c < this.numberOfChannels; ++c) {
                        this.firstNonZeroIntValues[disp + c] = this.data[c][index] & 0xFF;
                    }
                }
                ++label;
                disp += this.numberOfChannels;
            }
        }
    }

    private static class ForShorts
    extends FirstNonZeroCalculator {
        private final short[][] data;

        public ForShorts(int[] labels, short[][] data) {
            super(labels, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            int[] firstNonZeroIndexesIncreased = this.threadFirstNonZeroIndexesIncreased[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForShorts.ensureCapacityForLabel(cardinalities, label);
                    firstNonZeroIndexesIncreased = ForShorts.ensureCapacityForLabel(firstNonZeroIndexesIncreased, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                if (firstNonZeroIndexesIncreased[label] != 0) continue;
                boolean nonZero = false;
                for (int c = 0; c < this.numberOfChannels; ++c) {
                    if (this.data[c][k] == 0) continue;
                    nonZero = true;
                    break;
                }
                if (!nonZero) continue;
                firstNonZeroIndexesIncreased[label] = k + 1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
            this.threadFirstNonZeroIndexesIncreased[threadIndex] = firstNonZeroIndexesIncreased;
        }

        @Override
        protected void finish() {
            super.finish();
            this.firstNonZeroIntValues = new int[this.firstNonZeroIndexes.length * this.numberOfChannels];
            int label = 0;
            int disp = 0;
            while (label < this.firstNonZeroIndexes.length) {
                int index = this.firstNonZeroIndexes[label];
                if (index >= 0) {
                    for (int c = 0; c < this.numberOfChannels; ++c) {
                        this.firstNonZeroIntValues[disp + c] = this.data[c][index] & 0xFFFF;
                    }
                }
                ++label;
                disp += this.numberOfChannels;
            }
        }
    }

    private static class ForInts
    extends FirstNonZeroCalculator {
        private final int[][] data;

        public ForInts(int[] labels, int[][] data) {
            super(labels, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            int[] firstNonZeroIndexesIncreased = this.threadFirstNonZeroIndexesIncreased[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForInts.ensureCapacityForLabel(cardinalities, label);
                    firstNonZeroIndexesIncreased = ForInts.ensureCapacityForLabel(firstNonZeroIndexesIncreased, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                if (firstNonZeroIndexesIncreased[label] != 0) continue;
                boolean nonZero = false;
                for (int c = 0; c < this.numberOfChannels; ++c) {
                    if (this.data[c][k] == 0) continue;
                    nonZero = true;
                    break;
                }
                if (!nonZero) continue;
                firstNonZeroIndexesIncreased[label] = k + 1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
            this.threadFirstNonZeroIndexesIncreased[threadIndex] = firstNonZeroIndexesIncreased;
        }

        @Override
        protected void finish() {
            super.finish();
            this.firstNonZeroIntValues = new int[this.firstNonZeroIndexes.length * this.numberOfChannels];
            int label = 0;
            int disp = 0;
            while (label < this.firstNonZeroIndexes.length) {
                int index = this.firstNonZeroIndexes[label];
                if (index >= 0) {
                    for (int c = 0; c < this.numberOfChannels; ++c) {
                        this.firstNonZeroIntValues[disp + c] = this.data[c][index];
                    }
                }
                ++label;
                disp += this.numberOfChannels;
            }
        }
    }

    private static class ForFloats
    extends FirstNonZeroCalculator {
        private final float[][] data;

        public ForFloats(int[] labels, float[][] data) {
            super(labels, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            int[] firstNonZeroIndexesIncreased = this.threadFirstNonZeroIndexesIncreased[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForFloats.ensureCapacityForLabel(cardinalities, label);
                    firstNonZeroIndexesIncreased = ForFloats.ensureCapacityForLabel(firstNonZeroIndexesIncreased, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                if (firstNonZeroIndexesIncreased[label] != 0) continue;
                boolean nonZero = false;
                for (int c = 0; c < this.numberOfChannels; ++c) {
                    if (this.data[c][k] == 0.0f) continue;
                    nonZero = true;
                    break;
                }
                if (!nonZero) continue;
                firstNonZeroIndexesIncreased[label] = k + 1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
            this.threadFirstNonZeroIndexesIncreased[threadIndex] = firstNonZeroIndexesIncreased;
        }

        @Override
        protected void finish() {
            super.finish();
            this.firstNonZeroFloatValues = new float[this.firstNonZeroIndexes.length * this.numberOfChannels];
            int label = 0;
            int disp = 0;
            while (label < this.firstNonZeroIndexes.length) {
                int index = this.firstNonZeroIndexes[label];
                if (index >= 0) {
                    for (int c = 0; c < this.numberOfChannels; ++c) {
                        this.firstNonZeroFloatValues[disp + c] = this.data[c][index];
                    }
                }
                ++label;
                disp += this.numberOfChannels;
            }
        }
    }

    private static class ForDoubles
    extends FirstNonZeroCalculator {
        private final double[][] data;

        public ForDoubles(int[] labels, double[][] data) {
            super(labels, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            int[] firstNonZeroIndexesIncreased = this.threadFirstNonZeroIndexesIncreased[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForDoubles.ensureCapacityForLabel(cardinalities, label);
                    firstNonZeroIndexesIncreased = ForDoubles.ensureCapacityForLabel(firstNonZeroIndexesIncreased, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                if (firstNonZeroIndexesIncreased[label] != 0) continue;
                boolean nonZero = false;
                for (int c = 0; c < this.numberOfChannels; ++c) {
                    if (this.data[c][k] == 0.0) continue;
                    nonZero = true;
                    break;
                }
                if (!nonZero) continue;
                firstNonZeroIndexesIncreased[label] = k + 1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
            this.threadFirstNonZeroIndexesIncreased[threadIndex] = firstNonZeroIndexesIncreased;
        }

        @Override
        protected void finish() {
            super.finish();
            this.firstNonZeroFloatValues = new float[this.firstNonZeroIndexes.length * this.numberOfChannels];
            int label = 0;
            int disp = 0;
            while (label < this.firstNonZeroIndexes.length) {
                int index = this.firstNonZeroIndexes[label];
                if (index >= 0) {
                    for (int c = 0; c < this.numberOfChannels; ++c) {
                        this.firstNonZeroFloatValues[disp + c] = (float)this.data[c][index];
                    }
                }
                ++label;
                disp += this.numberOfChannels;
            }
        }
    }
}

