/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.components;

import java.util.List;
import net.algart.arrays.Arrays;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.cv.matrices.objects.binary.components.ConnectedComponentScanning;
import net.algart.matrices.scanning.ConnectedObjectScanner;
import net.algart.multimatrix.MultiMatrix2D;

public final class ScanConnectedObjects
extends ConnectedComponentScanning {
    public static final String INPUT_OBJECTS = "objects";
    public static final String OUTPUT_LABELS = "labels";

    public ScanConnectedObjects() {
        super(INPUT_OBJECTS);
        this.setDefaultOutputMat(OUTPUT_LABELS);
    }

    protected Matrix<? extends PArray> processMatrix(List<Matrix<? extends UpdatablePArray>> bitMatrices, List<MultiMatrix2D> sources) {
        Matrix objects = ScanConnectedObjects.asBit(bitMatrices.get(0));
        Matrix result = Arrays.SMM.newIntMatrix(objects.dimensions());
        assert (result.array() instanceof DirectAccessible);
        DirectAccessible da = (DirectAccessible)result.array();
        assert (da.hasJavaArray());
        final int[] labels = (int[])da.javaArray();
        final int ofs = da.javaArrayOffset();
        ConnectedObjectScanner scanner = this.connectedObjectScanner((Matrix<? extends UpdatableBitArray>)objects);
        long[] coordinates = new long[objects.dimCount()];
        class Painter
        implements ConnectedObjectScanner.ElementVisitor {
            private int currentLabel = 1;

            Painter() {
            }

            public void visit(long[] coordinatesInMatrix, long indexInArray) {
                labels[(int)((long)ofs + indexInArray)] = this.currentLabel;
            }
        }
        Painter painter = new Painter();
        while (scanner.nextUnitBit(coordinates)) {
            scanner.clear(null, (ConnectedObjectScanner.ElementVisitor)painter, coordinates, false);
            ++painter.currentLabel;
        }
        return result;
    }
}

