/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.components;

import java.util.Map;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.cv.matrices.objects.MeasureLabelledObjects;
import net.algart.matrices.scanning.ConnectivityType;
import net.algart.multimatrix.MultiMatrix2D;

public final class MeasureConnectedObjects
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_OBJECTS = "objects";
    public static final String INPUT_MASK = "mask";
    private double pixelSize = 1.0;
    private ConnectivityType connectivityType = ConnectivityType.STRAIGHT_AND_DIAGONAL;

    public MeasureConnectedObjects() {
        this.useVisibleResultParameter();
        this.setDefaultInputMat(INPUT_OBJECTS);
        this.setDefaultOutputNumbers(MeasureLabelledObjects.ObjectParameter.AREA.outputPort());
        this.addInputMat(INPUT_MASK);
        for (MeasureLabelledObjects.ObjectParameter parameter : MeasureLabelledObjects.ObjectParameter.values()) {
            this.addOutputNumbers(parameter.outputPort());
        }
    }

    public double getPixelSize() {
        return this.pixelSize;
    }

    public MeasureConnectedObjects setPixelSize(double pixelSize) {
        this.pixelSize = pixelSize;
        return this;
    }

    public ConnectivityType getConnectivityType() {
        return this.connectivityType;
    }

    public MeasureConnectedObjects setConnectivityType(ConnectivityType connectivityType) {
        this.connectivityType = (ConnectivityType)MeasureConnectedObjects.nonNull((Object)connectivityType);
        return this;
    }

    public void process() {
        MultiMatrix2D labels = this.getInputMat(INPUT_OBJECTS, false).toMultiMatrix2D();
        MultiMatrix2D mask = this.getInputMat(INPUT_MASK, true).toMultiMatrix2D();
        Map<MeasureLabelledObjects.ObjectParameter, SNumbers> resultStatistics = MeasureLabelledObjects.convertMap(this.allOutputContainers(SNumbers.class, true));
        this.setStartProcessingTimeStamp();
        new MeasureLabelledObjects().setAutoSplitBitInputIntoConnectedComponents(true).setPixelSize(this.pixelSize).setBitInputConnectivityType(this.connectivityType).analyse(resultStatistics, labels.nonZeroRGB(), mask);
        this.setEndProcessingTimeStamp();
    }
}

