/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.util.Locale;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.executors.modules.core.common.matrices.BitMultiMatrixFilter;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.FillMainBoundaryAroundPoint;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.matrices.scanning.ConnectivityType;
import net.algart.matrices.scanning.ContainingMainBoundaryFinder;

public final class FillMainBoundaryAroundRectangle
extends BitMultiMatrixFilter {
    public static final String OUTPUT_FOUND_X = "found_x";
    public static final String OUTPUT_FOUND_Y = "found_y";
    public static final String OUTPUT_AREA = "area";
    private long startX = 0L;
    private long startY = 0L;
    private long sizeX = 1L;
    private long sizeY = 1L;
    private FillMainBoundaryAroundPoint.Mode mode = FillMainBoundaryAroundPoint.Mode.CLEAR_OUTSIDE;
    private ConnectivityType connectivityType = ConnectivityType.STRAIGHT_AND_DIAGONAL;

    public FillMainBoundaryAroundRectangle() {
        this.addOutputScalar(OUTPUT_FOUND_X);
        this.addOutputScalar(OUTPUT_FOUND_Y);
        this.addOutputScalar(OUTPUT_AREA);
    }

    public long getStartX() {
        return this.startX;
    }

    public FillMainBoundaryAroundRectangle setStartX(long startX) {
        this.startX = startX;
        return this;
    }

    public long getStartY() {
        return this.startY;
    }

    public FillMainBoundaryAroundRectangle setStartY(long startY) {
        this.startY = startY;
        return this;
    }

    public long getSizeX() {
        return this.sizeX;
    }

    public FillMainBoundaryAroundRectangle setSizeX(long sizeX) {
        this.sizeX = FillMainBoundaryAroundRectangle.nonNegative((long)sizeX);
        return this;
    }

    public long getSizeY() {
        return this.sizeY;
    }

    public FillMainBoundaryAroundRectangle setSizeY(long sizeY) {
        this.sizeY = FillMainBoundaryAroundRectangle.nonNegative((long)sizeY);
        return this;
    }

    public FillMainBoundaryAroundPoint.Mode getMode() {
        return this.mode;
    }

    public FillMainBoundaryAroundRectangle setMode(FillMainBoundaryAroundPoint.Mode mode) {
        this.mode = (FillMainBoundaryAroundPoint.Mode)((Object)FillMainBoundaryAroundRectangle.nonNull((Object)((Object)mode)));
        return this;
    }

    public ConnectivityType getConnectivityType() {
        return this.connectivityType;
    }

    public FillMainBoundaryAroundRectangle setConnectivityType(ConnectivityType connectivityType) {
        this.connectivityType = (ConnectivityType)FillMainBoundaryAroundRectangle.nonNull((Object)connectivityType);
        return this;
    }

    protected Matrix<? extends PArray> processMatrix(Matrix<? extends PArray> objects) {
        if (this.sizeX <= 0L || this.sizeY <= 0L) {
            return new FillMainBoundaryAroundPoint().setX(this.startX).setY(this.startY).setMode(this.mode).setConnectivityType(this.connectivityType).processMatrix(objects);
        }
        long t1 = FillMainBoundaryAroundRectangle.debugTime();
        Matrix source = objects.cast(BitArray.class);
        ContainingMainBoundaryFinder finder = ContainingMainBoundaryFinder.newInstance((long[])source.dimensions()).setConnectivityType(this.connectivityType);
        Matrix result = Arrays.SMM.newBitMatrix(objects.dimensions());
        long t2 = FillMainBoundaryAroundRectangle.debugTime();
        IRectangularArea rectangle = IRectangularArea.valueOf((long)this.startX, (long)this.startY, (long)Math.addExact(this.startX, this.sizeX - 1L), (long)Math.addExact(this.startY, this.sizeY - 1L));
        IPoint p = this.mode.processRectangle(finder, (Matrix<? extends UpdatableBitArray>)result, (Matrix<? extends BitArray>)source, rectangle);
        long t3 = FillMainBoundaryAroundRectangle.debugTime();
        this.getScalar(OUTPUT_FOUND_X).setTo(p.x());
        this.getScalar(OUTPUT_FOUND_Y).setTo(p.y());
        this.getScalar(OUTPUT_AREA).setTo(finder.scanner().orientedArea());
        FillMainBoundaryAroundRectangle.logDebug(() -> String.format(Locale.US, "Finding main boundary in matrix %dx%d around rectangle %s in %.3f ms: %.6f ms allocating + %.6f ms %s", source.dimX(), source.dimY(), rectangle, (double)(t3 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, this.mode.modeName()));
        return result;
    }
}

