/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import net.algart.arrays.IntArray;
import net.algart.contours.ContourHeader;
import net.algart.contours.Contours;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;
import net.algart.math.IRectangularArea;

public final class ExtractContoursInRectangle
extends NumbersFilter
implements ReadOnlyExecutionInput {
    public static final String INPUT_CONTOURS = "contours";
    public static final String OUTPUT_CONTOURS = "contours";
    public static final String OUTPUT_OTHER_CONTOURS = "other_contours";
    public static final String OUTPUT_CONTAINING_ALL_RECTANGLE = "containing_all_rectangle";
    public static final String OUTPUT_NUMBER_OF_SOURCE_CONTOURS = "number_of_source_contours";
    public static final String OUTPUT_NUMBER_OF_RESULT_CONTOURS = "number_of_result_contours";
    private boolean doAction = true;
    private SelectionMode selectionMode = SelectionMode.FULLY_INSIDE;
    private long left = 0L;
    private long top = 0L;
    private long right = 0L;
    private long bottom = 0L;
    private long width = 0L;
    private long height = 0L;

    public ExtractContoursInRectangle() {
        this.setDefaultInputNumbers("contours");
        this.setDefaultOutputNumbers("contours");
        this.addOutputNumbers(OUTPUT_OTHER_CONTOURS);
        this.addOutputNumbers(OUTPUT_CONTAINING_ALL_RECTANGLE);
        this.addOutputScalar(OUTPUT_NUMBER_OF_SOURCE_CONTOURS);
        this.addOutputScalar(OUTPUT_NUMBER_OF_RESULT_CONTOURS);
    }

    public boolean isDoAction() {
        return this.doAction;
    }

    public ExtractContoursInRectangle setDoAction(boolean doAction) {
        this.doAction = doAction;
        return this;
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public ExtractContoursInRectangle setSelectionMode(SelectionMode selectionMode) {
        this.selectionMode = (SelectionMode)((Object)ExtractContoursInRectangle.nonNull((Object)((Object)selectionMode)));
        return this;
    }

    public long getLeft() {
        return this.left;
    }

    public ExtractContoursInRectangle setLeft(long left) {
        this.left = left;
        return this;
    }

    public long getTop() {
        return this.top;
    }

    public ExtractContoursInRectangle setTop(long top) {
        this.top = top;
        return this;
    }

    public long getRight() {
        return this.right;
    }

    public ExtractContoursInRectangle setRight(long right) {
        this.right = right;
        return this;
    }

    public long getBottom() {
        return this.bottom;
    }

    public ExtractContoursInRectangle setBottom(long bottom) {
        this.bottom = bottom;
        return this;
    }

    public long getWidth() {
        return this.width;
    }

    public ExtractContoursInRectangle setWidth(long width) {
        this.width = ExtractContoursInRectangle.nonNegative((long)width);
        return this;
    }

    public long getHeight() {
        return this.height;
    }

    public ExtractContoursInRectangle setHeight(long height) {
        this.height = ExtractContoursInRectangle.nonNegative((long)height);
        return this;
    }

    public boolean isReadOnly() {
        return this.doAction;
    }

    protected SNumbers processNumbers(SNumbers source) {
        if (!this.doAction) {
            return source;
        }
        Contours contours = Contours.deserialize((int[])source.toIntArray());
        Contours result = Contours.newInstance();
        Contours otherContours = Contours.newInstance();
        long x1 = this.left;
        long y1 = this.top;
        long x2 = this.right;
        long y2 = this.bottom;
        if (this.width > 0L) {
            x2 = Math.addExact(x1, this.width);
        }
        if (this.height > 0L) {
            y2 = Math.addExact(y1, this.height);
        }
        IRectangularArea checkedRectangle = IRectangularArea.valueOf((long)x1, (long)y1, (long)x2, (long)y2);
        boolean resultNecessary = this.isOutputNecessary("contours");
        boolean otherContoursNecessary = this.isOutputNecessary(OUTPUT_OTHER_CONTOURS);
        ContourHeader header = new ContourHeader();
        int containingMinX = Integer.MAX_VALUE;
        int containingMaxX = Integer.MIN_VALUE;
        int containingMinY = Integer.MAX_VALUE;
        int containingMaxY = Integer.MIN_VALUE;
        int n = contours.numberOfContours();
        for (int k = 0; k < n; ++k) {
            IntArray contour;
            contours.getHeader(header, k);
            if (header.minX() < containingMinX) {
                containingMinX = header.minX();
            }
            if (header.maxX() > containingMaxX) {
                containingMaxX = header.maxX();
            }
            if (header.minY() < containingMinY) {
                containingMinY = header.minY();
            }
            if (header.maxY() > containingMaxY) {
                containingMaxY = header.maxY();
            }
            if (this.selectionMode.accept(header, contour = contours.getContour(k), checkedRectangle)) {
                if (!resultNecessary) continue;
                result.addContour(header, contour);
                continue;
            }
            if (!otherContoursNecessary) continue;
            otherContours.addContour(header, contour);
        }
        if (n > 0) {
            this.getNumbers(OUTPUT_CONTAINING_ALL_RECTANGLE).setTo(IRectangularArea.valueOf((long)containingMinX, (long)containingMinY, (long)containingMaxX, (long)containingMaxY));
        }
        this.getScalar(OUTPUT_NUMBER_OF_SOURCE_CONTOURS).setTo(n);
        this.getScalar(OUTPUT_NUMBER_OF_RESULT_CONTOURS).setTo(result.numberOfContours());
        if (otherContoursNecessary) {
            this.getNumbers(OUTPUT_OTHER_CONTOURS).setTo(otherContours);
        }
        return resultNecessary ? SNumbers.of((Contours)result) : null;
    }

    protected boolean resultRequired() {
        return false;
    }

    public static enum SelectionMode {
        FULLY_INSIDE{

            @Override
            boolean accept(ContourHeader header, IntArray contour, IRectangularArea checkedRectangle) {
                return checkedRectangle.contains(header.containingRectangle());
            }
        }
        ,
        CONTAINING_RECTANGLE_INTERSECTS{

            @Override
            boolean accept(ContourHeader header, IntArray contour, IRectangularArea checkedRectangle) {
                return checkedRectangle.intersects(header.containingRectangle());
            }
        };


        abstract boolean accept(ContourHeader var1, IntArray var2, IRectangularArea var3);
    }
}

