/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary;

import net.algart.arrays.BitArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.BitMultiMatrixFilter;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyFilter;
import net.algart.math.IRange;
import net.algart.math.Range;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;
import net.algart.math.patterns.Pattern;
import net.algart.matrices.morphology.BasicMorphology;
import net.algart.matrices.morphology.ContinuedMorphology;
import net.algart.matrices.morphology.Morphology;
import net.algart.matrices.skeletons.BasicSkeletonPixelClassifier2D;
import net.algart.matrices.skeletons.SkeletonPixelClassifier;
import net.algart.multimatrix.MultiMatrix;

public final class SkeletonPixelTypes
extends BitMultiMatrixFilter {
    public static final String INPUT_SKELETON = "skeleton";
    public static final String OUTPUT_TYPE_CODES = "type_codes";
    private Algorithm algorithm = Algorithm.STRONG_QUADRUPLE_3_X_5_THINNING;
    private PixelType pixelType = PixelType.USUAL_NODE;
    private boolean invert = false;
    private int dilationSize = 0;

    public SkeletonPixelTypes() {
        this.setDefaultInputMat(INPUT_SKELETON);
        this.addOutputMat(OUTPUT_TYPE_CODES);
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public SkeletonPixelTypes setAlgorithm(Algorithm algorithm) {
        this.algorithm = (Algorithm)((Object)SkeletonPixelTypes.nonNull((Object)((Object)algorithm)));
        return this;
    }

    public PixelType getPixelType() {
        return this.pixelType;
    }

    public SkeletonPixelTypes setPixelType(PixelType pixelType) {
        this.pixelType = (PixelType)((Object)SkeletonPixelTypes.nonNull((Object)((Object)pixelType)));
        return this;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public SkeletonPixelTypes setInvert(boolean invert) {
        this.invert = invert;
        return this;
    }

    public int getDilationSize() {
        return this.dilationSize;
    }

    public SkeletonPixelTypes setDilationSize(int dilationSize) {
        this.dilationSize = SkeletonPixelTypes.nonNegative((int)dilationSize);
        return this;
    }

    public Matrix<? extends PArray> processMatrix(Matrix<? extends PArray> bitMatrix) {
        SkeletonPixelClassifier skeletonPixelClassifier = this.algorithm.getSkeletonPixelClassifier();
        Matrix pixelTypes = Matrices.clone((Matrix)skeletonPixelClassifier.asPixelTypes(bitMatrix.cast(BitArray.class), SkeletonPixelClassifier.AttachmentInformation.NEIGHBOUR_INDEX_OF_ATTACHED_NODE));
        this.getMat(OUTPUT_TYPE_CODES).setTo((MultiMatrix)MultiMatrix.of2DMono((Matrix)this.reduce(pixelTypes)));
        final double yesValue = this.invert ? 0.0 : 1.0;
        final double noValue = this.invert ? 1.0 : 0.0;
        Matrix result = Matrices.clone((Matrix)Matrices.asFuncMatrix((Func)new AbstractFunc(){

            public double get(double ... x) {
                return this.get(x[0]);
            }

            public double get(double x0) {
                return SkeletonPixelTypes.this.pixelType.isThisPixelType(x0) ? yesValue : noValue;
            }
        }, BitArray.class, (Matrix)pixelTypes));
        if (this.dilationSize > 0) {
            ContinuedMorphology morphology = ContinuedMorphology.getInstance((Morphology)BasicMorphology.getInstance(null), (Matrix.ContinuationMode)Matrix.ContinuationMode.getConstantMode((Object)noValue));
            Pattern pattern = MorphologyFilter.Shape.SPHERE.newPattern(bitMatrix.dimCount(), this.dilationSize);
            result = this.invert ? morphology.erosion(result, pattern) : morphology.dilation(result, pattern);
        }
        return result;
    }

    protected boolean zeroExtending() {
        return true;
    }

    public static enum Algorithm {
        OCTUPLE_THINNING{

            @Override
            SkeletonPixelClassifier getSkeletonPixelClassifier() {
                return BasicSkeletonPixelClassifier2D.getOctupleThinningInstance();
            }
        }
        ,
        QUADRUPLE_3_X_5_THINNING{

            @Override
            SkeletonPixelClassifier getSkeletonPixelClassifier() {
                return BasicSkeletonPixelClassifier2D.getQuadruple3x5ThinningInstance();
            }
        }
        ,
        STRONG_QUADRUPLE_3_X_5_THINNING{

            @Override
            SkeletonPixelClassifier getSkeletonPixelClassifier() {
                return BasicSkeletonPixelClassifier2D.getStrongQuadruple3x5ThinningInstance();
            }
        };


        abstract SkeletonPixelClassifier getSkeletonPixelClassifier();
    }

    public static enum PixelType {
        ILLEGAL(-5),
        BRANCHE_OR_FREE_BRANCH_END(new int[]{-4, -3}){

            @Override
            boolean isThisPixelType(double pixelType) {
                return super.isThisPixelType(pixelType) || pixelType >= 0.0;
            }
        }
        ,
        BRANCH_WITHOUT_FREE_BRANCHE_END(new int[]{-4}){

            @Override
            boolean isThisPixelType(double pixelType) {
                return super.isThisPixelType(pixelType) || pixelType >= 0.0;
            }
        }
        ,
        NODE_OR_ISOLATED(-1, -2),
        NODE_OR_ISOLATED_OR_FREE_BRANCH_END(-3, -1),
        USUAL_NODE(-1),
        USUAL_BRANCH(-4),
        ATTACHING_BRANCH(0, 7),
        FREE_BRANCH_END(-3),
        ISOLATED(-2),
        FREE_BRANCH_END_OR_ISOLATED(-3, -2);

        private final Range range;

        private PixelType(int ... list) {
            int min = list[0];
            int max = list[0];
            for (int k = 1; k < list.length; ++k) {
                min = Math.min(min, list[k]);
                max = Math.max(max, list[k]);
            }
            this.range = IRange.valueOf((long)min, (long)max).toRange();
        }

        boolean isThisPixelType(double pixelType) {
            return this.range.contains(pixelType);
        }
    }
}

