/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects;

import net.algart.arrays.Matrix;
import net.algart.executors.modules.core.common.matrices.MultiMatrix2DFilter;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyOperation;
import net.algart.executors.modules.cv.matrices.morphology.StrictMorphology;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class LabelsBoundaries
extends MultiMatrix2DFilter {
    public static final String INPUT_LABELS = "labels";
    private boolean invert = false;

    public LabelsBoundaries() {
        this.setDefaultInputMat(INPUT_LABELS);
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public MultiMatrix2D process(MultiMatrix2D labels) {
        StrictMorphology morphologyGradient = new StrictMorphology();
        morphologyGradient.setOperation(MorphologyOperation.BEUCHER_GRADIENT);
        morphologyGradient.setCustomPattern(MorphologyOperation.crossPattern(labels.dimCount()));
        morphologyGradient.setContinuationMode(Matrix.ContinuationMode.MIRROR_CYCLIC);
        if (this.invert) {
            MultiMatrix2D nonBackground = labels.nonZeroAnyChannel();
            return morphologyGradient.process((MultiMatrix)labels).zeroAllChannels().min((MultiMatrix)nonBackground).asMultiMatrix2D();
        }
        return morphologyGradient.process((MultiMatrix)labels).nonZeroAnyChannel().asMultiMatrix2D();
    }
}

