/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.drawing;

import java.util.Set;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.matrices.drawing.PositionsAndColors;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyFilter;
import net.algart.math.IPoint;
import net.algart.math.Point;
import net.algart.math.patterns.Pattern;

public final class DrawPattern
extends MorphologyFilter {
    public static final String INPUT_POSITIONS = "positions";
    public static final String INPUT_COLORS = "colors";
    private long x = 0L;
    private long y = 0L;
    private String color = "#FFFFFF";
    private boolean clearSource = false;

    public DrawPattern() {
        this.addInputNumbers(INPUT_POSITIONS);
        this.addInputNumbers(INPUT_COLORS);
    }

    public long getX() {
        return this.x;
    }

    public void setX(long x) {
        this.x = x;
    }

    public long getY() {
        return this.y;
    }

    public void setY(long y) {
        this.y = y;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = (String)DrawPattern.nonNull((Object)color);
    }

    public boolean isClearSource() {
        return this.clearSource;
    }

    public DrawPattern setClearSource(boolean clearSource) {
        this.clearSource = clearSource;
        return this;
    }

    protected Matrix<? extends PArray> processChannel(Matrix<? extends PArray> m) {
        UpdatablePArray updatableArray;
        SNumbers positions = this.getInputNumbers(INPUT_POSITIONS, true);
        SNumbers colors = this.getInputNumbers(INPUT_COLORS, true);
        double maxPossibleValue = ((PArray)m.array()).maxPossibleValue(1.0);
        double defaultValue = this.colorChannel(this.color, maxPossibleValue);
        PositionsAndColors positionsAndColors = new PositionsAndColors(positions, colors, new double[]{this.x, this.y}, defaultValue, 2);
        UpdatablePArray updatablePArray = this.clearSource ? (UpdatablePArray)Arrays.SMM.newUnresizableArray(m.array()) : (updatableArray = m.array() instanceof UpdatablePArray ? (UpdatablePArray)m.array() : ((PArray)m.array()).updatableClone((MemoryModel)Arrays.SMM));
        if (this.clearSource && this.currentChannel() == 3) {
            updatableArray.fill(updatableArray.maxPossibleValue(1.0));
        }
        Matrix updatableMatrix = m.matrix((Array)updatableArray);
        for (int k = 0; k < positionsAndColors.n(); ++k) {
            DrawPattern.drawPattern((Matrix<? extends UpdatablePArray>)updatableMatrix, this.getPattern(m), Point.valueOf((double)positionsAndColors.x(k), (double)positionsAndColors.y(k)).toRoundedPoint(), positionsAndColors.colorValue(k, this.currentChannel(), maxPossibleValue), this.getContinuationMode());
        }
        return updatableMatrix;
    }

    public static void drawPattern(Matrix<? extends UpdatablePArray> m, Pattern ptn, IPoint position, double value, Matrix.ContinuationMode continuationMode) {
        boolean is3d;
        boolean bl = is3d = ptn.dimCount() != 2;
        if (is3d) {
            ptn = ptn.maxBound(2);
        }
        Set points = ptn.points();
        for (Point p : points) {
            long index;
            long[] coordinates = (is3d ? p.projectionAlongAxis(2) : p).toRoundedPoint().add(position).coordinates();
            if (continuationMode == Matrix.ContinuationMode.CYCLIC) {
                index = m.cyclicIndex(coordinates);
            } else if (continuationMode == null || continuationMode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                index = m.pseudoCyclicIndex(coordinates);
            } else if (continuationMode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                index = m.mirrorCyclicIndex(coordinates);
            } else {
                if (!m.inside(coordinates)) continue;
                index = m.index(coordinates);
            }
            double v = value;
            if (is3d) {
                v += p.coord(2);
                v = Math.max(v, 0.0);
                v = Math.min(v, ((UpdatablePArray)m.array()).maxPossibleValue(1.0));
            }
            ((UpdatablePArray)m.array()).setDouble(index, v);
        }
    }
}

