/*
 * Decompiled with CFR 0.152.
 */
package com.siams.fx.control;

import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.worker.control.SControl;
import com.siams.fx.control.UIControlEventHandler;
import com.siams.fx.control.UIValueControl;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.PaneHelper;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.StackedBarChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.util.StringConverter;
import net.algart.executors.api.data.SNumbers;
import org.controlsfx.control.RangeSlider;

public class UIValueControlRange
extends AnchorPane
implements UIValueControl,
ChangeListener<Range> {
    private static final Logger logger = Logger.getLogger(UIValueControlRange.class.getCanonicalName());
    private UIControlEventHandler eventHandler;
    private SControl structureControl;
    @FXML
    private AnchorPane apImageHolder;
    @FXML
    private ImageView ivHist;
    @FXML
    private Pane lBound;
    @FXML
    private Pane rBound;
    @FXML
    private RangeSlider rangeSlider;
    @FXML
    private Spinner<Number> lowerValue;
    @FXML
    private Spinner<Number> upperValue;

    UIValueControlRange() {
        try {
            CustomFXMLLoader.loadElement((Object)this);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error during construct range control", e);
        }
    }

    @Override
    public void setProperty(SimplePrimitive property) {
        if (property.getVal() == null) {
            return;
        }
        if (property.getType() == SimplePrimitive.PRIMITIVE_TYPE.STR) {
            String strPair = property.getVal().toString();
            String[] arrPair = strPair.split(",");
            try {
                double lower = Double.parseDouble(arrPair[0]);
                double upper = Double.parseDouble(arrPair[1]);
                this.rangeSlider.setMajorTickUnit((upper - lower) / 4.0);
                this.rangeSlider.setShowTickMarks(true);
                this.rangeSlider.setShowTickLabels(true);
            }
            catch (NumberFormatException e) {
                logger.log(Level.SEVERE, "Can't parse range from string primitive: " + strPair, e);
            }
        } else {
            logger.log(Level.SEVERE, "Unsupported primitive type for range control: " + property.getType().name());
        }
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public void setControlEventHandler(UIControlEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    public void setStructureControl(SControl structureControl) {
        this.structureControl = structureControl;
        switch (structureControl.getValueType()) {
            case SCALAR: 
            case STRING: {
                Number lower = 0.0;
                Number upper = 1.0;
                Number tick = 0.01;
                Number min = !Double.isNaN(structureControl.getMin()) ? structureControl.getMin() : 0.0;
                Number max = !Double.isNaN(structureControl.getMax()) ? structureControl.getMax() : 1.0;
                String strPair = structureControl.getDef();
                if (!strPair.isEmpty()) {
                    String[] arrPair = strPair.split(",");
                    try {
                        lower = Integer.parseInt(arrPair[0]);
                        upper = Integer.parseInt(arrPair[1]);
                        int iMin = !Double.isNaN(structureControl.getMin()) ? (int)structureControl.getMin() : lower.intValue();
                        int iMax = !Double.isNaN(structureControl.getMax()) ? (int)structureControl.getMax() : upper.intValue();
                        min = iMin;
                        max = iMax;
                        tick = 1;
                    }
                    catch (Throwable ignore) {
                        try {
                            lower = Double.parseDouble(arrPair[0]);
                            upper = Double.parseDouble(arrPair[1]);
                            double dMin = !Double.isNaN(structureControl.getMin()) ? structureControl.getMin() : lower.doubleValue();
                            double dMax = !Double.isNaN(structureControl.getMax()) ? structureControl.getMax() : upper.doubleValue();
                            min = dMin;
                            max = dMax;
                            tick = 0.01;
                        }
                        catch (NumberFormatException e) {
                            logger.severe("Can't parse range from string primitive: " + strPair);
                            System.err.println("Can't parse range from string primitive: " + strPair);
                        }
                    }
                }
                this.lowerValue.setValueFactory((SpinnerValueFactory)new NumberSpinnerValueFactory(min, max, lower, tick));
                this.upperValue.setValueFactory((SpinnerValueFactory)new NumberSpinnerValueFactory(min, max, upper, tick));
                this.lowerValue.getValueFactory().setValue((Object)lower);
                this.upperValue.getValueFactory().setValue((Object)upper);
                this.rangeSlider.setMin(((Number)min).doubleValue());
                this.rangeSlider.setLowValue(lower.doubleValue());
                this.rangeSlider.setMax(max.doubleValue());
                this.rangeSlider.setHighValue(upper.doubleValue());
                this.rangeSlider.lowValueProperty().bindBidirectional((Property)this.lowerValue.getValueFactory().valueProperty());
                this.rangeSlider.highValueProperty().bindBidirectional((Property)this.upperValue.getValueFactory().valueProperty());
                this.lBound.prefWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
                    double chartWidth = this.apImageHolder.getWidth();
                    double axisRange = this.rangeSlider.getMax() - this.rangeSlider.getMin();
                    double widthFraction = this.rangeSlider.getLowValue() / axisRange;
                    return chartWidth * widthFraction;
                }, (Observable[])new Observable[]{this.rangeSlider.lowValueProperty()}));
                this.rBound.prefWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
                    double chartWidth = this.apImageHolder.getWidth();
                    double axisRange = this.rangeSlider.getMax() - this.rangeSlider.getMin();
                    double widthFraction = (this.rangeSlider.getMax() - this.rangeSlider.getHighValue()) / axisRange;
                    return chartWidth * widthFraction;
                }, (Observable[])new Observable[]{this.rangeSlider.highValueProperty()}));
                break;
            }
            default: {
                logger.severe(String.format("Unsupported spinner data type: '%s', control: '%s'", structureControl.getValueType().toString(), structureControl.getName()));
            }
        }
    }

    @Override
    public SControl getStructureControl() {
        return this.structureControl;
    }

    @Override
    public void setNumbersData(SNumbers sNumbers) {
        int numberOfSamples = sNumbers.getBlockLength();
        int sampleLength = sNumbers.n();
        DecimalFormat doubleValueFormatter = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.US));
        BinaryOperator increment = (existingValue, newValue) -> existingValue + 1L;
        Function<Double, Long> longIdentity = d -> 1L;
        ObservableList data = FXCollections.observableArrayList();
        for (int i = 0; i < numberOfSamples; ++i) {
            String name = String.format("Sample #%d", i);
            double[] sample = new double[sampleLength];
            sNumbers.getBlockDoubleValues(i, sample);
            TreeMap valuesToFrequencies = DoubleStream.of(sample).boxed().collect(Collectors.toMap(Function.identity(), longIdentity, increment, TreeMap::new));
            ObservableList sampleData = valuesToFrequencies.entrySet().stream().map(entry -> new XYChart.Data((Object)doubleValueFormatter.format(entry.getKey()), (Object)((Number)entry.getValue()))).collect(Collectors.toCollection(FXCollections::observableArrayList));
            data.add((Object)new XYChart.Series(name, sampleData));
        }
        Range yAxisRange = data.stream().flatMap(series -> series.getData().stream()).map(dat -> new Range(0L, ((Number)dat.getYValue()).longValue())).reduce((lhs, rhs) -> new Range(Math.min(lhs.lower.longValue(), rhs.lower.longValue()), Math.max(lhs.upper.longValue(), rhs.upper.longValue()))).orElse(new Range(0.0, 1.0));
        ObservableList numberCategories = data.stream().flatMap(series -> series.getData().stream()).map(XYChart.Data::getXValue).distinct().collect(Collectors.toCollection(FXCollections::observableArrayList));
        CategoryAxis xAxis = new CategoryAxis(numberCategories);
        long amountToStepBy = (yAxisRange.upper.longValue() - yAxisRange.lower.longValue()) / 4L;
        NumberAxis yAxis = new NumberAxis(yAxisRange.lower.doubleValue(), yAxisRange.upper.doubleValue(), (double)amountToStepBy);
        StackedBarChart chart = new StackedBarChart((Axis)xAxis, (Axis)yAxis, data, 0.0);
        chart.setLegendVisible(false);
        xAxis.setTickMarkVisible(false);
        yAxis.setTickMarkVisible(false);
        this.apImageHolder.getChildren().add(0, (Object)chart);
        PaneHelper.setAnchorZero((Node)chart);
    }

    public void changed(ObservableValue<? extends Range> observableValue, Range oldValue, Range newValue) {
        if (newValue.equals(oldValue)) {
            return;
        }
        if (this.eventHandler != null) {
            Number lower = (Number)this.lowerValue.valueProperty().get();
            Number upper = (Number)this.upperValue.valueProperty().get();
            String strRange = lower instanceof Float && upper instanceof Float || lower instanceof Double && upper instanceof Double ? String.format("%f,%f", newValue.getLower().doubleValue(), newValue.getUpper().doubleValue()) : String.format("%d,%d", newValue.getLower().intValue(), newValue.getUpper().intValue());
            this.eventHandler.onValueChange(this.structureControl, strRange);
        }
    }

    private static class NumberSpinnerValueFactory
    extends SpinnerValueFactory<Number> {
        private final Number min;
        private final Number max;
        private final Number initialValue;
        private final Number amountToStepBy;

        private NumberSpinnerValueFactory(Number min, Number max, Number initialValue, Number amountToStepBy) {
            this.min = min;
            this.max = max;
            this.initialValue = initialValue;
            this.amountToStepBy = amountToStepBy;
            if (initialValue instanceof Float || initialValue instanceof Double) {
                this.setConverter((StringConverter)new StringConverter<Number>(){
                    private final DecimalFormat formatter = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));

                    public String toString(Number object) {
                        return this.formatter.format(object.doubleValue());
                    }

                    public Number fromString(String string) {
                        return this.checkValueRange(Double.parseDouble(string));
                    }
                });
            } else {
                this.setConverter((StringConverter)new StringConverter<Number>(){

                    public String toString(Number object) {
                        return String.valueOf(object.intValue());
                    }

                    public Number fromString(String string) {
                        return this.checkValueRange(Integer.parseInt(string));
                    }
                });
            }
            this.setValue(initialValue);
        }

        public void decrement(int steps) {
            Double newValue = this.getValue() instanceof Float || this.getValue() instanceof Double ? this.checkValueRange(((Number)this.getValue()).doubleValue() - (double)steps * this.amountToStepBy.doubleValue()) : (double)this.checkValueRange(((Number)this.getValue()).intValue() - steps * this.amountToStepBy.intValue()).intValue();
            this.setValue(newValue);
        }

        public void increment(int steps) {
            Double newValue = this.getValue() instanceof Float || this.getValue() instanceof Double ? this.checkValueRange(((Number)this.getValue()).doubleValue() + (double)steps * this.amountToStepBy.doubleValue()) : (double)this.checkValueRange(((Number)this.getValue()).intValue() + steps * this.amountToStepBy.intValue()).intValue();
            this.setValue(newValue);
        }

        private Integer checkValueRange(int newValue) {
            return Math.min(this.max.intValue(), Math.max(this.min.intValue(), newValue));
        }

        private Double checkValueRange(double newValue) {
            return Math.min(this.max.doubleValue(), Math.max(this.min.doubleValue(), newValue));
        }
    }

    static class Range {
        private final Number lower;
        private final Number upper;

        public Range() {
            this.lower = 0.0;
            this.upper = 1.0;
        }

        public Range(Number lower, Number upper) {
            this.lower = lower;
            this.upper = upper;
        }

        public Number getLower() {
            return this.lower;
        }

        public Number getUpper() {
            return this.upper;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Range)) {
                return false;
            }
            Range rhs = (Range)obj;
            return this.lower.doubleValue() == rhs.lower.doubleValue() && this.upper.doubleValue() == rhs.upper.doubleValue();
        }

        public String toString() {
            return String.format("Range{%.3f; %.3f}", this.lower.doubleValue(), this.upper.doubleValue());
        }
    }
}

