/*
 * Decompiled with CFR 0.152.
 */
package com.siams.fx.control;

import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.worker.control.SControl;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fx.control.UIValueControlDoubleSpinner;
import com.siams.fx.control.UIValueControlNumberSpinner;
import com.siams.fxml.loader.CustomFXMLLoader;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class UIValueControlIntegerSpinner
extends UIValueControlNumberSpinner<Integer>
implements ChangeListener<Integer> {
    private final Logger logger = Logger.getLogger(UIValueControlDoubleSpinner.class);

    public UIValueControlIntegerSpinner() {
        try {
            CustomFXMLLoader.loadElement((Object)this);
            this.lblHelp.setTooltip((Tooltip)new StareTooltip("Up/Down/PageUp/PageDown/Shift+Up/Shift+Down keyboard"));
            this.spinnerValue.valueProperty().addListener((ChangeListener)this);
            this.spinnerValue.focusedProperty().addListener((observable, oldValue, newValue) -> {
                try {
                    boolean loosedFocus;
                    int value = Integer.parseInt(this.spinnerValue.getEditor().getText());
                    boolean bl = loosedFocus = newValue == false;
                    if (loosedFocus) {
                        this.changed(null, (Integer)this.changedValue, value);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            this.spinnerValue.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, e -> {
                boolean consume = false;
                int step = 0;
                switch (e.getCode()) {
                    case UP: {
                        step = 1;
                        consume = true;
                        break;
                    }
                    case DOWN: {
                        step = -1;
                        consume = true;
                        break;
                    }
                    case PAGE_UP: {
                        step = 10;
                        consume = true;
                        break;
                    }
                    case PAGE_DOWN: {
                        step = -10;
                        consume = true;
                    }
                }
                if (step > 0) {
                    this.spinnerValue.increment(step);
                } else if (step < 0) {
                    this.spinnerValue.decrement(Math.abs(step));
                }
                if (consume) {
                    e.consume();
                }
            });
            this.spinnerValue.getEditor().textProperty().addListener((ob, o, n) -> {
                try {
                    this.changedValue = Integer.parseInt(n);
                    int oldValue = 0;
                    try {
                        oldValue = Integer.parseInt(o);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.changed(null, oldValue, (Integer)this.changedValue);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
        catch (Throwable t) {
            this.logger.error((Object)"Error during construct double spinner", t);
        }
    }

    @Override
    public void setProperty(SimplePrimitive property) {
        this.spinnerValue.valueProperty().removeListener((ChangeListener)this);
        try {
            int value = property.asInt();
            this.spinnerValue.getValueFactory().setValue((Object)value);
            this.changedValue = value;
        }
        catch (Throwable t) {
            this.logger.log((Priority)Level.WARN, (Object)String.format("Failed extract property: %s", property), t);
        }
        this.spinnerValue.valueProperty().addListener((ChangeListener)this);
    }

    @Override
    public void setStructureControl(SControl structureControl) {
        this.structureControl = structureControl;
        switch (structureControl.getValueType()) {
            case BYTE: {
                int min = !Double.isNaN(structureControl.getMin()) ? (int)((int)structureControl.getMin()) : -128;
                int max = !Double.isNaN(structureControl.getMax()) ? (int)((int)structureControl.getMax()) : 127;
                byte step = (byte)(structureControl.isEven() || structureControl.isOdd() ? 2 : 1);
                byte def = 0;
                try {
                    def = !structureControl.getDef().isEmpty() ? Byte.parseByte(structureControl.getDef()) : (byte)(structureControl.isOdd() ? 1 : 0);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.spinnerValue.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(min, max, (int)def, (int)step));
                break;
            }
            case SHORT: {
                int min = !Double.isNaN(structureControl.getMin()) ? (int)((int)structureControl.getMin()) : Short.MIN_VALUE;
                int max = !Double.isNaN(structureControl.getMax()) ? (int)((int)structureControl.getMax()) : Short.MAX_VALUE;
                short step = (short)(structureControl.isEven() || structureControl.isOdd() ? 2 : 1);
                short def = 0;
                try {
                    def = !structureControl.getDef().isEmpty() ? Short.parseShort(structureControl.getDef()) : (short)(structureControl.isOdd() ? 1 : 0);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.spinnerValue.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(min, max, (int)def, (int)step));
                break;
            }
            case INT: 
            case LONG: {
                int min = !Double.isNaN(structureControl.getMin()) ? (int)structureControl.getMin() : Integer.MIN_VALUE;
                int max = !Double.isNaN(structureControl.getMax()) ? (int)structureControl.getMax() : Integer.MAX_VALUE;
                int step = structureControl.isEven() || structureControl.isOdd() ? 2 : 1;
                int def = 0;
                try {
                    def = !structureControl.getDef().isEmpty() ? Integer.parseInt(structureControl.getDef()) : (int)((short)(structureControl.isOdd() ? 1 : 0));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.spinnerValue.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(min, max, def, step));
                break;
            }
            default: {
                this.logger.error((Object)String.format("Unsupported spinner data type: '%s', control: '%s'", structureControl.getValueType().toString(), structureControl.getName()));
            }
        }
        String hint = structureControl.getSmartHint();
        if (!hint.isEmpty()) {
            Tooltip.install((Node)this.spinnerValue.getEditor(), (Tooltip)new StareTooltip(hint));
        }
    }

    @Override
    public SControl getStructureControl() {
        return this.structureControl;
    }

    public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
        if (newValue.equals(oldValue)) {
            return;
        }
        this.changedValue = newValue;
        if (this.eventHandler != null) {
            this.eventHandler.onValueChange(this.structureControl, newValue);
        }
    }
}

