/*
 * Decompiled with CFR 0.152.
 */
package com.siams.fx.control;

import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.worker.control.SControl;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fx.control.UIValueControlNumberSpinner;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.spinner.DoubleSpinnerValueFactory;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class UIValueControlDoubleSpinner
extends UIValueControlNumberSpinner<Double> {
    private final Logger logger = Logger.getLogger(UIValueControlDoubleSpinner.class);
    private double stepValue = 0.01;

    public UIValueControlDoubleSpinner() {
        try {
            CustomFXMLLoader.loadElement((Object)this);
            this.lblHelp.setTooltip((Tooltip)new StareTooltip("Up/Down/PageUp/PageDown/Shift+Up/Shift+Down keyboard"));
            this.spinnerValue.valueProperty().addListener((ChangeListener)this);
            this.spinnerValue.focusedProperty().addListener((observable, oldValue, newValue) -> {
                try {
                    boolean loosedFocus;
                    double value = Double.parseDouble(this.spinnerValue.getEditor().getText());
                    boolean bl = loosedFocus = newValue == false;
                    if (loosedFocus) {
                        this.changed(null, (Double)this.changedValue, value);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            this.spinnerValue.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, e -> {
                boolean consume = false;
                int stepsDiff = 0;
                int factor = this.stepValue < 1.0 ? 100 : 1;
                switch (e.getCode()) {
                    case UP: {
                        stepsDiff = 1 * factor;
                        if (e.isShiftDown()) {
                            stepsDiff = (int)((double)factor * 0.01);
                        }
                        consume = true;
                        break;
                    }
                    case DOWN: {
                        stepsDiff = -1 * factor;
                        if (e.isShiftDown()) {
                            stepsDiff = (int)((double)(-factor) * 0.01);
                        }
                        consume = true;
                        break;
                    }
                    case PAGE_UP: {
                        stepsDiff = 10 * factor;
                        consume = true;
                        break;
                    }
                    case PAGE_DOWN: {
                        stepsDiff = -10 * factor;
                        consume = true;
                    }
                }
                if (stepsDiff > 0) {
                    this.spinnerValue.increment(stepsDiff);
                } else if (stepsDiff < 0) {
                    this.spinnerValue.decrement(Math.abs(stepsDiff));
                }
                if (consume) {
                    e.consume();
                }
            });
            this.spinnerValue.getEditor().textProperty().addListener((ob, o, n) -> {
                try {
                    this.changedValue = Double.parseDouble(n);
                    double oldValue = 0.0;
                    try {
                        oldValue = Double.parseDouble(o);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.changed(null, oldValue, (Double)this.changedValue);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
        catch (Throwable t) {
            this.logger.error((Object)"Error during construct double spinner", t);
        }
    }

    @Override
    public void setProperty(SimplePrimitive property) {
        this.spinnerValue.valueProperty().removeListener((ChangeListener)this);
        try {
            double value = property.asDouble();
            this.spinnerValue.getValueFactory().setValue((Object)value);
            this.changedValue = value;
        }
        catch (Throwable t) {
            this.logger.log((Priority)Level.WARN, (Object)String.format("Failed extract property: %s", property), t);
        }
        this.spinnerValue.valueProperty().addListener((ChangeListener)this);
    }

    @Override
    public void setStructureControl(SControl structureControl) {
        this.structureControl = structureControl;
        switch (structureControl.getValueType()) {
            case FLOAT: {
                float min = !Double.isNaN(structureControl.getMin()) ? (float)structureControl.getMin() : -3.4028235E38f;
                float max = !Double.isNaN(structureControl.getMax()) ? (float)structureControl.getMax() : Float.MAX_VALUE;
                float def = 0.0f;
                this.stepValue = structureControl.isEven() || structureControl.isOdd() ? 2.0 : 0.01;
                try {
                    def = !structureControl.getDef().isEmpty() ? Float.parseFloat(structureControl.getDef()) : (structureControl.isOdd() ? 1.0f : 0.0f);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.spinnerValue.setValueFactory((SpinnerValueFactory)new DoubleSpinnerValueFactory((double)min, (double)max, (double)def, this.stepValue));
                break;
            }
            case DOUBLE: {
                double min = !Double.isNaN(structureControl.getMin()) ? structureControl.getMin() : -1.7976931348623157E308;
                double max = !Double.isNaN(structureControl.getMax()) ? structureControl.getMax() : Double.MAX_VALUE;
                this.stepValue = structureControl.isEven() || structureControl.isOdd() ? 2.0 : 0.01;
                double def = 0.0;
                try {
                    def = !structureControl.getDef().isEmpty() ? Double.parseDouble(structureControl.getDef()) : (structureControl.isOdd() ? 1.0 : 0.0);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.spinnerValue.setValueFactory((SpinnerValueFactory)new DoubleSpinnerValueFactory(min, max, def, this.stepValue));
                break;
            }
            default: {
                this.logger.error((Object)String.format("Unsupported spinner data type: '%s', control: '%s'", structureControl.getValueType().toString(), structureControl.getName()));
            }
        }
        String hint = structureControl.getSmartHint();
        if (!hint.isEmpty()) {
            Tooltip.install((Node)this.spinnerValue, (Tooltip)new StareTooltip(hint));
        }
    }

    @Override
    public SControl getStructureControl() {
        return this.structureControl;
    }

    public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
        if (newValue.equals(oldValue)) {
            return;
        }
        this.changedValue = newValue;
        if (this.eventHandler != null) {
            this.eventHandler.onValueChange(this.structureControl, newValue);
        }
    }
}

