/*
 * Decompiled with CFR 0.152.
 */
package com.siams.fx.control;

import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.worker.control.SCEItem;
import com.siams.cv.monitor.model.worker.control.SCEnum;
import com.siams.cv.monitor.model.worker.control.SControl;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fx.control.UIControlEventHandler;
import com.siams.fx.control.UIValueControl;
import com.siams.fxml.loader.CustomFXMLLoader;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import org.apache.log4j.Logger;

public class UIValueControlComboBox
extends AnchorPane
implements UIValueControl,
ChangeListener<SCEItem> {
    private static Logger logger = Logger.getLogger(UIValueControlComboBox.class);
    private UIControlEventHandler eventHandler;
    private SControl structureControl;
    private SCEnum scEnum;
    @FXML
    private ComboBox<SCEItem> comboBoxValue;

    UIValueControlComboBox() {
        try {
            CustomFXMLLoader.loadElement((Object)this);
            this.comboBoxValue.valueProperty().addListener((ChangeListener)this);
            this.comboBoxValue.setVisibleRowCount(20);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setProperty(SimplePrimitive property) {
        if (this.scEnum == null) {
            return;
        }
        this.comboBoxValue.valueProperty().removeListener((ChangeListener)this);
        String propertyValue = property.asString("");
        Optional optItem = this.scEnum.findItem(propertyValue);
        if (optItem.isPresent()) {
            this.comboBoxValue.getSelectionModel().select((Object)((SCEItem)optItem.get()));
        } else {
            logger.error((Object)String.format("SCEItem can't be found for value: %s", propertyValue));
        }
        this.comboBoxValue.valueProperty().addListener((ChangeListener)this);
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public void setControlEventHandler(UIControlEventHandler eventHandler) {
        this.comboBoxValue.valueProperty().removeListener((ChangeListener)this);
        this.eventHandler = eventHandler;
        this.comboBoxValue.valueProperty().addListener((ChangeListener)this);
    }

    @Override
    public void setStructureControl(SControl structureControl) {
        String hint;
        this.structureControl = structureControl;
        if (SCEnum.class.isAssignableFrom(structureControl.getClass())) {
            this.scEnum = (SCEnum)structureControl;
            this.comboBoxValue.getItems().addAll((Collection)this.scEnum.getItems());
        }
        if (!(hint = structureControl.getSmartHint()).isEmpty()) {
            this.comboBoxValue.setTooltip((Tooltip)new StareTooltip(hint));
        }
    }

    @Override
    public SControl getStructureControl() {
        return this.structureControl;
    }

    public void changed(ObservableValue<? extends SCEItem> observable, SCEItem oldValue, SCEItem newValue) {
        if (Objects.equals(oldValue, newValue)) {
            return;
        }
        Object value = ((SCEItem)this.comboBoxValue.getValue()).getTypedValue(this.structureControl.getValueType());
        this.eventHandler.onValueChange(this.structureControl, value);
    }
}

