/*
 * Decompiled with CFR 0.152.
 */
package com.siams.fx.control;

import com.siams.cv.monitor.model.worker.control.SCValue;
import com.siams.cv.monitor.model.worker.control.SControl;
import com.siams.fx.control.UIValueControl;
import com.siams.fx.control.UIValueControlCheckBox;
import com.siams.fx.control.UIValueControlColor;
import com.siams.fx.control.UIValueControlComboBox;
import com.siams.fx.control.UIValueControlContainer;
import com.siams.fx.control.UIValueControlDoubleSpinner;
import com.siams.fx.control.UIValueControlFile;
import com.siams.fx.control.UIValueControlFolder;
import com.siams.fx.control.UIValueControlIntegerSpinner;
import com.siams.fx.control.UIValueControlRange;
import com.siams.fx.control.UIValueControlSettings;
import com.siams.fx.control.UIValueControlTextArea;
import com.siams.fx.control.UIValueControlTextField;
import javafx.scene.layout.AnchorPane;

public class UIControlBuilder {
    public static UIValueControlContainer createUIControl(SControl structureControl) {
        UIValueControlContainer controlContainer = new UIValueControlContainer();
        UIValueControl valueControl = switch (structureControl.getEditionType()) {
            case SControl.EditionType.VALUE -> UIControlBuilder.createUIValueControl(structureControl);
            case SControl.EditionType.ENUM -> UIControlBuilder.createUIEnumControl();
            case SControl.EditionType.TEXT -> UIControlBuilder.createUITextControl();
            case SControl.EditionType.FILE, SControl.EditionType.FILE_TO_SAVE -> UIControlBuilder.createUIFileControl();
            case SControl.EditionType.FOLDER -> UIControlBuilder.createUIFolderControl();
            case SControl.EditionType.COLOR -> UIControlBuilder.createUIColorControl();
            case SControl.EditionType.RANGE -> UIControlBuilder.createUIRangeControl();
            default -> throw new IllegalArgumentException("Unsupported control edition type: " + String.valueOf(structureControl.getEditionType()));
        };
        valueControl.setControlEventHandler(controlContainer);
        valueControl.setStructureControl(structureControl);
        controlContainer.setValueControl(valueControl);
        controlContainer.setStructureControl(structureControl);
        return controlContainer;
    }

    private static UIValueControl createUIValueControl(SControl structureControl) {
        boolean isMultiline = false;
        if (SCValue.class.isAssignableFrom(structureControl.getClass())) {
            isMultiline = ((SCValue)structureControl).isMultiline();
        }
        AnchorPane control = switch (structureControl.getValueType()) {
            case SControl.ValueType.BYTE, SControl.ValueType.INT, SControl.ValueType.LONG -> new UIValueControlIntegerSpinner();
            case SControl.ValueType.FLOAT, SControl.ValueType.DOUBLE -> new UIValueControlDoubleSpinner();
            case SControl.ValueType.STRING, SControl.ValueType.SCALAR -> {
                if (isMultiline) {
                    yield new UIValueControlTextArea();
                }
                yield new UIValueControlTextField();
            }
            case SControl.ValueType.SETTINGS -> new UIValueControlSettings();
            case SControl.ValueType.BOOLEAN -> new UIValueControlCheckBox();
            default -> throw new IllegalArgumentException("Unsupported value control: " + String.valueOf(structureControl.getValueType()));
        };
        return control;
    }

    private static UIValueControl createUIEnumControl() {
        return new UIValueControlComboBox();
    }

    private static UIValueControl createUITextControl() {
        return new UIValueControlTextArea();
    }

    private static UIValueControl createUIFileControl() {
        return new UIValueControlFile();
    }

    private static UIValueControl createUIFolderControl() {
        return new UIValueControlFolder();
    }

    private static UIValueControl createUIColorControl() {
        return new UIValueControlColor();
    }

    private static UIValueControl createUIRangeControl() {
        return new UIValueControlRange();
    }
}

