/*
 * Decompiled with CFR 0.152.
 */
package net.algart.jep.additions;

import java.util.Objects;
import javax.lang.model.SourceVersion;
import jep.DirectNDArray;
import jep.Interpreter;
import jep.JepException;
import jep.NDArray;
import jep.python.PyCallable;
import net.algart.jep.additions.JepNumpyIntegrationException;
import net.algart.jep.additions.JepSingleThreadInterpreter;

public class JepInterpretation {
    public static final String JEP_INSTALLATION_HINTS = "To install \"jep\" with all required packages, please use the following command:\n   py -m pip install --upgrade setuptools wheel numpy\n   py -m pip install --no-cache-dir --force-reinstall --no-build-isolation jep\nNote that \"numpy\" must be installed BEFORE \"jep\" for correct integration between \"jep\" and \"numpy\".\nBefore installing \"jep\", please set the environment variable JAVA_HOME to a path containing the JDK.";

    private JepInterpretation() {
    }

    public static Object checkNumpyIntegration(Interpreter jepInterpreter, String functionReturningNumpyArray) throws JepNumpyIntegrationException {
        Object array;
        Objects.requireNonNull(jepInterpreter, "Null JEP interpreter");
        Objects.requireNonNull(functionReturningNumpyArray, "Null verification function name");
        try (PyCallable creator = (PyCallable)jepInterpreter.getValue(functionReturningNumpyArray, PyCallable.class);){
            array = creator.call(new Object[0]);
        }
        catch (JepException e) {
            throw new JepException("Cannot execute Python verification function \"" + functionReturningNumpyArray + "\"; maybe, the corresponding Python module is not installed correctly", (Throwable)e);
        }
        if (!(array instanceof NDArray) && !(array instanceof DirectNDArray)) {
            throw new JepNumpyIntegrationException("Integration problem between Python packages \"jep\" and \"numpy\":\nthe function that creates numpy.ndarray does not return a correct Java type NDArray/DirectNDArray (it returns " + (array == null ? null : "\"" + array.getClass().getCanonicalName() + "\"") + ").\nThe \"jep\" package was probably not installed correctly in Python.\nTo install \"jep\" with all required packages, please use the following command:\n   py -m pip install --upgrade setuptools wheel numpy\n   py -m pip install --no-cache-dir --force-reinstall --no-build-isolation jep\nNote that \"numpy\" must be installed BEFORE \"jep\" for correct integration between \"jep\" and \"numpy\".\nBefore installing \"jep\", please set the environment variable JAVA_HOME to a path containing the JDK.", array);
        }
        return array;
    }

    public static Object getJVMGlobalLock() {
        return JepSingleThreadInterpreter.getGlobalLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeWithJVMGlobalLock(Runnable creation, Runnable processing, Runnable closing) {
        Objects.requireNonNull(creation, "Null creation");
        Objects.requireNonNull(processing, "Null processing");
        Objects.requireNonNull(closing, "Null closing");
        Object object = JepInterpretation.getJVMGlobalLock();
        synchronized (object) {
            try {
                creation.run();
                processing.run();
            }
            finally {
                closing.run();
            }
        }
    }

    public static String importPythonCode(String from, String whatToImport) {
        Objects.requireNonNull(from, "Null from");
        Objects.requireNonNull(whatToImport, "Null whatToImport");
        JepInterpretation.checkValidPythonImportName(whatToImport);
        JepInterpretation.checkValidPythonModuleName(from);
        return "from " + from + " import " + whatToImport + "\n";
    }

    public static void checkValidPythonFunctionName(String name) {
        if (name.isBlank()) {
            throw new IllegalArgumentException("Empty Python function name \"" + name + "\" is not allowed");
        }
        if (!SourceVersion.isIdentifier(name)) {
            throw new IllegalArgumentException("Invalid Python function name \"" + name + "\": it contains illegal characters");
        }
    }

    private static void checkValidPythonImportName(String what) {
        if (what.isBlank()) {
            throw new IllegalArgumentException("Empty Python attribute name \"" + what + "\" in import is not allowed");
        }
        if (!SourceVersion.isIdentifier(what)) {
            throw new IllegalArgumentException("Invalid Python attribute name \"" + what + "\" in import: it contains illegal characters");
        }
    }

    private static void checkValidPythonModuleName(String from) {
        String[] parts;
        if (from.isBlank()) {
            throw new IllegalArgumentException("Empty Python module name \"" + from + "\" is not allowed");
        }
        for (String part : parts = from.split("\\.")) {
            if (SourceVersion.isIdentifier(part)) continue;
            throw new IllegalArgumentException("Invalid Python module name \"" + from + "\": it contains illegal characters in the part \"" + part + "\"");
        }
    }
}

