/*
 * Decompiled with CFR 0.152.
 */
package net.algart.jep.additions;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jep.Interpreter;
import jep.JepConfig;
import jep.JepException;
import jep.SharedInterpreter;
import jep.SubInterpreter;
import net.algart.jep.additions.GlobalPythonConfiguration;
import net.algart.jep.additions.JepExtendedConfiguration;
import net.algart.jep.additions.JepType;

class JepCreationTools {
    private static final AtomicBoolean SUB_INTERPRETER_CREATED = new AtomicBoolean(false);
    private static final AtomicBoolean SHARED_INTERPRETER_CREATED = new AtomicBoolean(false);
    private static final Pattern IMPORT_MATCHER = Pattern.compile("^import\\s+(\\w+)");
    private static final Pattern IMPORT_NUMPY_MATCHER = Pattern.compile("\\bimport[ \\t]+numpy\\b");
    private static final System.Logger LOG = System.getLogger(JepCreationTools.class.getName());

    JepCreationTools() {
    }

    static SubInterpreter newSubInterpreter(JepConfig configuration, JepType type) {
        Objects.requireNonNull(configuration, "Null configuration");
        Objects.requireNonNull(type, "Null JEP interpretation type");
        SubInterpreter result = JepCreationTools.doCreate(() -> new SubInterpreter(configuration));
        SUB_INTERPRETER_CREATED.set(true);
        JepCreationTools.performStartupCodeForExtended((Interpreter)result, configuration, type);
        return result;
    }

    static SharedInterpreter newSharedInterpreter(JepConfig configuration, JepType type) {
        Objects.requireNonNull(configuration, "Null configuration");
        Objects.requireNonNull(type, "Null JEP interpretation type");
        if (!SHARED_INTERPRETER_CREATED.getAndSet(true)) {
            SharedInterpreter.setConfig((JepConfig)configuration);
        }
        SharedInterpreter result = JepCreationTools.doCreate(SharedInterpreter::new);
        JepCreationTools.performStartupCodeForExtended((Interpreter)result, configuration, type);
        return result;
    }

    static boolean wasSubInterpreterCreated() {
        return SUB_INTERPRETER_CREATED.get();
    }

    private static <T extends Interpreter> T doCreate(Supplier<T> constructor) {
        try {
            return (T)((Interpreter)constructor.get());
        }
        catch (UnsatisfiedLinkError | JepException e) {
            throw new JepException("Cannot find Python: \"jep\" module (Java Embedded Python) is not properly loaded.\n" + e.getClass().getSimpleName() + (String)(e instanceof UnsatisfiedLinkError ? "" : ": " + e.getMessage()) + "\nProbably " + JepCreationTools.unsatisfiedLinkDiagnostics(), e);
        }
    }

    private static String unsatisfiedLinkDiagnostics() {
        GlobalPythonConfiguration.PythonHomeInformation homeInformation = GlobalPythonConfiguration.INSTANCE.pythonHomeInformation();
        assert (homeInformation != null);
        if (homeInformation.unknown()) {
            return homeInformation.systemEnvironmentDisabled() ? "usage of PYTHONHOME environment variable is disabled, and Python home directory is not set properly" : "Python is not installed, or the path to your Python installation is not specified properly\n(for example via the PYTHONHOME system environment variable)";
        }
        String messageHome = "\"" + homeInformation.pythonHome() + "\" " + (homeInformation.systemEnvironmentUsed() ? "(value of PYTHONHOME environment variable) " : "");
        if (homeInformation.exists()) {
            return "Python is not correctly installed at " + messageHome + "or \"jep\" module is not properly installed.\nTo install \"jep\" with all required packages, please use the following command:\n   py -m pip install --upgrade setuptools wheel numpy\n   py -m pip install --no-cache-dir --force-reinstall --no-build-isolation jep\nNote that \"numpy\" must be installed BEFORE \"jep\" for correct integration between \"jep\" and \"numpy\".\nBefore installing \"jep\", please set the environment variable JAVA_HOME to a path containing the JDK.";
        }
        return "Python home " + messageHome + "is not an existing Python directory";
    }

    private static void performStartupCodeForExtended(Interpreter jepInterpreter, JepConfig configuration, JepType type) {
        Objects.requireNonNull(jepInterpreter, "Null jepInterpreter");
        if (configuration instanceof JepExtendedConfiguration) {
            JepExtendedConfiguration extendedConfiguration = (JepExtendedConfiguration)configuration;
            List<String> startupCode = extendedConfiguration.getStartupCode();
            LOG.log(System.Logger.Level.DEBUG, () -> "Executing JEP start-up code for %s Python interpreter in a thread \"%s\":%n%s".formatted(new Object[]{type, Thread.currentThread().getName(), startupCode.stream().map(s -> "<<" + s + ">>").collect(Collectors.joining("\n"))}));
            for (String codeSnippet : startupCode) {
                assert (codeSnippet != null) : "setStartupCode did not check null elements";
                BooleanSupplier probablyNumpy = () -> IMPORT_NUMPY_MATCHER.matcher(codeSnippet).find();
                if (type == JepType.SUB_INTERPRETER && probablyNumpy.getAsBoolean()) {
                    throw new JepException("cannot execute startup Python code: \"" + codeSnippet.trim() + "\", because it works with NumPy, which is strictly forbidden for Python sub-interpreters (interpretation type " + String.valueOf((Object)type) + ") and may crash the entire application");
                }
                try {
                    jepInterpreter.exec(codeSnippet);
                }
                catch (JepException e) {
                    if (e.getMessage() != null && e.getMessage().contains("nterpreter change detected")) {
                        throw e;
                    }
                    throw new JepException("cannot execute startup Python code: \"" + codeSnippet.trim() + "\".\nThe necessary Python package" + JepCreationTools.importedPackage(codeSnippet) + " was probably not installed correctly in Python" + (String)(probablyNumpy.getAsBoolean() && JepCreationTools.wasSubInterpreterCreated() ? ",\nor you already used JEP SubInterpreter, which is completely incompatible with NumPy even if was used once." : ".\n(Python error message: " + e.getMessage() + ").\nTo install \"jep\" with all required packages, please use the following command:\n   py -m pip install --upgrade setuptools wheel numpy\n   py -m pip install --no-cache-dir --force-reinstall --no-build-isolation jep\nNote that \"numpy\" must be installed BEFORE \"jep\" for correct integration between \"jep\" and \"numpy\".\nBefore installing \"jep\", please set the environment variable JAVA_HOME to a path containing the JDK."), (Throwable)e);
                }
            }
            if (extendedConfiguration.hasVerifier()) {
                Object status = extendedConfiguration.getVerifier().verify(jepInterpreter, extendedConfiguration);
                extendedConfiguration.setVerificationStatus(status);
            }
        }
    }

    private static String importedPackage(String code) {
        Matcher matcher = IMPORT_MATCHER.matcher(code.trim());
        return matcher.find() ? " \"" + matcher.group(1) + "\"" : "";
    }
}

