/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.algart.graalvm.JSType;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.io.ByteSequence;

public abstract class GraalSourceContainer {
    public static final String JAVASCRIPT_LANGUAGE = "js";
    private static final System.Logger LOG = System.getLogger(GraalSourceContainer.class.getName());
    private final AtomicBoolean changed = new AtomicBoolean(false);
    private volatile String language = null;
    private volatile Object origin = null;
    private volatile String name = null;
    private volatile String mimeType = null;
    private volatile Charset fileEncoding = null;
    private volatile Source source = null;

    GraalSourceContainer() {
    }

    public static GraalSourceContainer newContainer(SourceKind sourceKind) {
        Objects.requireNonNull(sourceKind, "Null source kind");
        return sourceKind.creator.get();
    }

    public static GraalSourceContainer newLiteralContainer() {
        return GraalSourceContainer.newContainer(SourceKind.LITERAL);
    }

    public static GraalSourceContainer newFileContainer() {
        return GraalSourceContainer.newContainer(SourceKind.FILE);
    }

    public GraalSourceContainer setCommonJS(CharSequence script) {
        return this.setJS(JSType.COMMON, script);
    }

    public GraalSourceContainer setModuleJS(CharSequence script, String name) {
        return this.setJS(JSType.MODULE, script, name);
    }

    public GraalSourceContainer setModuleJS(Path scriptFile, String name) {
        return this.setJS(JSType.MODULE, scriptFile, name);
    }

    public GraalSourceContainer setJS(JSType type, CharSequence script) {
        return this.setJS(type, script, null);
    }

    public GraalSourceContainer setJS(JSType type, CharSequence script, String name) {
        Objects.requireNonNull(type, "Null type");
        type.configure(this, script, name);
        return this;
    }

    public GraalSourceContainer setJS(JSType type, Path scriptFile, String name) {
        Objects.requireNonNull(type, "Null type");
        type.configure(this, scriptFile, name);
        return this;
    }

    public boolean isChanged() {
        return this.changed.get();
    }

    public boolean setChanged(boolean changed) {
        return this.changed.getAndSet(changed);
    }

    public boolean changed() {
        return this.setChanged(false);
    }

    public String getLanguage() {
        return this.language;
    }

    public GraalSourceContainer setLanguage(String language) {
        this.clearCache(!Objects.equals(this.language, language));
        this.language = language;
        return this;
    }

    public Object getOrigin() {
        return this.origin;
    }

    public GraalSourceContainer setOrigin(Object origin, String name) {
        if (origin != null && !this.isOriginCorrect(origin)) {
            throw new IllegalArgumentException("Illegal type of source origin (" + String.valueOf(origin.getClass()) + ")");
        }
        this.clearCache(!Objects.equals(this.origin, origin));
        this.origin = origin;
        return this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public GraalSourceContainer setName(String name) {
        this.clearCache(!Objects.equals(this.name, name));
        this.name = name;
        return this;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public GraalSourceContainer setMimeType(String mimeType) {
        this.clearCache(!Objects.equals(this.mimeType, mimeType));
        this.mimeType = mimeType;
        return this;
    }

    public Charset getFileEncoding() {
        return this.fileEncoding;
    }

    public GraalSourceContainer setFileEncoding(Charset fileEncoding) {
        this.clearCache(!Objects.equals(this.fileEncoding, fileEncoding));
        this.fileEncoding = fileEncoding;
        return this;
    }

    public Source source() {
        Source source = this.source;
        if (source == null) {
            this.source = source = this.createSource();
            LOG.log(System.Logger.Level.TRACE, "Creating new Graal source: " + String.valueOf(source));
        }
        return source;
    }

    abstract boolean isOriginCorrect(Object var1);

    abstract Source.Builder newBuilder(String var1, Object var2);

    private Source createSource() {
        Object origin = this.origin;
        String language = this.language;
        if (origin == null || language == null) {
            throw new IllegalStateException("Source container is not initialized: source origin is not set");
        }
        Source.Builder builder = this.newBuilder(language, origin);
        builder.mimeType(this.mimeType);
        builder.encoding(this.fileEncoding);
        if (this instanceof Literal) {
            return builder.buildLiteral();
        }
        try {
            return builder.build();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private void clearCache(boolean changed) {
        if (changed) {
            this.setChanged(true);
            this.source = null;
        }
    }

    public static enum SourceKind {
        LITERAL(Literal::new),
        BYTE_SEQUENCE(ForByteSequence::new),
        FILE(ForFile::new),
        URL(ForURL::new),
        READER(ForReader::new);

        private final Supplier<GraalSourceContainer> creator;

        private SourceKind(Supplier<GraalSourceContainer> creator) {
            this.creator = creator;
        }
    }

    static class Literal
    extends GraalSourceContainer {
        Literal() {
        }

        @Override
        boolean isOriginCorrect(Object origin) {
            return origin instanceof CharSequence;
        }

        @Override
        Source.Builder newBuilder(String language, Object origin) {
            return Source.newBuilder((String)language, (CharSequence)((CharSequence)origin), (String)this.getName());
        }
    }

    static class ForReader
    extends GraalSourceContainer {
        ForReader() {
        }

        @Override
        boolean isOriginCorrect(Object origin) {
            return origin instanceof URL;
        }

        @Override
        Source.Builder newBuilder(String language, Object origin) {
            return Source.newBuilder((String)language, (Reader)((Reader)origin), (String)this.getName());
        }
    }

    static class ForURL
    extends GraalSourceContainer {
        ForURL() {
        }

        @Override
        boolean isOriginCorrect(Object origin) {
            return origin instanceof URL;
        }

        @Override
        Source.Builder newBuilder(String language, Object origin) {
            return Source.newBuilder((String)language, (URL)((URL)origin)).name(this.getName());
        }
    }

    static class ForFile
    extends GraalSourceContainer {
        ForFile() {
        }

        @Override
        boolean isOriginCorrect(Object origin) {
            return origin instanceof File || origin instanceof Path;
        }

        @Override
        Source.Builder newBuilder(String language, Object origin) {
            File file;
            if (!this.isOriginCorrect(origin)) {
                throw new ClassCastException("Illegal type of source origin (" + String.valueOf(origin.getClass()) + ")");
            }
            if (origin instanceof Path) {
                Path path = (Path)origin;
                file = path.toFile();
            } else {
                file = (File)origin;
            }
            File file2 = file;
            return Source.newBuilder((String)language, (File)file2).name(this.getName());
        }
    }

    static class ForByteSequence
    extends GraalSourceContainer {
        ForByteSequence() {
        }

        @Override
        boolean isOriginCorrect(Object origin) {
            return origin instanceof ByteSequence;
        }

        @Override
        Source.Builder newBuilder(String language, Object origin) {
            return Source.newBuilder((String)language, (ByteSequence)((ByteSequence)origin), (String)this.getName());
        }
    }
}

