/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm;

import net.algart.graalvm.GraalCreationTools;
import org.graalvm.polyglot.Context;

public interface GraalContextCustomizer {
    public static final GraalContextCustomizer DEFAULT = new GraalContextCustomizer(){

        @Override
        public void customize(Context.Builder builder) {
        }

        public String toString() {
            return "default (pure)";
        }
    };
    public static final GraalContextCustomizer ALL_ACCESS = new GraalContextCustomizer(){

        @Override
        public void customize(Context.Builder builder) {
            builder.allowAllAccess(true);
        }

        public String toString() {
            return "all-access";
        }
    };

    public void customize(Context.Builder var1);

    default public boolean isJavaAccessSupported() {
        return false;
    }

    default public boolean isAllAccess() {
        return false;
    }

    default public Context.Builder newBuilder(String ... permittedLanguages) {
        Context.Builder builder = Context.newBuilder((String[])permittedLanguages);
        GraalCreationTools.correctClassLoader(builder);
        this.customize(builder);
        return builder;
    }
}

