/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.system;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.extensions.ExtensionSpecification;
import net.algart.executors.api.extensions.InstalledExtensions;
import net.algart.executors.api.jep.JepPlatforms;
import net.algart.executors.api.system.ExecutorLoaderSet;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.ExecutorSpecificationSet;
import net.algart.jep.additions.GlobalPythonConfiguration;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Language;

public final class SystemInformation
extends Executor
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_CURRENT_DIRECTORY = "current_directory";
    public static final String OUTPUT_SESSION_ID = "session_id";
    public static final String OUTPUT_CONTEXT_ID = "context_id";
    public static final String OUTPUT_CONTEXT_NAME = "context_name";
    public static final String OUTPUT_CONTEXT_PATH = "context_path";

    @Override
    public void process() {
        this.getScalar(OUTPUT_CURRENT_DIRECTORY).setTo(this.getCurrentDirectory());
        this.getScalar(OUTPUT_SESSION_ID).setTo(this.getSessionId());
        this.getScalar(OUTPUT_CONTEXT_ID).setTo(this.getContextId());
        this.getScalar(OUTPUT_CONTEXT_NAME).setTo(this.getContextName());
        this.getScalar(OUTPUT_CONTEXT_PATH).setTo(this.getContextPath());
        this.getScalar().setTo(this.information());
    }

    public String information() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Session ID: %s%n", this.getSessionId()));
        sb.append(String.format("Context ID: %s%n", this.getContextId()));
        sb.append(String.format("Context name: %s%n", this.getContextName()));
        sb.append(String.format("Context path: %s%n", this.getContextPath()));
        sb.append(String.format("This executor ID: %s%n", this.getExecutorId()));
        sb.append(String.format("Number of active threads: %d%n", Thread.activeCount()));
        sb.append(String.format("Number of CPU units: %d%n", Runtime.getRuntime().availableProcessors()));
        Path currentRelativePath = Paths.get("", new String[0]).toAbsolutePath();
        sb.append(String.format("Java home: %s%n", System.getProperty("java.home")));
        sb.append(String.format("Current OS directory: %s%n", currentRelativePath));
        sb.append(String.format("Current chain directory: %s%n", this.getCurrentDirectory()));
        sb.append(String.format("Current context class loader: %s%n", Thread.currentThread().getContextClassLoader()));
        sb.append("Python (JEP):%n".formatted(new Object[0]));
        String pythonHome = GlobalPythonConfiguration.INSTANCE.pythonHomeInformation().pythonHome();
        sb.append("    Python home directory: %s%n".formatted(pythonHome == null ? "n/a" : pythonHome));
        try (Context context = Context.newBuilder((String[])new String[0]).build();){
            Engine engine = context.getEngine();
            sb.append("GraalVM:%n".formatted(new Object[0]));
            sb.append("    Graal version: %s%n".formatted(engine.getVersion()));
            sb.append("    Graal implementation: %s%n".formatted(engine.getImplementationName()));
            Map languages = engine.getLanguages();
            sb.append("    Graal supported %d language%s: %n".formatted(languages.size(), languages.size() == 1 ? "" : "s"));
            for (Map.Entry entry : languages.entrySet()) {
                Language l = (Language)entry.getValue();
                sb.append("        %s: id \"%s\", name \"%s\", implementation \"%s\", version \"%s\"%n".formatted(entry.getKey(), l.getId(), l.getName(), l.getImplementationName(), l.getVersion()));
            }
        }
        ExecutorLoaderSet global = ExecutionBlock.globalLoaders();
        Set<String> allSessions = global.allSessionIds();
        sb.append(String.format("%n%d sessions with installed executors:%n", allSessions.size()));
        for (String sessionId : allSessions) {
            sb.append(String.format("    %s: %d executors%n", sessionId, global.allExecutorIds(sessionId, false).size()));
        }
        sb.append(String.format("%nInstalled extensions root:%n    %s%n", InstalledExtensions.EXTENSIONS_ROOT));
        sb.append(String.format("Installed extensions path list:%n    %s%n", InstalledExtensions.EXTENSIONS_PATH));
        try {
            sb.append(String.format("%nInstalled executors path:%n    %s%n", InstalledExtensions.installedExtensionsPaths().stream().map(Path::toString).collect(Collectors.joining(String.format("%n    ", new Object[0])))));
        }
        catch (Exception e) {
            sb.append("%nCANNOT find installed executors paths: ").append(e);
        }
        String classPath = System.getProperty("java.class.path");
        sb.append(String.format("%nJava class path:%n    %s%n", classPath == null ? "n/a" : classPath.replace(File.pathSeparator, String.format("%n    ", new Object[0]))));
        sb.append(String.format("%nSupplied Python root folders:%n    %s%n", String.join((CharSequence)String.format("%n    ", new Object[0]), JepPlatforms.pythonRootFolders())));
        sb.append(String.format("%nInstalled platforms:%n", new Object[0]));
        StringJoiner joiner = new StringJoiner(String.format(",%n", new Object[0]));
        for (ExtensionSpecification.Platform platform : InstalledExtensions.allInstalledPlatforms()) {
            joiner.add(String.format("%s%n[[%s%n    specifications folder: %s%n    modules folder: %s%n    libraries folder: %s%n    resources folder: %s%n    resolved valid paths in classpath: [%s]%n]]", platform.jsonString(), platform.isBuiltIn() ? "  built-in," : "", SystemInformation.folderToString(platform.specificationsFolderOrNull()), SystemInformation.folderToString(platform.modulesFolderOrNull()), SystemInformation.folderToString(platform.librariesFolderOrNull()), SystemInformation.folderToString(platform.resourcesFolderOrNull()), SystemInformation.pathsToString(platform.validClassPaths())));
        }
        sb.append(joiner);
        sb.append(String.format("%n%nSystem properties:%n", new Object[0]));
        new TreeMap<Object, Object>(System.getProperties()).forEach((key, value) -> sb.append(String.format("    %s: \"%s\"%n", key, value)));
        Collection<ExecutorSpecification> collection = ExecutorSpecificationSet.allBuiltIn().all();
        sb.append(String.format("%n%nAll %d executor specifications:%n", collection.size()));
        collection.forEach(executor -> sb.append(String.format("    %s    %s%n", executor.canonicalName(), executor.hasSpecificationFile() ? "--    " + String.valueOf(executor.getSpecificationFile()) : "(no file)")));
        return sb.toString();
    }

    private static String folderToString(Path folder) {
        return folder == null ? "N/A" : (Files.exists(folder, new LinkOption[0]) ? folder.toString() : String.valueOf(folder) + " - NOT exists!");
    }

    private static String pathsToString(Collection<Path> paths) {
        if (paths.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Path path : paths) {
            sb.append(String.format("%n        %s", path));
        }
        sb.append(String.format("%n    ", new Object[0]));
        return sb.toString();
    }

    public static void main(String[] args) {
        try (SystemInformation e = new SystemInformation();){
            System.out.println(e.information());
        }
    }
}

