/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.strings;

import net.algart.executors.api.Executor;

public final class SplitScalar
extends Executor {
    private static final String OUTPUT_PORT_PREFIX = "s";
    private String separator = "[\\s,;]+";
    private String defaultString = "";

    public SplitScalar() {
        this.addInputScalar(DEFAULT_INPUT_PORT);
        this.setDefaultOutputScalar(SplitScalar.outputPortName(0));
    }

    public String getSeparator() {
        return this.separator;
    }

    public SplitScalar setSeparator(String separator) {
        this.separator = SplitScalar.nonNull(separator);
        return this;
    }

    public String getDefaultString() {
        return this.defaultString;
    }

    public SplitScalar setDefaultString(String defaultString) {
        this.defaultString = SplitScalar.nonNull(defaultString);
        return this;
    }

    @Override
    public void process() {
        String concatenation = this.getInputScalar(true).getValueOrDefault(this.defaultString);
        String[] result = concatenation.split(this.separator);
        for (int k = 0; k < result.length; ++k) {
            String portName = SplitScalar.outputPortName(k);
            if (!this.hasOutputPort(portName)) continue;
            this.getScalar(portName).setTo(result[k]);
        }
    }

    private static String outputPortName(int outputIndex) {
        return OUTPUT_PORT_PREFIX + (outputIndex + 1);
    }
}

