/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.strings;

import java.text.MessageFormat;
import java.util.List;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.scalars.SeveralScalarsOperation;

public final class ConcatenateScalars
extends SeveralScalarsOperation {
    public static final String PROPERTY_PREFIX = "defaultS";
    private String separator = ", ";
    private String pattern = "";

    public ConcatenateScalars() {
        super(new String[0]);
    }

    public String getSeparator() {
        return this.separator;
    }

    public ConcatenateScalars setSeparator(String separator) {
        this.separator = ConcatenateScalars.nonNull(separator);
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public ConcatenateScalars setPattern(String pattern) {
        this.pattern = ConcatenateScalars.nonNull(pattern);
        return this;
    }

    @Override
    public void onChangeParameter(String name) {
        if (name == null || !name.startsWith(PROPERTY_PREFIX)) {
            super.onChangeParameter(name);
        }
    }

    @Override
    public SScalar process(List<SScalar> sources) {
        String result;
        boolean usePattern = !this.pattern.isEmpty();
        String separator = usePattern ? "" : this.separator.replace("\\n", "\n").replace("\\r", "\r");
        StringBuilder sb = new StringBuilder();
        int n = sources.size();
        Object[] arguments = new Object[n + 1];
        arguments[0] = "";
        for (int i = 0; i < n; ++i) {
            String s;
            SScalar scalar = sources.get(i);
            if (scalar != null && scalar.isInitialized()) {
                s = scalar.getValue();
            } else {
                s = this.parameters().getString(PROPERTY_PREFIX + (i + 1), null);
                if (s != null && s.isEmpty()) {
                    s = null;
                }
            }
            arguments[i + 1] = ConcatenateScalars.parseDoubleIfPossible(s);
            if (usePattern || s == null) continue;
            if (!sb.isEmpty()) {
                sb.append(separator);
            }
            sb.append(s);
        }
        if (usePattern) {
            String pattern = this.pattern.replace("\\n", "\n").replace("\\r", "\r");
            result = MessageFormat.format(pattern, arguments);
        } else {
            result = sb.toString();
        }
        return SScalar.of(result);
    }

    private static Object parseDoubleIfPossible(String s) {
        try {
            return s == null ? "" : Double.valueOf(Double.parseDouble(s));
        }
        catch (NumberFormatException e) {
            return s;
        }
    }
}

