/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.logical;

import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.logic.ConditionStyle;

abstract class AndOrBoolean
extends Executor {
    public static final String INPUT_PORT_PREFIX = "x";
    private final boolean initialAccumulator;
    private boolean invert = false;
    private ConditionStyle booleanStyle = ConditionStyle.JAVA_LIKE;
    private boolean commonInputStyle = true;

    public AndOrBoolean(boolean initialAccumulator) {
        this.initialAccumulator = initialAccumulator;
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    public boolean isInvert() {
        return this.invert;
    }

    public AndOrBoolean setInvert(boolean invert) {
        this.invert = invert;
        return this;
    }

    public ConditionStyle getBooleanStyle() {
        return this.booleanStyle;
    }

    public AndOrBoolean setBooleanStyle(ConditionStyle booleanStyle) {
        this.booleanStyle = AndOrBoolean.nonNull(booleanStyle);
        return this;
    }

    public boolean isCommonInputStyle() {
        return this.commonInputStyle;
    }

    public AndOrBoolean setCommonInputStyle(boolean commonInputStyle) {
        this.commonInputStyle = commonInputStyle;
        return this;
    }

    @Override
    public void process() {
        String portName;
        boolean result = this.initialAccumulator;
        int k = 0;
        while (this.hasInputPort(portName = INPUT_PORT_PREFIX + (k + 1))) {
            String input = this.getInputScalar(portName, true).getValue();
            result = this.combine(result, this.toBoolean(input));
            ++k;
        }
        if (this.invert) {
            result = !result;
        }
        this.booleanStyle.setScalar(this.getScalar(), result);
    }

    public boolean toBoolean(String inputString) {
        return this.commonInputStyle ? SScalar.toCommonBoolean(inputString, this.initialAccumulator) : this.booleanStyle.toBoolean(inputString, this.initialAccumulator);
    }

    abstract boolean combine(boolean var1, boolean var2);
}

